
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
pro polspl_evaluate,set2,xl,xh,c,nc,nr,fit
;+
; NAME:
;	POLSPL_EVAL
;
; PURPOSE:
;
;	evaluate the combined spline fitted from its coefficients.
;	To be used after calls to POSLPL
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	POLSPL_EVALUATE,set,xl,xh,c,nc,nr,fit
;
; INPUTS:
;	set: the fltarr(2,npoints) set with the original data
;	Y(i),i=1,npts           ordinates
;	W(i),i=1,npts           weighting factor in least squares fit
;	fit minimizes the sum of w(i)*(y(i)-poly(x(i)))**2
;	if uniform weighting is desired, w(i) must be 1.
;	XL,XH arrays contain NR adjacent ranges
;	over which to fit individual polynomials.  Array NC specifies
;	how many poly coeffs to use in each range and the array C contains
;	the polynomial coefficients resulting from the fit

;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;
; OUTPUTS:
;	fit is a set with the same abscissas of the input one and 
;	the coordinates are the result of the fit
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	None
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Straightforward
;
; EXAMPLE:
;
;	POLSPL,SET,XL,XH,C,NC,NR,C,FIT
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	February, 1993	
;-
on_error,2
;
fit = set2*0.0
;
;change xl(1) and xh(nr) to extrapolate the fit
xl(1) = min(set2(0,*))
xh(nr) = max(set2(0,*))
;
; calculatest the first point
;
xval=set2(0,0)
yval=0.0
for k=1,nc(1) do yval =  yval+ c(k) * xval^(k-1)
fit(0,0) = xval
fit(1,0) = yval
;
; now the rest of the points
;
for i=0,n_elements(set2(0,*))-1 do begin       ; loop over all the points
  for j=1,nr do begin                  ; loop over the # of intervals
    if ((set2(0,i) gt xl(j)) and (set2(0,i) le xh(j))) then begin
      cstart=total(nc(0:j-1))
      xval = set2(0,i)
      yval = 0.0
      for k=1,nc(j) do yval =  yval+ c(cstart+k) * xval^(k-1)
      fit(0,i) = xval
      fit(1,i) = yval
    endif
  endfor
endfor
;
return
end
