
;=========================== copyright =========================================
;                       XAID (XAfs with IDl) package.                          ;
;     Copyright European Synchrotron Radiation Facility (1993-1996).           ;
; This software may be used, copied, or redistributed as long as it is not     ;
; sold and this copyright notice is reproduced on each copy made.              ;
; The software is provided as is without any express or implied warranties     ;
; whatsoever.                                                                  ;
; Other limitations apply as described in the file README.copyright.           ;
;                                                                              ;
; REFERENCE: "XAID: A package for XAFS data analysis based on IDL"             ;
;       Manuel Sanchez del Rio. To be published at the proceedings of          ;
;       the 9th International Conference on X-ray Absorption Fine Structure    ;
;       26th - 30th August 1996,  E S R F - Grenoble  France                   ;
;==============================================================================;
function E2K,inset,e0=e0
;
;+
; NAME:
;	E2K
;
; PURPOSE:
;	This function change the scale from E (energy eV) to 
;	K (wavenumber, arstroms^(-1) ) of an input set, creating an output set
;
; CATEGORY:
;	XAID xafs data analysis package. 
;
; CALLING SEQUENCE:
;
;	outset = E2K (inset)
;
; INPUTS:
;	inset:fltarr(2,npoints) set of data
;
; OPTIONAL INPUTS:
;	
; KEYWORD PARAMETERS:
;	e0:	 value of the edge (in eV)
;
; OUTPUTS:
;	outset: the new outpot set with 1st column in K
;	input array."  
;
; OPTIONAL OUTPUTS:
;
; COMMON BLOCKS:
;
; SIDE EFFECTS:
;	The points with energy less than e0 are translated to points
;	with negative wavenumber, even if physically is not true
;	(Kinematical energy negative?)
;
; RESTRICTIONS:
;	None
;
; PROCEDURE:
;	Uses the standard formula: k = A sqrt(E-Eo) with A= 2 m (2 pi)^2 / h^2 
;	A=0.5123147 if E units are eV and k in A^(-1)
;
; EXAMPLE:
;
;	set_k = E2K (set_ev,e0=7765)		
;
; MODIFICATION HISTORY:
; 	Written by:	Manuel Sanchez del Rio. ESRF
;	January, 1993	
;-
;
on_error,2
;
; converts a set in energy to a set in k
; the negative energies are treated as negative k
;
if not(keyword_set(e0)) then e0=0.0
tmpx = inset(0,*) - e0
tmpx = ((tmpx gt 0) * 2-1) * sqrt(abs(tmpx)) * 0.5123147
;
outset = inset
outset(0,*) = tmpx
;
return, outset
end
