Pro xsh_bragg,inp,Group=group

;+
; NAME:
;	XSh_Bragg
;
; PURPOSE:
;	A driver for bragg
;
; CATEGORY:
;	SHADOW GUI
;	Widgets.
;
; CALLING SEQUENCE:
;	XSh_Bragg
;
; OPTIONAL INPUTS:
;	inp: the structure with the input parameters.
;	
; KEYWORD PARAMETERS:
;	Group:	The ID of the caller Widget. It is used for the Dialog
;		windows to be positioned.
; OUTPUTS:
;	None.
;
; COMMON BLOCKS:
;	XSH_BRAGG_COMMON contains the data structure for next calls
;		of the application [when called with no input].
;
; SIDE EFFECTS:
;	Creates a temporary file (xsh_bragg_tmp.inp) and runs 
;	bragg.
;
; RESTRICTIONS:
;
; PROCEDURE:
;	Straightforward.
;
; MODIFICATION HISTORY:
; 	Written by:	M. Sanchez del Rio, srio@esrf.fr
;	December 15, 1997
;
;-

COMMON xsh_bragg_common,str1

IF n_elements(inp) NE 0 THEN str1=inp ELSE $
  IF n_elements(str1) EQ 0 THEN $
     str1 = xsh_defaults_preprocessors('XSH_BRAGG')

action=''
str = str1.parameters
XScrMenu,str,Titles=str1.titles,/Notype,Action=action,/Interp,NCol=4,$
 WTitle='Bragg inputs',Help=str1.help_text,Flags=str1.flags
IF action EQ 'DONT' THEN Return
str1.parameters = str

Openw,unit,'xsh_bragg_tmp.inp',/Get_Lun

PRINTF,unit,STRCOMPRESS(str.Structure(0),/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(str.Lattice_Cte_a,/REMOVE_ALL)

IF (str.Structure(0) EQ 4 OR str.Structure(0) EQ 5) THEN $
  PRINTF,unit,STRCOMPRESS(str.Lattice_Cte_c,/REMOVE_ALL)

PRINTF,unit,STRCOMPRESS(str.h_miller_index,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(str.k_miller_index,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(str.l_miller_index,/REMOVE_ALL)

symbol_1 =  p_table(str.Symbol_1st,/SHADOW)
symbol_2 =  p_table(str.Symbol_2nd,/SHADOW)
PRINTF,unit,symbol_1
IF (str.Structure(0) EQ 0 OR str.Structure(0) EQ 1 OR str.Structure(0) EQ 3) $
 THEN PRINTF,unit,symbol_2

f0_table = xsh_f0(str,iask=fix(str.ionic_ask(0)) )
if n_elements(f0_table) EQ 1 then begin
  itmp = Dialog_Message(Dialog_Parent=group,/Error,$
   'Error reading F0 table. Abort bragg.')
  free_lun,unit
  return
endif
printf,unit,strcompress(f0_table(0,0),/rem)+','+strcompress(f0_table(1,0),/Rem)
printf,unit,strcompress(f0_table(0,1),/rem)+','+strcompress(f0_table(1,1),/Rem)
printf,unit,strcompress(f0_table(0,2),/rem)+','+strcompress(f0_table(1,2),/Rem)
if n_elements(f0_table) EQ 9 then begin
  printf,unit,strcompress(f0_table(0,0),/rem)+','+strcompress(f0_table(2,0),/Re)
  printf,unit,strcompress(f0_table(0,1),/rem)+','+strcompress(f0_table(2,1),/Re)
  printf,unit,strcompress(f0_table(0,2),/rem)+','+strcompress(f0_table(2,2),/Re)
endif 

PRINTF,unit,STRCOMPRESS(str.E_min,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(str.E_max,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(str.E_step,/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(str.Absorption(0),/REMOVE_ALL)
PRINTF,unit,STRCOMPRESS(str.Temperature_factor,/REMOVE_ALL)

file = STRCOMPRESS(str.shadow_file,/REMOVE_ALL)
IF checkfile(file) THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,/Question,$
	['File '+file+' exists.','Overwrite it?'])
  if itmp EQ 'No' then file = Dialog_Pickfile(/Write)
  if file EQ '' then begin
    itmp = Dialog_Message(Dialog_Parent=group,/Error,$
	'bragg aborted')
    free_lun,unit
    command  = '/bin/rm xsh_bragg_tmp.inp'
    Message,/info,'Executing: '+command
    return
  endif
  str.shadow_file = file
ENDIF
PRINTF,unit,file

PRINTF,unit,STRCOMPRESS(str.rc(0),/REMOVE_ALL)
IF STRCOMPRESS(str.rc(0),/REMOVE_ALL) EQ '1' THEN BEGIN
  PRINTF,unit,STRCOMPRESS(fix( str.RC_mode(0)  ) + 1 ,/REMOVE_ALL)
  PRINTF,unit,STRCOMPRESS(str.RC_energy,/REMOVE_ALL)
  PRINTF,unit,STRCOMPRESS(str.Mosaic(0),/REMOVE_ALL)
  IF (str.Mosaic(0) EQ 1) THEN BEGIN
    PRINTF,unit,STRCOMPRESS(str.Mosaic_fwhm,/REMOVE_ALL)
    PRINTF,unit,STRCOMPRESS(str.Thickness,/REMOVE_ALL)
    PRINTF,unit,'0'
  ENDIF ELSE BEGIN ; perfect
  ;
    if fix( str.RC_mode(0) )+1 NE 3 then $
	PRINTF,unit,STRCOMPRESS(str.Thickness,/REMOVE_ALL)
    IF fix(str.Mosaic(0)) EQ 0 THEN $
	PRINTF,unit,STRCOMPRESS(str.Asymmetric_angle,/REMOVE_ALL)
    PRINTF,unit,STRCOMPRESS(str.Angular_range,/REMOVE_ALL)
    PRINTF,unit,STRCOMPRESS(str.Number_of_points,/REMOVE_ALL)
    PRINTF,unit,STRCOMPRESS(str.Sec_of_arc(0),/REMOVE_ALL)
    PRINTF,unit,STRCOMPRESS(str.Centered_curve(0),/REMOVE_ALL)
    PRINTF,unit,'0'
  ENDELSE
ENDIF
free_lun,unit  
  
Widget_Control,/Hourglass
xsh_run,'bragg < xsh_bragg_tmp.inp'
command  = '/bin/rm xsh_bragg_tmp.inp'
Message,/info,'Executing: '+command
; Spawn, command

; 
; display RC values (if selected)
;
IF STRCOMPRESS(str.rc(0),/REMOVE_ALL) EQ '1' THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,['Xplot facility can be used',$
	'to display the output files: ','rock_curve[_inc,_ref].[s,p].  ',$
	' ','Do you want a plot?'],/Question)
  IF itmp EQ 'No' THEN RETURN
  values =  [ $
	'Incident RC s-pol','Incident RC p-pol','Reflected RC s-po',$
	'Reflected RC p-pol','Parameters']
  itmp = wmenu2([[replicate('Plot ',4),'Display ']+values,$
        'Cancel'], Dialog_Parent=group)
  IF itmp EQ 5 THEN RETURN

  title=str.Symbol_1st+STRCOMPRESS(str.h_miller_index,/REM)+ $
    STRCOMPRESS(str.k_miller_index,/REM)+  $
    STRCOMPRESS(str.l_miller_index,/REM)+  $
    '   E='+STRCOMPRESS(str.RC_Energy,/REM)+' eV;  t='+  $
    STRCOMPRESS(str.Thickness,/REM)+' cm; !4a!3='+   $
    STRCOMPRESS(str.Asymmetric_angle,/REM)+' Degrees'
  IF (str.Sec_of_arc(0) EQ 1) THEN $
    xtitle='!S!4h-h!LB!N!3[arc sec]'  $
  ELSE xtitle='!S!4h-h!LB!N!3[rad]' 
  ytitle=values(itmp)
  case itmp of
    0: BEGIN
      filein = 'rock_curve_inc.s'
      IF (str.Asymmetric_angle EQ 0.0) THEN filein = 'rock_curve.s'
      XPLOT,filein,GROUP=group,XTITLE=xtitle,YTITLE=ytitle,TITLE=title,$
	wtitle=filein
      END
    1: BEGIN
      filein = 'rock_curve_inc.p'
      IF (str.Asymmetric_angle EQ 0.0) THEN filein = 'rock_curve.p'
      XPLOT,filein,GROUP=group ,XTITLE=xtitle,YTITLE=ytitle,TITLE=title,$
	wtitle=filein
      END
    2:BEGIN
      filein = 'rock_curve_ref.s'
      IF (str.Asymmetric_angle EQ 0.0) THEN filein = 'rock_curve.s'
      XPLOT,filein,GROUP=group,XTITLE=xtitle,YTITLE=ytitle,TITLE=title, $
	wtitle=filein
      END		
    3:BEGIN
      filein = 'rock_curve_ref.p'
      IF (str.Asymmetric_angle EQ 0.0) THEN filein = 'rock_curve.p'
      XPLOT,filein,GROUP=group,XTITLE=xtitle,YTITLE=ytitle,TITLE=title,$
	wtitle=filein
      END
    4:XDISPLAYFILE1,'rock_curve.par',GROUP=group
  endcase
ENDIF

END


