function retrace,shadow_in,DISTANCE=distance
;+
; NAME:
;	RETRACE 
; PURPOSE:
;	traces a SHADOW file a distance in vacuum
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	shadow_out = RETRACE(shadow_in,DISTANCE=distance)
; INPUTS:
;	shadow_in   IDL structure with SHADOW data
; OPTIONAL INPUTS:
; KEYWORD PARAMETERS:
;	DISTANCE  = distance the distance from the input position where
;			data has to be evaluated
; OUTPUTS:
;	a new IDL-SHADOW structure with the new data
; OPTIONAL OUTPUT PARAMETERS:
; COMMON BLOCKS:
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
;	None.
; PROCEDURE:
;	Similar to SHADOW's RETRACE
; MODOFICATION HISTORY:
;       93/08/02 MSR
;	96/06/24 MSR fix a bug: before it was
;	  {x,y,z} = {xo,yo,zo} + distance*{xprime,yprime,zprime}
;	  and now:
;	  {x,y,z} = {xo,yo,zo} + [(distance-yo)/yprime]*{xprime,yprime,zprime}
;	  (both are approximately equivalent in the far field for 
;	  mostly axial rays). 
;
;	  For Info: SHADOW's retrace uses:
;	  {x,y,z} = {xo,yo,zo} + [(distance)/yprime]*{xprime,yprime,zprime}
;	  which is equivalent to the previous expression when analyzing
;	  start and screen files, but it may differ when analyzing 
;	  begin.dat files when the source has a depth.
;-
on_error,2
;
; load shadow-idl structure and define arrays and constants
;
shadow_out = readsh(shadow_in)
;
; retraces the beam
;
if not(keyword_set(distance)) then distance=0.0D0 else distance=double(distance)
yphase = getshcol(shadow_out,[2,5])
yprime = yphase(1,*)

rdist = distance-yphase(0,*)/yprime
perp_rays = where(yprime LT 1.0D-16)
if n_elements(perp_rays) GT 0 then $
  if perp_rays NE -1 then begin
    rdist(where(yprime LT 1.0D-16)) = 0.0D0  
    rdist(where(yprime GE 1.0D-16)) = distance(where(yprime GT 1.0D-16))/ $
	(yprime(where(yprime GT 1.0D-16)))
  endif

for i=0,2 do begin
  shadow_out.ray(i,*) = shadow_out.ray(i,*)+ rdist*shadow_out.ray(i+3,*)
endfor
return,shadow_out
end
