pro plotspace, shadow_in, TOP=top
;+
; NAME:
;	PLOTSPACE 
; PURPOSE:
;	an IDL implementation of the PLOTSPACE SHADOW's utility
; CATEGORY:
;	SHADOW's utilities.
; CALLING SEQUENCE:
;	plotspace, shadow_in, keyword_parameters
; INPUTS:
;	shadow_in   SHADOW file or IDL structure with SHADOW data
; KEYWORD PARAMETERS:
;	TOP = When set, in addition to the plotspace plots
;		(x,z),x',z'),(x,x') and (z,z') it plots the 
;		top view (y,x) and the side view (y,z).
;
;	OUTPUTS:
;	a plot on the screen
; SIDE EFFECTS:
; 	None.
; RESTRICTIONS:
; 	None.
; KNOWN BUGS:
; PROCEDURE:
;	Similar to SHADOW's original.
; EXAMPLES:
;		plotspace,'begin.dat'
;
; MODOFICATION HISTORY:
;	M. Sanchez del Rio. ESRF. Grenoble Apr 29 1998
;-
;on_error,2

catch, error_status
 if error_status ne 0 then begin
   catch, /cancel
   message,/info,'Error caught: '+!err_string
   if sdep(/w) then itmp = dialog_message(/Error,Dialog_Parent=group,$
	'PLOTSPACE: Error caught: '+!err_string)
   goto,out
endif

p_multi_old=!p.multi
if keyword_set(top) then !p.multi=[0,2,3] else !p.multi=[0,2,2]
;
; load shadow-idl structure and define arrays and constants
;
shadow_out = readsh(shadow_in,GROUP=group)
if type(shadow_out) NE 8 then message,'bad input'
;
plot,shadow_out.ray(0,*),shadow_out.ray(2,*),psym=3,title="(x,z)"
plot,shadow_out.ray(3,*),shadow_out.ray(5,*),psym=3,title="(x',z')"
plot,shadow_out.ray(0,*),shadow_out.ray(3,*),psym=3,title="(x,x')"
plot,shadow_out.ray(2,*),shadow_out.ray(5,*),psym=3,title="(z,z')"
if keyword_set(top) then begin
  plot,shadow_out.ray(1,*),shadow_out.ray(0,*),psym=3,title="(y,x)"
  plot,shadow_out.ray(1,*),shadow_out.ray(2,*),psym=3,title="(y,z)"
endif

OUT:
!p.multi = p_multi_old
end
