Function column_name,col
;
; Returns Shadow column description
; To be used internally by plotxy, histo1, etc...
;
; srio@esrf.fr 7-Apr-1998
;

out = ['0: <none>', $
   '1: X [user unit]','2: Y [user unit]','3: Z [user unit]', $
   '4: Xp [rads]','5: Yp [rads]','6: Zp [rads]',$
   '7: Es X component','8: Es Y component','9: Es Z component', $
   '10: Lost Ray Flag','11: Energy [eV]','12: Ray Index', $
   '13: Optical Path Length','14: Es Phase','15: Ep Phase', $
   '16: Ep X component','17: Ep Y component','18: Ep Z component', $
   '19: Empty','20: R= SQRT(X^2+Y^2+Z^2)','21: angle from Y axis', $
   '22: Electromagnetic vector magnitude','23: |E|^2 (total intensity)',$
   '24: total intensity for s-polarization', $
   '25: total intensity for p-polarization', $
   '26: Empty','27: Empty','28: Empty','29: Empty', $
   '30: S0-stokes = |Es|^2 + |Ep|^2 ', $
   '31: S1-stokes = |Es|^2 - |Ep|^2 ', $
   '32: S2-stokes = 2 |Es| |Ep| cos(ph_s-ph_p)', $
   '33: S3-stokes = 2 |Es| |Ep| sin(ph_s-ph_p)']


if n_params() GE 1 then begin
  col = (( col > 0 ) < 33)
  return,out(col)
endif else return, out
end
