;

pro plotslit,slit,fill=fill
on_error,2
if keyword_set(fill) then polyfill, $
  [slit(0),slit(2),slit(2),slit(0),slit(0)], $
  [slit(1),slit(1),slit(3),slit(3),slit(1)],color=fill else $
oplot,$
  [slit(0),slit(2),slit(2),slit(0),slit(0)], $
  [slit(1),slit(1),slit(3),slit(3),slit(1)]
end
;
;


function bar_pattern,motif,t,n , $
  fill=fill,plot=plot,check=check,cart=cart,solid=solid, center = center,$
  xrange=aax1,yrange=aay1

on_error,2
;if n_params() lt 3 then begin
;  print,'BAR_PATTERN: Usage: tmp = bar_pattern(motif,t,n) [where: '
;  print,'BAR_PATTERN:     motif = [x0,y0,x1,y1] defines the motif, '
;  print,'BAR_PATTERN:     t = [tx,ty] defines translations         '
;  print,'BAR_PATTERN:     n = [nx,ny] defines number of translations.'
;  return,0
;endif
if keyword_set(plot) then erase
out = 0
if not(keyword_set(motif)) then motif = [-.03,-.03,.03,.03]
if not(keyword_set(t)) then t = [.12,.12]
if not(keyword_set(n)) then n = [7,7]
if not(keyword_set(center)) then center = [0.,0.]

;plot,[0,0],xra=[-1,1],yra=[-1,1],/nodata
;cart_axes,[-1,1],[-1,1]
if keyword_set(plot) then begin
   sx = abs(motif(2)-motif(0))/2
   sy = abs(motif(3)-motif(1))/2
   if keyword_set(aax1) then aax = aax1 else begin
     aax = [-t(0)*(n(0)/2) < (-sx),t(0)*(n(0)/2) > (sx)]
     aax = aax + center(0)
   endelse
   if keyword_set(aay1) then aay = aay1 else begin 
     aay =  [-t(1)*(n(1)/2) < (-sy),t(1)*(n(1)/2) > (sy)]
     aay = aay + center(1)
   endelse
   print,aax
   print,aay
   if keyword_set(cart) then cart_axes,aax,aay else $
           plot,[0,0],xrange=aax,yrange=aay,/nodata
endif
if keyword_set(check) then begin
   if keyword_set(solid) then out = check(0,*)*0+1  else out = check(0,*)*0-1
endif

for ix = 0,n(0)-1 do begin
  for iy = 0,n(1)-1 do begin
    ttx = (ix - n(0)/2)*t(0) + center(0)
    tty = (iy - n(1)/2)*t(1) + center(1)
    ;print,'>>>>>>>',ttx,tty
    ;
    ; plot grid 
    ;
    motif2 = [motif(0)+ttx,motif(1)+tty,motif(2)+ttx,motif(3)+tty]
    if keyword_set(plot) then $
       plotslit,motif2, fill=fill
    if keyword_set(check) then begin
      tmp = where( ((check(0,*) gt motif2(0)) and (check(0,*) le motif2(2)) $
           and     (check(1,*) gt motif2(1)) and (check(1,*) le motif2(3))) $
                   ,count)
      ;help,tmp
      ;help,count
      if count gt 0 then  begin
         if keyword_set(solid) then out(tmp) = -1 else out (tmp) = 1
      endif
    endif

  endfor
endfor
if keyword_set(check) and keyword_set(plot) then $
    oplot,check(0,*),check(1,*),psym=3
return,out
end


