function read_optical_system, file, end_file=end_file, group=group

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Catch, /cancel
   Message,/Info,'error caught: '+!error_state.msg
   IF SDep(/w) THEN itmp = Dialog_Message(/Error,$
        'read_optical_system: error caught: '+!error_state.msg)
   RETURN,0
ENDIF


if n_elements(end_file) eq 0 then end_file=0

system=obj_new('optical_system')
IF CheckFile(file) NE 1 THEN BEGIN
  itmp = Dialog_Message(Dialog_Parent=group,'System file not found: '+file,/Error)
  RETURN,system
ENDIF
openR, lun, file, /get_lun
p=0
files=['files to open']
name=string('')
WHILE NOT EOF(lun) DO BEGIN
   READF, lun, name
   ;PRINT, name
   files=[files,name]
   p=p+1
ENDWHILE
close, lun

; get the path files
fileB=byte(file)
s=size(fileB)
n=s[1]
p=n-1

bb = (byte(sdep(/ds)))[0]
;bb=92
while (fileB[p] ne bb) and (p gt 0) do begin
	p=p-1
endwhile

;srio if p eq 0 then return, obj_new()
;srio path=string(fileB[0:p])
IF p EQ 0 THEN BEGIN 
  cd,Current=path 
  path=path+SDep(/ds)
ENDIF ELSE path=string(fileB[0:p])

s=size(files)
dim={t_source:0.0, t_image:0.0, t_incidence:0.0, t_reflection:0.0, alpha:0.0, $
			rlen1:0.0, rlen2:0.0, rwidx1:0.0, rwidx2:0.0, prof:0.03, $
			file_name:string(''), type_name:string(''), color:[100,100,255], mesh_file:'undefined'}
for r=1, s[1]-1 do begin
	current_file= path + files[r]
	if end_file ne 0 then begin
		pos = STRPOS(current_file, 'start')
		current_file=strep(current_file,'R',pos,'  end')
		current_file= strep(current_file,'D',pos, 2)
	endif

	data=read_gfile(current_file)

	if end_file eq 0 then modif=1. else modif=180./!DPI

	dim.t_source=data.t_source
	dim.t_image=data.t_image
	dim.t_incidence=data.t_incidence * modif
	dim.t_reflection=data.t_reflection * modif
	dim.alpha=data.alpha * modif
	dim.file_name=current_file

	fshape=data.fshape
	fhit_c=data.fhit_c

    case fshape of
	      0: dim.type_name='Rectangle'
	      1: dim.type_name='Rectangle'
	      2: dim.type_name='Ellipse'
	      3: dim.type_name='Ellipse with a hole'
	      else: begin
		        print, 'Unknow!'
		        return, obj_new()
		        end
    endcase

    if fhit_c eq 0 then begin
    	 dim.type_name='Infinite surface'
	     dim.rlen1=0.3
	     dim.rlen2=0.2
	     dim.rwidx1=0.3
	     dim.rwidx2=0.2
    endif else begin
	     dim.rlen1=abs(data.rlen1)
	     dim.rlen2=abs(data.rlen2)
	     dim.rwidx1=abs(data.rwidx1)
	     dim.rwidx2=abs(data.rwidx2)
    endelse
    optic=blv_create_optical_module(dim)
    ;****get the file name of the beam data for eatch plane
    ;****for the source plane
    if r eq 1 then begin
    	optic->getProperty, planesSource=cps
		plane=cps->get(pos=0)
    	plane->setProperty, beam_file= path + 'begin.dat'
    endif else begin
    	num=string(r-1)
		;to delete blank caractere
		temp=byte(num)
		e=0
		while(temp[e] eq 32) do e=e+1
		num=string(temp[e:*])
		bFile='star.0'+num
		optic->getProperty, planesSource=cps
		plane=cps->get(pos=0)
    	plane->setProperty, beam_file= path + bFile
    endelse

    ;****for the element plane
	num=string(r)
	;to delete blank caractere
	temp=byte(num)
	e=0
	while(temp[e] eq 32) do e=e+1
	num=string(temp[e:*])
	bFile='mirr.0'+num
	optic->getProperty, planeElement=plane
	plane->setProperty, beam_file= path + bFile

    ;****for the image plane
    num=string(r)
	;to delete blank caractere
	temp=byte(num)
	e=0
	while(temp[e] eq 32) do e=e+1
	num=string(temp[e:*])
	bFile='star.0'+num
	optic->getProperty, planesImage=cpi
	plane=cpi->get(pos=0)
    plane->setProperty, beam_file= path + bFile

    ;***for the added plane
    nb_planes=data.N_SCREEN
    for plane=0, nb_planes-1 do begin
    	if data.i_screen[plane] eq 1 then sign=-1  else sign=1
	    distance=data.sl_dis[plane]*sign

	    ; added by srio: it positioned wrongly screens at zero distance
	    IF distance EQ 0 THEN distance = 0.001*sign

	    numR=string(r)
		;to delete blank caractere
		temp=byte(numR)
		e=0
		while(temp[e] eq 32) do e=e+1
		numR=string(temp[e:*])
		numP=string(plane+1)
		;to delete blank caractere
		temp=byte(numP)
		e=0
		while(temp[e] eq 32) do e=e+1
		numP=string(temp[e:*])
	    file='screen.0'+numR+'0'+numP
	    print, path + file
		optic->add_plane, distance, file= path + file
    endfor
	system->add_module, optic
endfor

return, system
end
