;+
;=================================   ncrystal   ================================
;
;
;   Ncrystal is a widget based graphical interface to calculate neutron 
;   diffraction profiles of perfect and mosaic crystals. It allows Bragg 
;   and Laue geometries and diffracted and transmitted intensity calculations. 
;   The diffracted intensity can be calculated as a function of 
;   either rock angle or neutron energy/wavelength/speed.
;   It uses the DABAX database to define the crystal structure and to
;   retrieve the scattering lengths to build the crystal structure factors.
;
;   It interfaces diff_pat, a computer program written by M. Sanchez del Rio
;   (srio@esrf.fr) derived from the SHADOW application bragg. diff_patt
;   was modified by Lucia Alianelli (alianell@ill.fr) for neutron diffraction.
;
;
; DESCRIPTION OF THE CONTROLS IN THE MAIN WINDOW:
;
;  File:
;    Ncrystal input parameters: This option allows to save the current
;		parameters to a file for later loading. It also allows
;		to save the current parameters as defaults for being
;		used when the application is initialized. In the last
;		case, the file is named "application".xop (where
;		"application " is the name of the current XOP
;		application) and is written in the directory pointed
;		by the XOP_DEFAULTS_DIR environment variable (which
;		must be set). The parameter file is ASCII and can be
;		read and edited with care.
;  Quit: to exit from the program
;
; Set_Parameters:
;  Set Parameters: to define the parameters for the calculation.
;		The same result is obtained pressing the "Set Parameters"
;		button in the main NCrystal window.
;               Please refer to the information under the HELP
;		button for a complete description of the parameters. After
;		pressing the ACCEPT button, diff_pat starts running.
;  Set Defaults: Sets the default parameters.
;
;  Show: Display results
;   Diffraction Curve: starts a graphical window with the calculation results.
;   Crystal Parameters: shows output parameters of the calculation.
;   Crystallographic Parameters: shows numerical values used to build the
;		crystal structure factor.
;
;  Help:   Shows the ncrystal help (this text).
;
;
; COPYRIGHT:
;	ncrystal  belongs to XOP package and it is distributed within XOP.
;	PLEASE REFER TO THE XOP COPYRIGHT NOTICE BEFORE USING IT.
;
; CREDITS:
;	Published calculations made with XOP should refer:
;
;	  L. Alianelli, M. Sanchez del Rio and R. Felici
;	  "NOP: A new software tool for neutron optics"
;	  To be published in Physica B at the proceedings of the 
;	  ECNS 2003 conference.
;
;	  M. Sanchez del Rio and R. J. Dejus "XOP: Recent Developments"
;	  SPIE proceedings vol. 3448, pp.340-345, 1998.
;
; LAST MODIFICATION: msr/msr/2003-04-07
;
;-
; ----------------------------------------------------------------------
;
;       Modification history:
;              03/03   alianell@ill.fr: xcrystal -> ncrystal
;              03/04   srio@esrf.fr: Cosmetics.
;
;========================================================================
;
FUNCTION NCRYSTAL_version
return,'1.0'
end
;
;========================================================================
;
PRO NCrystal_Inp_Write,state, Group=group


Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'NCRYSTAL_INP_WRITE: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF
;
; write the contents of the structure with parameters for running reflex
;
inp = state.str.parameters
name='ncrystal.inp'
;
Openw,unit,name,/GET_LUN
;
;
Printf,unit,state.str.bragg.parameters.outfil
Printf,unit,inp.mosaic(0)

Printf,unit,state.str.parameters.geometry(0)

if strcompress(inp.mosaic(0),/rem) EQ 0 then begin ; perfect
  Printf,unit,StrCompress(state.str.parameters.Thickness,/Remove_All)
  Printf,unit,StrCompress(state.str.parameters.asymmetry_angle,/Remove_All)
endif else begin  ; mosaic
;;srio  Printf,unit,StrCompress(state.str.parameters.alpha,/Remove_All)
  Printf,unit,StrCompress(state.str.parameters.asymmetry_angle,/Remove_All)
  Printf,unit,StrCompress(state.str.parameters.Mosaic_fwhm,/Remove_All)
  Printf,unit,StrCompress(state.str.parameters.Thickness,/Remove_All)
endelse

scanFlag= 1+fix(state.str.parameters.scan(0))
Printf,unit,StrCompress(scanFlag)

;Printf,unit,StrCompress(state.str.parameters.Energy,/Remove_All)
fixValue = state.str.parameters.Energy

if scanFlag EQ 4 then begin   ;ENERGY SCAN = FIXED ANGLE
    ScanFromORIG =  state.str.parameters.ScanFrom
    ScanToORIG =  state.str.parameters.ScanTo
;    Original calculation files need to get the energy in terms of Photon energy
;    So Neutrons unit is converted to photons one (EV) in this section ...
    case strcompress(state.str.parameters.EUnit(0),/rem) of
        '0': begin   ;NEUTRON WAVELENGTH TO PHOTON ENERGY
             ScanFrom = physical_constants('HC')/ScanToORIG
	         ScanTo = physical_constants('HC')/ScanFromORIG
	         end
        '1': begin   ;NEUTRON ENERGY TO PHOTON ENERGY
             ScanFrom = sqrt(physical_constants('MNE')*2.0E+3*ScanFromORIG)
             ScanTo =  sqrt(physical_constants('MNE')*2.0E+3*ScanToORIG)
             end
        '2': begin   ;NEUTRON VELOCITY TO PHOTON ENERGY
             ScanFrom = physical_constants('MN')*$
             physical_constants('C')*ScanFromORIG/physical_constants('EC')
             ScanTo =  physical_constants('MN')*$
             physical_constants('C')*ScanToORIG/physical_constants('EC')
             end
        else:
        endcase
    case StrCompress(state.str.parameters.unit(0),/Rem) of
; convertion of fixed value to degres
        '0': fixValue = fixValue*180.0/!pi
        '1': fixValue = fixValue*180.0/!pi*1.0E-6
        '2':
        '3': fixValue = fixValue/3600.0
        else:
        endcase
endif else begin    ; ANGULAR SCAN
    case StrCompress(state.str.parameters.EUnit(0),/Rem) of
        '0': fixValue = physical_constants('HC')/fixValue
        '1': fixValue = sqrt(physical_constants('MNE')*2.0E+3*fixValue)
        '2': fixValue = physical_constants('MN')*$
        physical_constants('C')*fixValue/physical_constants('EC')
        else:
        endcase
    ScanFrom =  state.str.parameters.ScanFrom
    ScanTo =  state.str.parameters.ScanTo
;    case strcompress(state.str.parameters.unit(0),/rem) of
;        '0': begin   ; RADIANS TO DEGRES
;             ScanFrom = ScanToORIG*180.0/!pi
;	         ScanTo = ScanFromORIG*180.0/!pi
;	         end
;        '1': begin   ; microRADIANS TO DEGRES
;             ScanFrom = ScanFromORIG*180.0/!pi*1.0E-6
;             ScanTo = ScanToORIG*180.0/!pi*1.0E-6
;             end
;        '2': begin   ; ALREADY IN DEGRES
;             ScanFrom = ScanFromORIG
;             ScanTo = ScanToORIG
;             end
;        '3': begin   ; ARC SEC TO DEGRES
;             ScanFrom = ScanFromORIG/3600.0
;             ScanTo = ScanToORIG/3600.0
;             end
;        else:
;        endcase
    endelse

Printf,unit,StrCompress(string(fixValue,Format='(F16.9)'),/Remove_All)
if scanFlag LE 3 then $
  Printf,unit,StrCompress(state.str.parameters.Unit(0),/Remove_All)
  Printf,unit,StrCompress(string(ScanFrom,Format='(F16.9)'),/Remove_All)
  Printf,unit,StrCompress(string(ScanTo,Format='(F16.9)'),/Remove_All)
  Printf,unit,StrCompress(state.str.parameters.ScanPoints,/Remove_All)
;
  Free_Lun,unit
;
END
;=======================================================================
;
PRO Ncrystal_EVENT,event


;Catch, error_status
;IF error_status NE 0 THEN BEGIN
;   Message,/Info,'error caught: '+!err_string
;   itmp = Dialog_Message(/Error,Dialog_Parent=event.top, $
;     'NCRYSTAL_EVENT: error caught: '+!err_string)
;   Catch, /Cancel
;   If Type(stateid) EQ 3 THEN $
;     If Widget_Info(stateid,/Valid_Id) AND N_Elements(state) NE 0 THEN $
;     Widget_Control,stateid,Set_UValue=state ; ,/No_Copy
;   On_Error,2
;   RETURN
;ENDIF
;
; register the events
;
Widget_control, event.id, Get_uvalue=eventuval

stateid = Widget_Info(event.handler,/Child)
Widget_control, stateid,  Get_uvalue=state ; ,/No_Copy

;inp = state.str

CASE eventuval OF

    'FILEINPUT': BEGIN
        action=''
        Widget_Control,event.id, Get_Value=action
        CASE action OF
           'Load from file...': BEGIN
             ;if sdep() EQ 'UNIX' then filter='*.xop' else filter=0
	         filter='*.xop'
             str_par = Xop_Input_Load(Title=$
             'Select Ncrystal input file...',$
             /NoConf,Filter=filter,Group=event.top)
             IF Type(str_par) EQ 8 THEN BEGIN
               tmp = state.str.parameters
               Copy_Structure,str_par, tmp, Group=event.top ; , /OnlyFirstField
               state.str.parameters = tmp
             ENDIF
             END
           'Save to file...': BEGIN
             str_par = state.str.parameters
             Xop_Input_Save,str_par,File='ncrystal.xop',$
               /Write, Group=event.top, Comment='; xop/ncrystal(v'+$
             ncrystal_version()+') input file on '+SysTime()
             END
           'Save as default': BEGIN
             str_par = state.str.parameters
             Xop_Input_Save,str_par,Group=event.top, $
               Default='ncrystal.xop',Comment='; xop/ncrystal(v'+$
             ncrystal_version()+') input file on '+SysTime()
             END
         ENDCASE
       END


	'QUIT': BEGIN
        	files = ['ncrystal.bra','diff_pat.dat','diff_pat.par',$
		  'ncrystal.inp']
		Delete_Files,files,Group=event.top
		Widget_control,event.top,/Destroy
		RETURN
		END
	'SETDEF': BEGIN
		itmp = widget_message(dialog_parent=event.top,$
		  /Question,['This option initializes the Ncrystal parameters ',$
		  'to their default values.',$
		  'Then you must click Set_parameters and then click ',$
		  '"Accept" to run the program.',$
		  'Please confirm you want to act this way by clicking "Yes".'],$
		  title='Ncrystal')
		if itmp eq 'No' then goto,out
		state.str = state.str_defaults
		END
	'SETPAR': BEGIN
		str_par = state.str.parameters
		sep = sdep(/ds)
;        helpcmd = "xdisplayfilenative,'"+Xop_GetEnv('XOP_HOME')+$
;                  sep+'extensions'+sep+'nop'+set+'doc'+sep+"ncrystal_par.txt'"

		helpcmd = "xdisplayfilenative,'"+Xop_GetEnv('XOP_HOME')+$
		  sep+'extensions'+sep+'nop'+sep+'doc'+sep+"ncrystal_par.txt'"
		Xscrmenu,str_par,Group=event.top,Ncol=3,Action=action,$
		Titles=state.str.titles, Flags=state.str.flags, $
		/NoType, /Interp, Wtitle='Ncrystal input parameters',$
		help=helpcmd
		IF (action EQ 'DONT') THEN Goto,out
		Widget_control,/Hourglass
		state.str.parameters = str_par
		Ncrystal_Inp_Write,state, Group=event.top
		; bragg
		strbragg = state.str.bragg
		strbragg.parameters.filef0 = str_par.filef0
		strbragg.parameters.polar = str_par.polar(0)
		fixValue = str_par.Energy

; conversion from neutron unit to photon unit needed for calculation is made here
; -----------------------------------------------------------------------------------
		if strcompress(str_par.Scan(0),/rem) EQ '3' then begin    ; ENERGY SCAN
		    ScanFromORIG =  str_par.ScanFrom
            ScanToORIG =  str_par.ScanTo
            case strcompress(state.str.parameters.EUnit(0),/rem) of
                '0': begin       ;NEUTRON WAVELENGTH (A) TO PHOTON ENERGY (eV)
                     ScanFrom = physical_constants('HC')/ScanToORIG
	                 ScanTo = physical_constants('HC')/ScanFromORIG
	                 end
                '1': begin       ;NEUTRON ENERGY (meV) TO PHOTON ENERGY (eV)
                     ScanFrom = sqrt(physical_constants('MNE')*2.0E+3*ScanFromORIG)
                     ScanTo =  sqrt(physical_constants('MNE')*2.0E+3*ScanToORIG)
                     end
                '2': begin       ;NEUTRON VELOCITY (m/s) TO PHOTON ENERGY (eV)
                     ScanFrom = physical_constants('MN')*physical_constants('C')*ScanFromORIG/physical_constants('EC')
                     ScanTo =  physical_constants('MN')*physical_constants('C')*ScanToORIG/physical_constants('EC')
                     end
                else:
                endcase
	        strbragg.parameters.estep = (ScanTo-ScanFrom)/100.d0
		    strbragg.parameters.emin = ScanFrom -1
		    strbragg.parameters.emax = ScanTo + $
            strbragg.parameters.estep + 1
		endif else begin
		    case StrCompress(state.str.parameters.EUnit(0),/Rem) of
                '0': fixValue = physical_constants('HC')/fixValue
;                '1':
                '1': fixValue = sqrt(physical_constants('MNE')*2.0E+3*fixValue)
                '2': fixValue = physical_constants('MN')*physical_constants('C')*fixValue/physical_constants('EC')
                else:
                endcase
		    strbragg.parameters.emin = fixValue - 0.1d0*fixvalue
		    strbragg.parameters.emax = fixValue + 0.1d0*fixvalue
		    strbragg.parameters.estep = 0.1d0*fixvalue
            endelse
		strbragg.parameters.ilattice = str_par.Crystal_material
		strbragg.parameters.hmiller = str_par.Miller_index_h
		strbragg.parameters.kmiller = str_par.Miller_index_k
		strbragg.parameters.lmiller = str_par.Miller_index_l
		strbragg.parameters.sig_tds = str_par.sig_tds
		strbragg.parameters.DWf = str_par.DWf
		strbragg.parameters.expans = str_par.expans
;;		strbragg.parameters.alpha = str_par.alpha
		Message,/Info,'Running nbragg_calc'
		tmp = nbragg_calc(strbragg)
		Message,/Info,'Writing results (nbragg_out)'
		nbragg_out,tmp
		;srio if sdep() EQ 'WINDOWS' then code = 'diff_pat' else $
		;srio   code = 'diff_pattern'
		command = 'ndiff_pat < ncrystal.inp'
		Xop_Spawn,command
		;; for test spawn,'ndiff_pat < ncrystal.inp'
		END
    'HELP': Xhelp,'ncrystal',Group=event.top
	'SHOW':	BEGIN
		WIDGET_CONTROL,event.id,GET_VALUE=eventval
		root='diff_pat' 
		ffile = root+'.dat'
		size_inp = SIZE(state.str.parameters)
                IF (checkfile(ffile) EQ 0 OR  size_inp(1) EQ 0) THEN BEGIN
                  message,/info,'File not found. '
                  itmp = Dialog_Message(dialog_parent=event.top,$
                        /ERROR,['Crystal data file not found...',$
                        'Set Parameters before...  '])
                  Goto,Out
                ENDIF


                case strcompress(state.str.parameters.EUnit(0),/rem) of
                '0': eunit=' Lambda(A)='       ;NEUTRON WAVELENGTH (A) TO PHOTON ENERGY (eV)
                '1': eunit=' E(meV)='       ;NEUTRON ENERGY (meV) TO PHOTON ENERGY (eV)
                '2': eunit=' v(m/s)='       ;NEUTRON VELOCITY (m/s) TO PHOTON ENERGY (eV)
                else: eunit='??'
                endcase



		  title='Crystal '+ncrystal_version()+' '+ $
state.str.parameters.Crystal_material( fix(strcompress(state.str.parameters.Crystal_material(0),/rem)) + 1) +$
' '+STRCOMPRESS(state.str.parameters.Miller_index_h,/REM)+$
STRCOMPRESS(state.str.parameters.Miller_index_k,/REM)+$
STRCOMPRESS(state.str.parameters.Miller_index_l,/REM)+$
eunit+STRCOMPRESS(state.str.parameters.Energy,/REM)+$
' t='+STRCOMPRESS(state.str.parameters.Thickness,/REM)+' cm'

		  CASE eventval OF
		  "Diffraction curve": $
			XPLOT,SPEC=root+'.dat',$
			wtitle='ncrystal results', TITLE=title,GROUP=event.top,$
			xtitle='-1',ytitle='-1',no_block=state.no_block
		  "Crystal Parameters":XDisplayFile1,root+'.par',Group=event.top
		  "Crystallographic Parameters":XdisplayFile1,$
		     state.str.bragg.parameters.outfil,Group=event.top
		  else: message,/info,'case item not found'
		  ENDCASE
		  END  ;END SHOW
  ENDCASE
out:
Widget_Control, stateid, Set_Uvalue=state ; , /No_Copy
END
;
;==============================================================================
;
PRO Ncrystal, GROUP=group, InputFile=inputFile, No_Block=no_block

;Forward_Function n_xop_defaults

Catch, error_status
IF error_status NE 0 THEN BEGIN
   Message,/Info,'error caught: '+!err_string
   itmp = Dialog_Message(/Error,Dialog_Parent=group, $
     'NCRYSTAL: error caught: '+!err_string)
   Catch, /Cancel
   On_Error,2
   RETURN
ENDIF

IF N_Elements(no_block) EQ 0 THEN no_block=1
if xregistered('ncrystal') gt 1 then return
; if not(keyword_set(group)) then xop_wd,/default
;
; widget definition
;

base=WIDGET_BASE(/COLUMN,TITLE='Ncrystal '+ncrystal_version(),$
	MBAR=wMenuBar)

wButtons = widget_base(base,/Column) ; also to store state

wFile = widget_button(wMenuBar,VALUE='File',/MENU)
;  wtmp = widget_button(wFile,VALUE='Load Ncrystal input file...', $
;		UVALUE='FILELOAD')
;  wtmp = widget_button(wFile,VALUE='Write Ncrystal input file...', $
;		UVALUE='FILEWRITE')

  wtmp0 = widget_button(wFile,VALUE='Ncrystal input parameters', /Menu)
    wtmp = widget_button(wtmp0,VALUE='Load from file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save to file...',UValue='FILEINPUT')
    wtmp = widget_button(wtmp0,VALUE='Save as default',UValue='FILEINPUT')
  wtmp = widget_button(wFile,VALUE='Quit', UVALUE='QUIT',/Separator)

wSetParameters = widget_button(wMenuBar,VALUE='Set_Parameters', /MENU)
  wtmp = widget_button(wSetParameters,VALUE='Set Parameters', UVALUE='SETPAR')
  wtmp = widget_button(wSetParameters,VALUE='Set Defaults', UVALUE='SETDEF')

wResults = widget_button(wMenuBar,VALUE='Show',/MENU)
  wtmp = widget_button(wResults,VALUE='Diffraction curve', UVALUE='SHOW')
  wtmp = widget_button(wResults,VALUE='Crystal Parameters', UVALUE='SHOW')
  wtmp = widget_button(wResults,VALUE='Crystallographic Parameters', $
	UVALUE='SHOW')

wHelp = widget_button(wMenuBar,VALUE='Help', /Help)
  wtmp = widget_button(wHelp,VALUE='ncrystal', UVALUE='HELP')
;
wtmp = widget_button(BASE,VALUE='Set Parameters', UVALUE='SETPAR')


if sdep() EQ 'WINDOWS' then font = 'VERDANA*BOLD*ITALIC*24' else $
  FONT='-b&h-lucida-bold-i-normal-sans-24-240-75-75-p-151-iso8859-1'
;  font = '-adobe-helvetica-bold-o-normal--18-180-75-75-p-104-iso8859-1'


wtmp = WIDGET_LABEL( BASE,  VALUE='nCrystal' , FONT=font)
wtmp = WIDGET_LABEL( BASE,  VALUE='Neutron crystal diffraction   ',FONT=font)

;
;state
;
;str = n_xop_defaults('ncrystal')
str = nop_defaults('ncrystal')
str_defaults = str.parameters


IF KeyWord_Set(inputFile) THEN BEGIN
  str_par = Xop_Input_Load(InputFile=inputFile)
  IF Type(str_par) EQ 8 THEN BEGIN
    tmp = str.parameters
    Copy_Structure,str_par, tmp, Group=group
    str.parameters = tmp
  ENDIF
ENDIF
wids = {dummy:0L}
state = { str:str, str_defaults:str_defaults, wids:wids,no_block:no_block}
;
;actions
;
Widget_control,Widget_Info(base,/Child),Set_uvalue=state ; ,/No_Copy
Widget_control,base,/Realize
Xmanager,'ncrystal',base,Group_leader=group,no_block=no_block


end
;
