      PROGRAM   BGR1

C

C     PROGRAM FOR AUTOMATIC BACKGROUND REMOVAL

C     Ver. 4.3     08.03.86.

C     Ver. 5.0	   29.06.96

C     Ver. 5.1     14.08.96

C     For data y-values NOT normalized.

      DOUBLE PRECISION XD(320),YD(320),DYD(320),V(320,7),A(320,4),S,S1

      REAL XORG(1000),YORG(1000),X(320,3),Y(320,3),DY(320),WORK(320),

     &YR(2048),YI(2048),YM(410),XX(4),XK(4)

      CHARACTER COMMNT*128,FNAME*16

C

 1000 FORMAT ('1')

 1001 FORMAT (' ','L=',I2,2X,'J=',I1,2X,'S=',F7.6,2X,'B=',F7.5,2X,

     &'0.02*D=',F7.5)

 1002 FORMAT (' ','HR=',F7.3,2X,'HM=',F7.3,2X,'HN=',F7.3,2X,

     &'0.05*HM=',F7.3,2X,'HR-HN=',F7.3/)

 1003 FORMAT (A128,' HANN. WIN.:',F6.3,'-',F6.3,',',

     &F6.3,'-',F6.3,'/A  ','PWR = ',I1)

 1004 FORMAT (' ',A32)

 1005 FORMAT (A128,' SMOOTHED RANGE:',F6.3,'-',F6.3,' 1/A  ',

     &'S=',F7.5)

 1006 FORMAT (A128)

 1007 FORMAT ('FNAME=',A11,2X,'X1=',F4.1,2X,'X2=',F6.1,2X,'XX1=',F6.1,

     &2X,'XX2=',F6.1,2X,'FLAT=',F4.2,2X,'POWER OF K=',I3,2X,

     &'INIT. PARAMETER =',F5.4/)

C

      PI=3.14159

      SQPI=SQRT(PI)

      WRITE (*,1000)

      OPEN (11,FILE='PARFILE',STATUS='OLD')

      READ (11,*) FNAME,X1,X2,(XX(I),I=1,2),FLAT,LI,S

      CLOSE (11)

      OPEN (20,FILE='HISTORY.DAT',STATUS='UNKNOWN')

      SA=S

      WRITE(*,1007) FNAME,X1,X2,(XX(I),I=1,2),FLAT,LI,SA

      WRITE(20,1007) FNAME,X1,X2,(XX(I),I=1,2),FLAT,LI,SA

C

      OPEN (13,FILE=FNAME,STATUS='OLD')

      READ (13,*) COMMNT

      I=1

    1 CONTINUE

         READ (13,*,END=2) XORG(I),YORG(I)

         I=I+1

         GO TO 1

    2 CONTINUE

      CLOSE (13)

      N=I-1

C

      IF (X2.GT.25.0) THEN

         IEK=0

         CALL ETOK (N,XORG,YORG,Y(1,1))

      ELSE

         IEK=-1

         CALL EQUIK (N,XORG,YORG,Y(1,1))

      END IF

      

      NK=320

      DO 4 I=1,NK

         X(I,1)=(I-1)*0.0625

    4 CONTINUE

C

      IF (IEK.EQ.0) THEN

         X1S=SQRT(X1)*5.1239E-1

         X2S=SQRT(X2)*5.1239E-1

      ELSE

         X1S=X1

         X2S=X2

      END IF

      CALL SEARCH (NK,X(1,1),X1S,N1)

      CALL SEARCH (NK,X(1,1),X2S,N2)

C

      I=0

    5 CONTINUE

         I=I+1

      IF (.NOT.(I.GE.N1)) GO TO 5

         K=I-N1+1

         X(K,2)=X(I,1)

         Y(K,2)=Y(I,1)

      IF (.NOT.(I.GE.N2)) GO TO 5

      NPT=K-1

C

      CALL DERIV (NPT,X(1,2),Y(1,2),WORK)

      CALL DERIV (NPT,X(1,2),WORK,DY)

      D=0.0

      DO 6 I=1,NPT

         D=D+ABS(DY(I))

   6  CONTINUE

      DA=0.02*D

C

      XA=(X(NPT,2)-X(1,2))/(NPT-1)

      DO 7 I=1,NPT-1

         XB=XA/(X(I+1,2)-X(I,2))

         XC=X(I,2)/X(NPT,2)

         DY(I)=EXP(-0.75*XC*XC)*XB

   7  CONTINUE

      DY(NPT)=DY(NPT-1)

C

      IF (IEK.EQ.0) THEN

         DO 8 I=1,2

            XK(I)=SQRT(XX(I))*5.1239E-1

   8     CONTINUE

      ELSE 

         DO 9 I=1,2

            XK(I)=XX(I)

   9     CONTINUE

      END IF

C

      XK(4)=XK(2)

      DXK=XK(4)-XK(1)

      FFLAT=DXK*FLAT

      PANT=(DXK-FFLAT)/2.0

      XK(2)=XK(1)+PANT

      XK(3)=XK(4)-PANT

C

      DO 10 I=1,NPT

         XD(I)=X(I,2)

         YD(I)=Y(I,2)

         DYD(I)=DY(I)

   10 CONTINUE

C

      NN=2048

      NU=11

      L=0

      IB=0

      IF (S.GT.0.0) THEN

            CALL SMT(XD,YD,DYD,NPT,S,V,A)

            SA=S

C

            DO 20 I=1,NPT

               Y(I,3)=(Y(I,2)-A(I,1))/A(I,1)

   20       CONTINUE

C

            CALL HANWND (N1,LI,XK,Y(1,3),YR)

            DO 21 I=1,320

               WORK(I)=YR(I)

   21       CONTINUE

C

            DO 22 I=1,2048

               YR(I)=YR(I)*SQPI/16.0

               YI(I)=0

   22       CONTINUE

C

            CALL FFT (NN,NU,YR,YI)

C

            DO 23 I=1,408

               YM(I)=SQRT(YR(I)*YR(I)+YI(I)*YI(I))

   23       CONTINUE

C

            CALL EVALT (YM,HR,HM,HN,HH,H)

C

            WRITE (*,1002) HR,HM,HN,HH,H

            WRITE (20,1002) HR,HM,HN,HH,H

C

         ELSE

            S1=1.0D-6

            S=S1

            J=1

            IS=0

C

   30       CONTINUE

            CALL SMT (XD,YD,DYD,NPT,S,V,A)

            L=L+1

            SA=S

            B=0.0

            DO 31 I=1,NPT

               B=B+ABS(A(I,3))

   31       CONTINUE

            BA=B

            IF (B.EQ.0.0D0) IB=IB+1

            WRITE (*,1001) L,J,SA,BA,DA

            WRITE (20,1001) L,J,SA,BA,DA

            IF (BA.GT.DA) THEN

                  CALL PROGS1 (S,S1,IS,J)

               ELSE

                  DO 40 I=1,NPT

                     Y(I,3)=(Y(I,2)-A(I,1))/A(I,1)

   40             CONTINUE

C

               CALL HANWND (N1,LI,XK,Y(1,3),YR)

               DO 42 I=1,320

                  WORK(I)=YR(I)

   42          CONTINUE

C

               DO 51 I=1,2048

                  YR(I)=YR(I)*SQPI/16.0

                  YI(I)=0

   51          CONTINUE

C

               CALL FFT (NN,NU,YR,YI)

               DO 41 I=1,408

                  YM(I)=SQRT(YR(I)*YR(I)+YI(I)*YI(I))

   41          CONTINUE

C

               CALL EVALT (YM,HR,HM,HN,HH,H)

C

               WRITE (*,1002) HR,HM,HN,HH,H

               WRITE (20,1002) HR,HM,HN,HH,H

               IF (HH.LE.H) THEN

                     CALL PROGS2 (S,S1,IS,J)

                     IS=0

                     J=J+1

                     S1=S

                  ELSE

                     CALL PROGS1 (S,S1,IS,J)

               ENDIF

            ENDIF

            IF (.NOT.((J.EQ.7).OR.(IB.GT.10))) GO TO 30

      ENDIF

C

      OPEN (12,FILE='FT.DAT',STATUS='UNKNOWN')

      WRITE (12,1003) COMMNT,(XK(I),I=1,4),LI

      DO 61 I=1,325

         XA=(I-1)*PI/128.0

         WRITE (12,*) XA,YR(I),YI(I),YM(I)

   61 CONTINUE

      CLOSE(12)

C

      OPEN (14,FILE='CHI.DAT',STATUS='UNKNOWN')

      WRITE (14,1003) COMMNT,(XK(I),I=1,4),LI

      DO 62 I=1,NPT

         WRITE (14,*) X(I,2),Y(I,3)

   62 CONTINUE

      CLOSE(14)

C

      OPEN (16, FILE='CHIKN.DAT', STATUS='UNKNOWN')

      WRITE (16,1003) COMMNT,(XK(I),I=1,4),LI

      DO 63 I=1,NPT

         XA=(I-1)*0.0625

         WRITE (16,*) XA,WORK(I)

   63 CONTINUE

      CLOSE (16)

C

      OPEN (18,FILE='BGR.DAT',STATUS='UNKNOWN')

      WRITE (18,1005) COMMNT,X1S,X2S,SA

      DO 64 I=1,NPT

         XA=A(I,1)

         WRITE (18,*) X(I,2),XA

   64 CONTINUE

      CLOSE(18)

C

      WRITE (*,1004) COMMNT

      CLOSE(20)

C

      IF (IB.GT.10) GO TO 500

C

  500 STOP

      END

C********************************************************************

      SUBROUTINE SEARCH (N,X,A,NA)

      REAL X(320)

      DO 10 I=2,N

         D1=X(I)-A

         IF (D1.GT.0.0) GO TO 20

   10 CONTINUE

   20 D2=X(I-1)-A

      AB=ABS(D2)-ABS(D1)

      IF (AB.GT.0.0) THEN

            NA=I

         ELSE

            NA=I-1

      ENDIF

C

      RETURN

      END

C*********************************************************************

      SUBROUTINE DERIV (N,X,Y,Y1)

      REAL X(320),Y(320),Y1(320),Y2(320)

      DO 10 I=1,N-1

         DX=X(I+1)-X(I)

         DY=Y(I+1)-Y(I)

         Y2(I)=DY/DX

   10 CONTINUE

      Y2(N)=Y2(N-1)

      Y1(1)=Y2(1)

      DO 20 I=2,N

         Y1(I)=0.5*Y2(I-1)+0.5*Y2(I)

   20 CONTINUE

      RETURN

      END

C*********************************************************************

      SUBROUTINE ETOK (N,X,Y,Y1)

      REAL X(1000),Y(1000),Y1(320)

      DO 10 I=1,320

         Y1(I)=0.0

   10 CONTINUE

C

      I=0

   20 CONTINUE

      I=I+1

      XK=(I-1)*0.0625

      EK=3.8103*XK*XK

      IF (EK.GE.X(N)) GO TO 30

      DO 40 K=1,N

         D1=X(K)-EK

         IF (D1.GE.0.0) GOTO 50

   40 CONTINUE

   50 CONTINUE

      J=K

      DX=X(J+1)-X(J)

      Y1(I)=(EK-X(J))/DX*Y(J+1)+(X(J+1)-EK)/DX*Y(J)

      GOTO 20

   30 CONTINUE

      RETURN

      END

C*********************************************************************

      SUBROUTINE EQUIK (N,X,Y,Y1)

      REAL X(1000),Y(1000),Y1(320)

      DO 10 I=1,320

         Y1(I)=0.0

   10 CONTINUE

C

      I=0

   20 CONTINUE

      I=I+1

      XK=(I-1)*0.0625

      IF (XK.GE.X(N)) GOTO 30

      DO 40 K=1, N

         D1=X(K)-XK

         IF (D1.GE.0.0) GOTO 50

   40 CONTINUE

   50 CONTINUE

      J=K

      DX=X(J+1)-X(J)

      Y1(I)=(XK-X(J))/DX*Y(J+1)+(X(J+1)-XK)/DX*Y(J)

      GOTO 20

   30 CONTINUE

      RETURN

      END

C*********************************************************************

      SUBROUTINE HANWND (N1,LI,XK,Y,YR)

      REAL XK(4),Y(320),YR(2048)

      PI=3.14159

      DXK1=XK(2)-XK(1)

      DXK2=XK(4)-XK(3)

      DO 10 I=1,2048

         K=I-N1+1

         WN=(I-1)*0.0625

         WNLI=WN**LI

         IF (WN.LT.XK(1)) THEN

               YR(I)=0.0

            ELSEIF (WN.LE.XK(2)) THEN

                  YR(I)=Y(K)*(WNLI)*(1.0-COS((WN-XK(1))*PI/DXK1))/2.0

               ELSEIF (WN.LE.XK(3)) THEN

                     YR(I)=Y(K)*(WNLI)

                  ELSEIF (WN.LE.XK(4)) THEN

                     YR(I)=Y(K)*(WNLI)*(1.0+COS((WN-XK(3))*PI/DXK2))/2.0

                        ELSE

                           YR(I)=0.0

         ENDIF

   10 CONTINUE

      RETURN

      END

C*********************************************************************

      SUBROUTINE FFT (N,NU,YR,YI)

      REAL YR(2048),YI(2048)

      N2=N/2

      NU1=NU-1

      K=0

      DO 10 L=1,NU

   12    CONTINUE

         DO 11 I=1,N2

            IP=IBITR(K/2**NU1,NU)

	    ARG=6.28318*IP/N

            C=COS(ARG)

            S=SIN(ARG)

            K1=K+1

            K2=K1+N2

	    TREAL=YR(K2)*C-YI(K2)*S

            TIMAG=YI(K2)*C+YR(K2)*S

	    YR(K2)=YR(K1)-TREAL

            YI(K2)=YI(K1)-TIMAG

	    YR(K1)=YR(K1)+TREAL

            YI(K1)=YI(K1)+TIMAG

            K=K+1

   11    CONTINUE

         K=K+N2

         IF (.NOT.(K.GE.N)) GO TO 12

         K=0

         NU1=NU1-1

         N2=N2/2

   10 CONTINUE

      DO 13 K=1,N

         I=IBITR(K-1,NU)+1

         IF (I.LE.K) GO TO 13

	 TREAL=YR(K)

         TIMAG=YI(K)

         YR(K)=YR(I)

         YI(K)=YI(I)

	 YR(I)=TREAL

         YI(I)=TIMAG

   13 CONTINUE

C

      RETURN

      END

C*********************************************************************

      FUNCTION IBITR (J,NU)

      J1=J

      IBITR=0

      DO 20 I=1,NU

         J2=J1/2

         IBITR=IBITR*2+(J1-2*J2)

         J1=J2

   20 CONTINUE

      RETURN

      END

C*********************************************************************

      SUBROUTINE EVALT (YM,HR,HM,HN,HH,H)

      REAL YM(500)

      HR=0.0

      DO 11 I=1,21

         HR=HR+YM(I)

   11 CONTINUE

      HR=HR/21.0

      HM=YM(40)

      DO 12 I=41,204

         IF (YM(I).GE.HM) HM=YM(I)

   12 CONTINUE

      HN=0.0

      DO 13 I=368,408

         HN=HN+YM(I)

   13 CONTINUE

      HN=HN/41.0

      H=HR-HN

      HH=0.05*HM

      RETURN

      END

C*********************************************************************

      SUBROUTINE PROGS1 (S,S1,IS,J)

      DOUBLE PRECISION S,S1

      IS=IS+1

      IF (J.EQ.1) THEN

            S=S1+0.1*IS

         ELSEIF (J.EQ.2) THEN

               S=S1+0.01*IS

            ELSEIF (J.EQ.3) THEN

               S=S1+0.001*IS

               ELSEIF (J.EQ.4) THEN

                  S=S1+0.0001*IS

                  ELSEIF (J.EQ.5) THEN

                     S=S1+0.00001*IS

                     ELSEIF (J.EQ.6) THEN

                        S=S1+0.000001*IS

      ENDIF

C

      RETURN

      END

C*********************************************************************

      SUBROUTINE PROGS2 (S,S1,IS,J)

      DOUBLE PRECISION S,S1

      IS=IS-1

      IF (J.EQ.1) THEN

            S=S1+0.1*IS

         ELSEIF (J.EQ.2) THEN

               S=S1+0.01*IS

            ELSEIF (J.EQ.3) THEN

               S=S1+0.001*IS

               ELSEIF (J.EQ.4) THEN

                  S=S1+0.0001*IS

      ENDIF

C

      RETURN

      END

C*********************************************************************

      SUBROUTINE SMT (X,Y,DY,NPT,S,V,A)

      DOUBLE PRECISION A(320,4),DY(320),S,V(320,7),X(320),Y(320),

     &SMOOTH,CHG,P,PREVSF,PREVP,SFP,SIXP,SIX1MP,UTRU,ZERO

      ZERO=0.0

      CALL SETUPQ (X,DY,Y,NPT,V,A(1,4))

      IF (S.GT.ZERO)                      GO TO 20

   10 P=1.0

      CALL CHOL (P,V,A(1,4),NPT,A(1,3),A(1,1))

      SFP=ZERO

                                          GO TO 60

   20 P=ZERO

      CALL CHOL (P,V,A(1,4),NPT,A(1,3),A(1,1))

      SFP=ZERO

      DO 21 I=1,NPT

         SFP=SFP+(A(I,1)*DY(I))**2

   21 CONTINUE

      SFP=SFP*36.0

      IF (SFP.LE.S)                       GO TO 60

      PREVP=ZERO

      PREVSF=SFP

      UTRU=ZERO

      DO 25 I=2,NPT

         UTRU=UTRU+V(I-1,4)*(A(I-1,3)*(A(I-1,3)+A(I,3))+A(I,3)**2)

   25 CONTINUE

      P=(SFP-S)/(2.4D1*UTRU)

C SECANT ITERATION FOR THE DETERMINATION OF P

   30 CALL CHOL (P,V,A(1,4),NPT,A(1,3),A(1,1))

      SFP=ZERO

      DO 35 I=1,NPT

         SFP=SFP+(A(I,1)*DY(I))**2

   35 CONTINUE

      SFP=SFP*36*(1-P)**2

      IF (SFP.LE.1.01*S)                  GO TO 60

      IF (SFP.GE.PREVSF)                  GO TO 10

      CHG=(P-PREVP)/(SFP-PREVSF)*(SFP-S)

      PREVP=P

      P=P-CHG

      PREVSF=SFP

      IF (P.LT.1.)                        GO TO 30

      P=1-DSQRT(S/PREVSF)*(1-PREVP)

                                          GO TO 30

CORRECT VALUE OF P HAS BEEN FOUND.

   60 SMOOTH=SFP

      SIX1MP=6.0*(1-P)

      DO 61 I=1,NPT

         A(I,1)=Y(I)-SIX1MP*DY(I)**2*A(I,1)

   61 CONTINUE

      SIXP=6.0*P

      DO 62 I=1,NPT

         A(I,3)=A(I,3)*SIXP

   62 CONTINUE

C

      DO 63 I=1,NPT-1

         A(I,4)=(A(I+1,3)-A(I,3))/V(I,4)

         A(I,2)=(A(I+1,1)-A(I,1))/V(I,4)-(A(I,3)+A(I,4)/3*V(I,4))

     1      *0.5*V(I,4)

   63 CONTINUE

                                          RETURN

      END

C*********************************************************************

      SUBROUTINE SETUPQ (X,DX,Y,NPT,V,QTY)

      DOUBLE PRECISION X(320),Y(320),DX(320),V(320,7),QTY(320),DIFF,

     &PREV,ZERO

      ZERO=0.0

      V(1,4)=X(2)-X(1)

      DO 11 I=2,NPT-1

         V(I,4)=X(I+1)-X(I)

         V(I,1)=DX(I-1)/V(I-1,4)

         V(I,2)=-DX(I)/V(I,4)-DX(I)/V(I-1,4)

         V(I,3)=DX(I+1)/V(I,4)

   11 CONTINUE

      V(NPT,1)=ZERO

      DO 12 I=2,NPT-1

         V(I,5)=V(I,1)**2+V(I,2)**2+V(I,3)**2

   12 CONTINUE

      IF (NPT-1.LT.3)                      GO TO 14

      DO 13 I=3,NPT-1

         V(I-1,6)=V(I-1,2)*V(I,1)+V(I-1,3)*V(I,2)

   13 CONTINUE

   14 V(NPT-1,6)=ZERO

      IF (NPT-1.LT.4)                      GO TO 16

      DO 15 I=4,NPT-1

         V(I-2,7)=V(I-2,3)*V(I,1)

   15 CONTINUE

   16 V(NPT-2,7)=ZERO

      V(NPT-1,7)=ZERO

C

      PREV=(Y(2)-Y(1))/V(1,4)

      DO 21 I=2,NPT-1

         DIFF=(Y(I+1)-Y(I))/V(I,4)

         QTY(I)=DIFF-PREV

         PREV=DIFF

   21 CONTINUE

                                          RETURN

      END

C*********************************************************************

      SUBROUTINE CHOL (P,V,QTY,NPT,U,QU)

      DOUBLE PRECISION QTY(320),QU(320),U(320),V(320,7),P,SIX1MP,TWOP,

     &RATIO,PREV,ZERO

      ZERO=0.0

C

      SIX1MP=6.0*(1.0-P)

      TWOP=2.0*P

      DO 2 I=2,NPT-1

         V(I,1)=SIX1MP*V(I,5)+TWOP*(V(I-1,4)+V(I,4))

         V(I,2)=SIX1MP*V(I,6)+P*V(I,4)

         V(I,3)=SIX1MP*V(I,7)

    2 CONTINUE

C

      IF (NPT-1.GE.2)                      GO TO 10

      U(1)=ZERO

      U(2)=QTY(2)/V(2,1)

      U(3)=ZERO

                                          GO TO 41

C  FACTORIZATION

   10 DO 20 I=2,NPT-1

         RATIO=V(I,2)/V(I,1)

         V(I+1,1)=V(I+1,1)-RATIO*V(I,2)

         V(I+1,2)=V(I+1,2)-RATIO*V(I,3)

         V(I,2)=RATIO

         RATIO=V(I,3)/V(I,1)

         V(I+2,1)=V(I+2,1)-RATIO*V(I,3)

         V(I,3)=RATIO

   20 CONTINUE

C

C  FORWARD SUBSTITUTION

      U(1)=ZERO

      V(1,3)=ZERO

      U(2)=QTY(2)

      DO 30 I=2,NPT-1

         U(I+1)=QTY(I+1)-V(I,2)*U(I)-V(I-1,3)*U(I-1)

   30 CONTINUE

C  BACK SUBSTITUTION

      U(NPT)=ZERO

      U(NPT-1)=U(NPT-1)/V(NPT-1,1)

      DO 40 I=NPT-1,2,-1

         U(I)=U(I)/V(I,1)-U(I+1)*V(I,2)-U(I+2)*V(I,3)

   40 CONTINUE

C

   41 PREV=ZERO

      DO 50 I=2,NPT

         QU(I)=(U(I)-U(I-1))/V(I-1,4)

         QU(I-1)=QU(I)-PREV

         PREV=QU(I)

   50 CONTINUE

      QU(NPT)=-QU(NPT)

                                          RETURN

      END

