/* registry.h: registry data structures

   Copyright 1996, 1998 Cygnus Solutions.

This file is part of Cygwin.

This software is a copyrighted work licensed under the terms of the
Cygwin license.  Please consult the file "CYGWIN_LICENSE" for
details. */

class reg_key
{
  HKEY key;

public:

  int error() {return key == (HKEY) INVALID_HANDLE_VALUE;}

  int fillone_string (char *dst, const char *name, const char *def, int max);
  int setone_string (const char *src, const char *name);
  int setone_int (const char *key, int val);
  int getone_string (char *dst, const char *name, int len);

  void init (const char *name, HKEY r, REGSAM access);
  int open (const char *name, HKEY r, REGSAM access);

  reg_key (HKEY toplev, REGSAM access, ...);
  reg_key (REGSAM access, ...);
  reg_key (REGSAM access = KEY_ALL_ACCESS);

  void *operator new (size_t, void *p) {return p;}

  void build_reg (HKEY key, REGSAM access, va_list av);

  HKEY get_key ();

  int get_int (const char *,int def);
  int get_string (const char *, char *buf, size_t len, const char *def);
  int set_string (const char *,const char *);
  int set_int (const char *,int val);
  void kill (const char *child);

  ~reg_key ();
};
