/* Main header for the m32r.  */

#define USING_SIM_BASE_H /* FIXME: quick hack */

struct _sim_cpu; /* FIXME: should be in sim-basics.h */
typedef struct _sim_cpu SIM_CPU;

/* sim-basics.h includes config.h but cgen-types.h must be included before
   sim-basics.h and cgen-types.h needs config.h.  */
#include "config.h"

#include "ansidecl.h"
#include "symcat.h"
#include "cgen-types.h"
#include "arch.h"
#include "sim-basics.h"

/* These must be defined before sim-base.h.  */
typedef USI sim_cia;
#define CIA_GET(cpu)     0 /* FIXME:(CPU_CGEN_HW (cpu)->h_pc) */
#define CIA_SET(cpu,val) 0 /* FIXME:(CPU_CGEN_HW (cpu)->h_pc = (val)) */

/* FIXME: Shouldn't be required to define these this early.  */
#define SIM_ENGINE_HALT_HOOK(SD, LAST_CPU, CIA)
#define SIM_ENGINE_RESTART_HOOK(SD, LAST_CPU, CIA)

/* Catch address exceptions.  */
#define SIM_CORE_SIGNAL(SD,CPU,CIA,MAP,NR_BYTES,ADDR,TRANSFER,ERROR) \
m32r_core_signal ((SD), (CPU), (CIA), (MAP), (NR_BYTES), (ADDR), \
		  (TRANSFER), (ERROR))

#include "sim-base.h"
#include "cgen-sim.h"
/*#include "cgen-mem.h"*/
#include "cgen-trace.h"
#include "cpu-sim.h"

/* Function to catch address exceptions.  */
extern SIM_CORE_SIGNAL_FN m32r_core_signal;

#ifdef WANT_CPU_M32RB
#include "cpu.h"
#include "decode.h"
#endif
#include "cpuall.h"

/* The _sim_cpu struct.  */

struct _sim_cpu {
  sim_cpu_base base;

  /* Static parts of cgen.  */
  CGEN_CPU cgen_cpu;

  M32R_MISC_PROFILE m32r_misc_profile;
  /* FIXME: This should yield a pointer.  */
#define CPU_M32R_MISC_PROFILE(cpu) ((cpu)->m32r_misc_profile)

  /* CPU specific parts go here.
     Note that in files that don't need to access these pieces WANT_CPU_FOO
     won't be defined and thus these parts won't appear.  This is ok.
     One has to of course be careful to not take the size of this
     struct and no structure members accessed in non-cpu specific files can
     go after here.  */
#if defined (WANT_CPU_M32RB)
  M32RB_CPU_DATA cpu_data;
#endif
};

/* The sim_state struct.  */

struct sim_state {
  sim_cpu *cpu;
#define STATE_CPU(sd, n) (/*&*/ (sd)->cpu)

  CGEN_STATE cgen_state;

  sim_state_base base;
};

/* Misc.  */

/* Default memory size.  */
#define M32R_DEFAULT_MEM_SIZE 0x800000 /* 8M */
