//
// menu.h: reader/manipulator for MENU files.
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1994-1996 Mumit Khan
//

#ifndef lib_menu_menu_h
#define lib_menu_menu_h

// =================================================================== //

#include <string>
#include <list>
#include <map>

#include "xrtypes.h"
#include "menu-page.h"

// =================================================================== //
//
// Menu encapsulates all the MenuPage (and MenuItem's contained therein)
// in the system. As implemented, Menu is a container for MenuPage's,
// and also supplies load semantics via MenuReader interface.
//
// =================================================================== //

class SynonymTable;
class ToolMgr;

class Menu {
public:
    Menu(const std::string& name, ToolMgr& toolmgr, bool debug = false);
    virtual ~Menu();

    int load(const std::string& file);
    const char* name() const;
    bool loaded() const;

    const MenuPage* find_page(const std::string& name) const;
    MenuPage* find_page(const std::string& name);
    int add_page(MenuPage*);
    const std::list<std::string>& get_pages() const;

    SynonymTable* get_synonym_table() const;

    void dump() const;
private:
    std::string name_;
    ToolMgr& toolmgr_;
    bool debug_;
    std::string file_;
    std::list<std::string> page_list_;
    std::map<std::string, void*, std::less<std::string> > page_tab_;
    SynonymTable* syn_table_;
    bool loaded_;
};

// =================================================================== //

#endif/*lib_menu_menu_h*/
