/* 
 * tkAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure for
 *	use in wish and similar Tk-based applications.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */


#include <cstring>
#include <tk.h>
#include <tix.h>
#include <blt.h>
#include "xmenu.h"
#include "shdata_cmds.h"

#if !CXX_NO_NAMESPACE
using namespace std;
#endif

// Blt headers do not declare Blt_Init. Argh.
extern "C" int Blt_Init (Tcl_Interp *);

#ifndef SHADOW_VERSION
# error MUST DEFINE SHADOW_VERSOIN
#endif
#ifndef SHADOW_GUI_VERSION
# error MUST DEFINE SHADOW_GUI_VERSOIN
#endif

/*
 * The following string is the startup script executed in new
 * interpreters.  It looks on disk in several different directories
 * for a script "shadow.tcl" that is compatible with this version
 * of Tk.  The shadow.tcl script does all of the real work of
 * initialization.
 */

static char *initScript =
"proc shadow:init {} {\n\
    global shadow_library env\n\
    rename shadow:init {}\n\
    set dirs {}\n\
    if [info exists env(SHADOW_TCL_LIBRARY)] {\n\
	lappend dirs $env(SHADOW_TCL_LIBRARY)\n\
    }\n\
    if [info exists env(SHADOW_GUI_ROOT)] {\n\
	lappend dirs $env(SHADOW_GUI_ROOT)/lib/shadow\n\
    }\n\
    if [info exists env(SHADOW_ROOT)] {\n\
	lappend dirs $env(SHADOW_ROOT)/lib/shadow\n\
    }\n\
    lappend dirs [file dirname [file dirname [info nameofexecutable]]]/lib/shadow\n\
    lappend dirs [file dirname [file dirname [info nameofexecutable]]]/tcl\n\
    lappend dirs $shadow_library\n\
    foreach i $dirs {\n\
	set shadow_library $i\n\
	if [file exists [list $i/shadow.tcl]] {\n\
	    return\n\
	}\n\
    }\n\
    set msg \"Can't find a usable shadow.tcl in the following directories: \n\"\n\
    append msg \"    $dirs\n\"\n\
    append msg \"This probably means that SHADOW GUI wasn't installed properly.\n\"\n\
    error $msg\n\
}\n\
shadow:init";

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(Tcl_Interp *interp)
{

#if ((TK_MAJOR_VERSION < 4) || \
    ((TK_MAJOR_VERSION == 4) && (TK_MINOR_VERSION == 0)))
    /* Needed this before tcl7.4/tk4.0 days. I'll keep it around just in 
       case.  */
    Tk_Window main;
    main = Tk_MainWindow(interp);
#endif

    if (Tcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Tk_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */
#if defined(HAVE_PHOTO)
    if (Photo_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif
#if defined(HAVE_ITCL)
    if (Itcl_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif
#if defined(HAVE_BLT)
    if (Blt_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif
#if defined(HAVE_TIX)
    if (Tix_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
#endif
    if (Xmenu_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (Shdata_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    if (!Tcl_GetVar(interp, "shadow_library", TCL_GLOBAL_ONLY)) {
	char libdir[256];
	strcpy(libdir, DEFAULT_SHADOW_TCL_LIBRARY);
	if (!Tcl_SetVar(interp, "shadow_library", libdir, TCL_GLOBAL_ONLY)) {
	    return TCL_ERROR;
	}
    }
    Tcl_SetVar(interp, "shadow_version", SHADOW_VERSION, TCL_GLOBAL_ONLY);
    Tcl_SetVar(interp, "shadow_gui_version", SHADOW_GUI_VERSION, TCL_GLOBAL_ONLY);

    if (Tcl_Eval(interp, initScript) != TCL_OK) {
	return TCL_ERROR;
    }

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     *
     * which is exactly what I want -- MK
     *
     */

    return TCL_OK;
}

int main(int argc, char** argv) {
    Tk_Main(argc, argv, reinterpret_cast<Tcl_AppInitProc *>(Tcl_AppInit));
    return 0;
}
