#include <iostream>
#include <cstdlib>
#include <string>

#include "global.h"

#include "shadow-nml.h"
#include "value.h"
#include "variable.h"

#if !CXX_NO_NAMESPACE
using namespace std;
#endif

bool GLB_debug = false;	

void find_and_spit(const ShadowNamelist* nml, const string& name) {
    const Var* var = nml->get(name);
    if (var) {
        cerr << "==> " 
	    << var->getname() << " = " << var->getval()->getstrval()
	    << endl;
    } else {
        cerr << "==> (NOT FOUND)" << endl;
    }
}

int main(int, char*[]) {
    
    ShadowNamelist* nml1 = new ShadowNamelist;
    Var* var1 = new Var("var1", "integer", new IntegerValue(13));
    nml1->add(var1);

    ShadowNamelist* nml2 = new ShadowNamelist(nml1);
    Var* var2 = new Var("var2", "real", new RealValue(3.1415926));
    nml2->add(var2);

    nml1->dump();
    nml2->dump();

    find_and_spit(nml1, "var1");
    find_and_spit(nml1, "var2");
    find_and_spit(nml2, "var1");
    find_and_spit(nml2, "var2");
    find_and_spit(nml2, "var3");

    var2 = new Var("var2", "real", new RealValue(4 * 3.14159));
    nml2->replace(var2);
    find_and_spit(nml2, "var2");

    var1 = new Var("var1", "integer", new IntegerValue(4 * 13));
    nml2->replace(var1);
    find_and_spit(nml2, "var1");

    var1 = new Var("var1", "integer", new IntegerValue(5 * 13));
    nml1->replace(var1);
    find_and_spit(nml1, "var1");

    nml1->dump();
    nml2->dump();

    find_and_spit(nml1, "var1");
    find_and_spit(nml1, "var2");
    find_and_spit(nml2, "var1");
    find_and_spit(nml2, "var2");
    find_and_spit(nml2, "var3");

    return 0;
}

