//
// pmu.h: General purpose pattern matching unit
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef excon_batch_pmu_h
#define excon_batch_pmu_h

/****************************************************************************
 *
 *  INCLUDES
 *
 ****************************************************************************/

#include "xrtypes.h"

/****************************************************************************
 *
 *  PATTERN MATCH UNIT
 *
 ****************************************************************************/
class Pmu {
private:
    int   EOLN_SYM,SEP_SYM,OTHER_SYM;
    char   ctype[256];  // ASCII CHARACTER SET TYPE TABLE
    char  *scanline;
    int    scanpos;
    int    nfields;
    int    fieldstart[64];
    int    fieldend  [64];
    int    fieldnum  [64];
    int    nmatches;
    int    debug;
protected:
    void scaninit    (const char* line);
    void skipblanks  ();
    int  cistrcmp    (const char* key1,const char* key2);
    int  strcmp      (const char* key1,const char* key2);
    int  scannothing ();
    int  scancmp     (const char* pattern);
    int  scanliteral (const char* pattern);
    int  scanname    ();
    int  scanvariable();
    int  scanident   ();
    int  scanboolean ();
    int  scaninteger ();
    int  scanlong    ();
    int  scanreal    ();
    int  scanyesno   ();
    int  scanyn      ();
    int  scanonoff   ();
    int  scantext    ();
    int  scantype    ();
    int  scanrelop   ();
    int  scanfield   (const char* pattern);
    int  scanfield2  (const char* pattern);
    int  getfieldlen (int ith) { return (fieldend[ith-1]-fieldstart[ith-1]+1); }
public:
	   Pmu          ();
	   ~Pmu          ();
    int    isacomment   (const char* line);
    void   setdebug     (int i)  { this->debug = i; } 
    int    match        (
		const char* line, const char* f1, const char* f2=nil, 
		const char* f3=nil, const char* f4=nil,
		const char* f5=nil, const char* f6=nil, 
		const char* f7=nil, const char* f8=nil, 
		const char* f9=nil, const char* f10=nil, 
		const char* f11=nil, const char* f12=nil
    );
    int    nmatched     ()  { return nmatches; }
    void   gettextfield (int ith,char* buf);
    int    getintfield  (int ith);
    long   getlongfield (int ith);
    int    getcodefield (int ith);
    double getrealfield (int ith);
    void   dump         ();
};


#endif/*excon_batch_pmu_h*/
