/*
 * addshgrp.c: Add program manager group for SHADOW tools.
 *
 * Ideas and code lifted from GNU NT-Emacs distribution.
 *
 * ------------------------------------------------
 * Mumit Khan <khan@xraylith.wisc.edu>
 * Center for X-ray Lithography
 * University of Wisconsin-Madison
 * 3731 Schneider Dr., Stoughton, WI, 53589
 * ------------------------------------------------
 *
 * Copyright (c) 1997 Mumit Khan
 */

#include <windows.h>
#include <ddeml.h>
#include <stdlib.h>
#include <stdio.h>

#ifndef SHADOW_VERSION
# error Must define SHADOW_VERSION via Makefile.
#endif

HDDEDATA CALLBACK 
DdeCallback (UINT uType, UINT uFmt, HCONV hconv,
	     HSZ hsz1, HSZ hsz2, HDDEDATA hdata,
	     DWORD dwData1, DWORD dwData2)
{
    return ((HDDEDATA) NULL);
}

#define DdeCommand(str) 	\
	DdeClientTransaction (str, strlen (str)+1, HConversation, (HSZ)NULL, \
		              CF_TEXT, XTYP_EXECUTE, 30000, NULL)


/*
 * get_shroot_from_registry
 * 
 * returns:
 *    0 : all ok
 *    1 : major key not found
 *    2 : string value not found
 *    3 : other error
 */
int get_shroot_from_registry (char* value, size_t max_len) {

    DWORD size;
    HKEY key;

    const char *major_key = "Software\\CXrL\\SHADOW\\" SHADOW_VERSION;
    const char *var = "SHADOW_ROOT";

    if (RegOpenKeyEx (HKEY_LOCAL_MACHINE,
     		      major_key,
		      0,
		      KEY_READ, &key) != ERROR_SUCCESS)
    {
	key = INVALID_HANDLE_VALUE;
        return 1;
    }
    if (key == INVALID_HANDLE_VALUE)
        return 1;

    if (RegQueryValueEx(key, var, NULL, NULL, NULL, &size) == ERROR_SUCCESS) {
        if (size >= max_len)
	    return 3;
        RegQueryValueEx(key, var, NULL, NULL, value, &size);
    } else {
        return 2;
    }
    return 0;
}

int main (int argc, char *argv[]) {

    DWORD idDde = 0;
    HCONV HConversation;
    HSZ ProgMan;
    char additem[MAX_PATH*2 + 100];
    char shadow_path[MAX_PATH];

    /* If no args specified, use our location to set shadow_path.  */

    if (argc > 1) {
        strcpy (shadow_path, argv[1]);
    } else {
	if (get_shroot_from_registry (shadow_path, MAX_PATH)) {
	    MessageBox (NULL, 
	        "Error:Can't determine SHADOW root directory from Registry!",
	        "Install SHADOW icons", MB_OK | MB_ICONSTOP);
	    exit (1);
        }
    }

    /* Tell user what we are going to do.  */
    {
	char msg[ MAX_PATH ];
	sprintf (msg, "Add a program group SHADOW v" SHADOW_VERSION
		 " in the Taskbar?\n Using Installation Path: \"%s\"\n"
		 "This is currently only needed on Windows NT.",
	         shadow_path);
	if (MessageBox (NULL, msg, "Install SHADOW icons", 
	    MB_OKCANCEL | MB_ICONQUESTION) == IDCANCEL)
	{
	    exit (1);
	}
    }

    DdeInitialize (&idDde, (PFNCALLBACK)DdeCallback, APPCMD_CLIENTONLY, 0);

    ProgMan = DdeCreateStringHandle (idDde, "PROGMAN", CP_WINANSI);

    HConversation = DdeConnect (idDde, ProgMan, ProgMan, NULL);
    if (HConversation != 0) {
	DdeCommand ("[CreateGroup (\"SHADOW v" SHADOW_VERSION "\")]");
	DdeCommand ("[ReplaceItem (\"Shadow GUI\")]");
	sprintf (additem, 
	         "[AddItem (\"%s\\bin\\shadow.exe\", \"Shadow GUI\")]",
	         shadow_path);
        DdeCommand (additem);
	DdeCommand ("[ReplaceItem (\"Shadow Plot\")]");
	sprintf (additem, 
	         "[AddItem (\"%s\\bin\\shplot.exe\", \"Shadow Plot\")]",
	         shadow_path);
        DdeCommand (additem);
	DdeCommand ("[ReplaceItem (\"What's New\")]");
	sprintf (additem, 
	         "[AddItem (\"%s\\NEWS.txt\", \"What's New\")]",
	         shadow_path);
        DdeCommand (additem);

        DdeDisconnect (HConversation);
    }

    DdeFreeStringHandle (idDde, ProgMan);

    DdeUninitialize (idDde);

    return (0);
}
