#ifndef SHADOW_VERSION
# error Must define SHADOW_VERSION via Makefile.
#endif
#ifndef SHADOW_GUI_VERSION
# error MUST DEFINE SHADOW_GUI_VERSOIN
#endif

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef WIN32_LEAN_AND_MEAN
#include <string.h>

/*
 * get_shadow_var: Get SHADOW_ROOT etc from win32 registry.
 * 
 * returns:
 *    0 : all ok
 *    1 : major key not found
 *    2 : string value not found
 *    3 : other error
 */
int 
get_shadow_var (const char* var, char* value, size_t max_len) 
{
  DWORD size;
  HKEY key;

  const char *major_key = "Software\\CXrL\\SHADOW\\" SHADOW_VERSION;
  if (RegOpenKeyEx (HKEY_LOCAL_MACHINE,
		    major_key,
		    0,
		    KEY_READ, &key) != ERROR_SUCCESS)
    {
      return 1;
    }

  if (RegQueryValueEx(key, var, NULL, NULL, NULL, &size) == ERROR_SUCCESS) 
    {
      if (size >= max_len)
	return 3;
      RegQueryValueEx(key, var, NULL, NULL, value, &size);
    } 
  else 
    {
      return 2;
    }

  if (strchr(value, '\\')) 
    {
      char *p;
      for (p = value; p && *p; ++p)
	if (*p == '\\')
	  *p = '/';
    }

  return 0;
}

