C +++
C
C Source: src/tools/math/readcdf.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	readcdf.f
C Revision 1.2  90/11/13  14:03:13  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:55:07  khan
C Initial revision
C 
C 
C ---

     	call	rcdf	(,,,,-1)
     	call	rcdf	(,,,,0)
     	end
C+++
C	SUBROUTINE	RCDF
C
C	PURPOSE		To read the unformatted CDF for SR radiation
C
C---
     	SUBROUTINE	RCDF	( ARG, VALUE, ENERGY, ISEED, IER)

     	REAL*4		CDFG0  (2,1010)
     	REAL*4		CDF	(4,21,250),XPHOT(1000),XANG(1000)
     	IF (IER.EQ.-1) THEN
C
C Reads in the total flux distribution
C
     	OPEN	(20, FILE='srdistr.cdf', STATUS='OLD', READONLY,
     $		 FORM='UNFORMATTED')
     	READ	(20)	ICOL,NP
     	DO  10 I=1,NP
     	  READ	(20)	CDFG0(1,I),CDFG0(2,I)
10      CONTINUE 
     	CLOSE	(20)
C
C Reads in now the angle data
C
     	OPEN	(20, FILE='SRSPEC', STATUS='OLD', READONLY,
     $		 FORM='UNFORMATTED')
     	READ	(20)	NPHOT,ICOL,IST
     	DO 20 I=1,NPHOT
     	  READ (20)	XPHOT(I),XANG(I)
     	 DO 15 J=1,21
     	   READ (20)	CDF(1,J,I), CDF(2,J,I), CDF(3,J,I), CDF(4,J,I)
15       CONTINUE 
20      CONTINUE 
C
C Define the limits of interest of the SR
C

     	IF (FCOLOR.EQ.1) THEN
C       single line

     	  RLOW	=   PHOTON(1)/

     	ELSE IF (FCOLOR.EQ.2) THEN	
C  Multi-lines

     	  
     	RETURN
C
C Finds the distribution
C
     	ELSE IF (IER.EQ.0) THEN
C
C First the photon energy
C
     	
     	OPEN (34, STATUS='UNKNOWN')
C     	OPEN (34, STATUS='NEW')
     	DO 40 I=1,NP
     	  WRITE (34,*) CDFG0(1,I),CDFG0(2,I)
40      CONTINUE 
     	CLOSE (34)
1     	WRITE(6,*)'Value of I ?'
     	READ(5,*)I
     	open (33, status='new')
     	do 50 j=1,21
     	 write (33,*) CDF(1,J,I), CDF(2,J,I), CDF(3,J,I), CDF(4,J,I)
50      continue 
     	close (33)
     	go to 1
     	end if
     	end
