C +++
C
C Source: src/utils/post/angle.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		ANGLE
C
C	PURPOSE		To make the incidence and reflection angle
C			information that SHADOW saves usable.
C			Extracts GOOD/LOST/ALL rays.
C			Extracts columns to a file.
C			Merges one column of binary ray file with
C			one column of ANGLE.xx file.
C
C---
	PROGRAM 	ANGLE
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
     	REAL*8			RAY1(18,N_DIM),REFL(4,N_DIM)
     	CHARACTER * 80 		ANGFILE,OUTFIL,RAYFIL
     	CHARACTER*80	RSTRING
     	EXTERNAL	RSTRING
C
     	ANGFILE = RSTRING ('File with Angle information ? ')
     	OUTFIL  = RSTRING ('Output file name ? ')

	WRITE(6,*)'Options --- Enter'
     	WRITE(6,*)'0 for excluding the losses'
     	WRITE(6,*)'1 for including ONLY losses '
     	WRITE(6,*)'2 for including ALL the rays.'
	ILOSS = irint ('? ')

	WRITE(6,*) 'Output format: '
	WRITE(6,*) '0 ... Write four column file like input'
	WRITE(6,*) '1 ... Extract any two columns from ANGLE'
	WRITE(6,*) '2 ... Merge one column of a SHADOW RAY file'
	WRITE(6,*) '      (i.e. MIRR.xx) with one column from '
	WRITE(6,*) '      ANGLE.xx file'
	IOUT = IRINT ('Format? ')

	OPEN(20,FILE=ANGFILE, STATUS='OLD')
	I = 1
10	READ(20,*,END=25) REFL(1,I),REFL(2,I),REFL(3,I),REFL(4,I)
	I = I + 1
	GO TO 10
25	NANGLE = I - 1

#ifdef vms
	OPEN(30,FILE=OUTFIL,STATUS='NEW')
#else
	OPEN(30,FILE=OUTFIL,STATUS='UNKNOWN')
	REWIND(30)
#endif

	IF (IOUT.EQ.0) THEN
	  IF (ILOSS.EQ.0) THEN
	     DO 35 I = 1,NANGLE
35	       IF (REFL(4,I).GE.0) WRITE(30,*) (REFL(N,I),N=1,4)
	  ELSE IF (ILOSS.EQ.1) THEN
	     DO 45 I = 1,NANGLE
45	       IF (REFL(4,I).LT.0) WRITE(30,*) (REFL(N,I),N=1,4)
	  ELSE IF (ILOSS.EQ.2) THEN
	     DO 55 I = 1,NANGLE
55	       WRITE(30,*) (REFL(N,I),N=1,4)
	  END IF
	ELSE IF (IOUT.EQ.1) THEN
	  J = IRINT ('Column 1> ')
	  K = IRINT ('Column 2> ')
	  IF (ILOSS.EQ.0) THEN
	     DO 65 I = 1,NANGLE
65	       IF (REFL(4,I).GE.0) WRITE(30,*) REFL(J,I),REFL(K,I)
	  ELSE IF (ILOSS.EQ.1) THEN
	     DO 75 I = 1,NANGLE
75	       IF (REFL(4,I).LT.0) WRITE(30,*) REFL(J,I),REFL(K,I)
	  ELSE IF (ILOSS.EQ.2) THEN
	     DO 85 I = 1,NANGLE
85	       WRITE(30,*) REFL(J,I),REFL(K,I)
	  END IF
	ELSE IF (IOUT.EQ.2) THEN
	  RAYFIL = RSTRING ('SHADOW ray file to use: ')
	  J = IRINT ('Column from SHADOW file: ')
	  K = IRINT ('Column from ANGLE.xx file: ')

     	  CALL	RBEAM18 (RAYFIL,RAY1,NCOL,NPOINT,IFLAG,IERR)
     	  IF (IERR.NE.0) STOP 'Error in file // 1 '
	  IF (J.GT.NCOL) THEN
	    WRITE(6,*) 'SHADOW file only has ',NCOL,' columns.'
	    STOP
	  END IF
	  IF (NPOINT.NE.NANGLE) THEN
	    WRITE(6,*) 'Different number of points in files.'
	    STOP
	  END IF
	  IF (ILOSS.EQ.0) THEN
	     DO 95 I = 1,NANGLE
95	       IF (REFL(4,I).GE.0) WRITE(30,*) RAY1(J,I),REFL(K,I)
	  ELSE IF (ILOSS.EQ.1) THEN
	     DO 105 I = 1,NANGLE
105	       IF (REFL(4,I).LT.0) WRITE(30,*) RAY1(J,I),REFL(K,I)
	  ELSE IF (ILOSS.EQ.2) THEN
	     DO 115 I = 1,NANGLE
115	       WRITE(30,*) RAY1(J,I),REFL(K,I)
	  END IF
	END IF
	CLOSE(30)
	CLOSE(20)

C
     	END


