C +++
C
C Source: src/trace/reset.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	reset.F
C Revision 1.8  94/12/16  11:44:42  cwelnak
C added new variables for crystal, facet, kumakhov models.
C 
C Revision 1.7  91/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C 
C Revision 1.6  91/04/05  15:06:01  cwelnak
C changed quotes on #includes
C 
C Revision 1.5  91/03/22  10:46:37  cwelnak
C SUN version -- INCLUDE to #inlcude
C 
C Revision 1.4  90/11/13  14:01:56  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/19  21:37:58  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.2  90/07/14  22:51:16  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.1  90/07/10  14:56:47  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	RESET
C
C	PURPOSE		To correctly initialize the variables and flags,
C			avoiding cross-talk between different OE
C
C---
     	SUBROUTINE	RESET
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
     	WRITE(6,*)'Call to RESET'
C
C  FLAGS block
C
     	FMIRR		= 	0
	F_TORUS		= 	0
     	FCYL		= 	0
     	FANG		=	0
     	FSTAT		=	0
     	FANG1		=	0
     	FSLIT		=	0
     	FGRID		=	0
     	F_NEW		=	0
     	FSOURCE_DEPTH	=	0
     	FSOUR		=	0
     	FDISTR		=	0
	F_OPD		= 	0
     	F_POL		=	0
     	F_RIPPLE	=	0
     	F_MOVE		=	0
     	F_DEFAULT	=	0
     	F_CENTRAL	=	0
     	FHIT_C		=	1
     	F_COLOR		=	0
     	F_CONVEX	=	0
     	F_EXT		=	0
     	F_GRATING	=	0
     	F_CRYSTAL	=	0
     	F_PHOT_CENT	=	0
     	F_MONO		=	0
     	F_HUNT		=       1
     	F_PLATE		=	0
     	F_COHER		=	0
     	F_PW		=	2
     	F_VIRTUAL	=       0
     	F_REFLEC	=	0
     	F_RULING	=	0
     	F_SCREEN	=	0
     	F_SIDE		=	0
     	F_REFL		=       0
     	F_G_S		=	0
     	F_READ_RIP	=	0
     	F_R_RAN		=	0
     	FSTAT		=	1
     	F_PHOT		=	0
     	F_REFRAC	=	0
     	FSHAPE		=	0
     	F_PW_C		=	0
     	FWRITE		=	0
     	FZP		=	0
        F_BRAGG_A       =       0
        F_JOHANSSON     =       0
        F_MOSAIC        =       0
        F_ROUGHNESS     =       0
        FDUMMY          =       0
        F_ANGLE         =       0
C
C  CALC block
C
     	N_PLATES   	=	0
     	N_SCREEN	=	0
C	NPOINT	carried on;
     	DO 11 I=1,10
     	I_SCREEN(I)	=	0
     	I_SLIT(I)	=	0
     	K_SLIT(I)	=	0
     	I_STOP(I)	=	0
     	I_ABS(I)	=	0
#ifdef HP_F77_BUGGY_NAMELIST
     	FILABS(I)	=	'NONE SPECIFIED'
     	FILSCR(I)	=	'NONE SPECIFIED'
#else
     	FILE_ABS(I)	=	'NONE SPECIFIED'
     	FILE_SCR_EXT(I)	=	'NONE SPECIFIED'
#endif
11     	CONTINUE
C
C  SYSTEM block
C
     	ALPHA		=	0.0D0
     	SSOUR		=	0.0D0
     	SIMAG		=	0.0D0
     	THETA		=	0.0D0
     	RDSOUR		=	0.0D0
     	RTHETA		=	0.0D0
     	TIMDIS		=	0.0D0
     	DELTA		=	0.0D0
     	RDELTA		=	0.0D0
     	ALPHA_S		=	0.0D0
     	OFF_SOUX	=	0.0D0
     	OFF_SOUY	=	0.0D0
     	OFF_SOUZ	=	0.0D0
     	DO 100 I=1,3
     	PSOUR(I)	=	0.0D0
     	PSREAL(I)	=	0.0D0
100     continue
C
C  MIRROR block
C
     	RLEN		=	0.0D0
     	RLEN1		=	0.0D0
     	RLEN2		=	0.0D0
     	RMIRR		=	0.0D0
     	AXMAJ		=	0.0D0
     	AXMIN		=	0.0D0
     	AFOCI		=	0.0D0
     	ECCENT		=	0.0D0
     	R_MAJ		=	0.0D0
     	R_MIN		=	0.0D0
     	RWIDX		=	0.0D0
     	RWIDX1		=	0.0D0
     	RWIDX2		=	0.0D0
     	CONE_A		=	0.0D0
     	PARAM		=	0.0D0

     	DO 200 I=1,10
200	CCC(I)		=	0.0D0
C
C GRATING block
C
     	RULING		=	0.0D0
     	ORDER		=	0.0D0
     	BETA		=	0.0D0
     	PHOT_CENT 	=	0.0D0
     	R_LAMBDA  	=	0.0D0
     	HUNT_H		=	0.0D0
     	HUNT_L		=	0.0D0
     	BLAZE		=	0.0D0
     	D_SPACING	=	0.0D0
     	AZIM_FAN	=	0.0D0
     	DIST_FAN	=	0.0D0
     	COMA_FAC	=	0.0D0
	RUL_A1		= 	0.0D0
	RUL_A2		= 	0.0D0
	RUL_A3		= 	0.0D0
	RUL_A4		= 	0.0D0
        A_BRAGG         =       0.0D0
C
C CRYSTAL Block
C
        SPREAD_MOS      =       0.0D0
        R_JOHANSSON     =       0.0D0
        THICKNESS       =       0.0D0
C
C  MIRROR block
C
     	X_ROT		=	0.0D0
     	Y_ROT		=	0.0D0
     	Z_ROT		=	0.0D0
     	OFFX		=	0.0D0
     	OFFY		=	0.0D0
     	OFFZ		=	0.0D0
     	DO 300 I=1,3
     	U_MIR(I)   	=	0.0D0
     	V_MIR(I)   	=	0.0D0
300     W_MIR(I)   	=	0.0D0
     	U_MIR(1)   	=    1.0D0
     	V_MIR(2)   	=    1.0D0
     	W_MIR(3)   	=    1.0D0
C
C  SLIT block
C
     	SLLEN		=	0.0D0
     	SLWID		=	0.0D0
     	SLTILT		=	0.0D0
     	COD_LEN		=	0.0D0
     	COD_WID		=	0.0D0
C
C  SOURCE block
C
C  --------- NO NEED ----------- not used again
C
C  ALADDIN block
C
C  --------- NO NEED ----------- not used again
C
C  TRIG block
C
C  --------- NO NEED ----------- recomputed all
C
C  IMAGE block
C
     	THETA_I		=	0.0D0
     	ALPHA_I		=	0.0D0
     	DO 400 I=1,3
     	RIMCEN(I)	=	0.0D0
     	VNIMAG(I)	=	0.0D0
     	UXIM(I)		=	0.0D0
     	VZIM(I)		=	0.0D0
     	C_STAR(I)	=	0.0D0
     	C_PLATE(I)	=	0.0D0
     	UX_PL(I)	=	0.0D0
     	VZ_PL(I)	=	0.0D0
400     WY_PL(I)	=	0.0D0

     	DO 500 I=1,5
500     D_PLATE(I)	=	0.0D0
C
C  AXIS block
C
C	CENTRAL carried through;
     	T_INCIDENCE	=	0.0D0
     	T_REFLECTION	=	0.0D0
     	T_SOURCE	=	0.0D0
     	T_IMAGE		=	0.0D0
C
C  RIPPLE block
C
     	X_RIP_AMP	=	0.0D0
     	Y_RIP_AMP	=	0.0D0
     	X_RIP_WAV	=	0.0D0
     	Y_RIP_WAV	=	0.0D0
     	X_PHASE		=	0.0D0
     	Y_PHASE		=	0.0D0
        ROUGH_X         =       0.0D0
        ROUGH_Y         =       0.0D0
C
C SEGMENT Block
C
        F_SEGMENT       =       0
        ISEG_XNUM       =       1
        ISEG_YNUM       =       1
        SEG_LENX        =       0.0D0
        SEG_LENY        =       0.0D0
C
C FACET Block
C
        F_FACET         =       0
        F_POLSEL        =       0
        IFAC_X          =       0
        IFAC_Y          =       0
        F_FAC_ORIENT    =       0
        F_FAC_LATT      =       0
        RFAC_LENX       =       0.0D0
        RFAC_LENY       =       0.0D0
        RFAC_PHAX       =       0.0D0
        RFAC_PHAY       =       0.0D0
        RFAC_DELX1      =       0.0D0
        RFAC_DELX2      =       0.0D0
        RFAC_DELY1      =       0.0D0
        RFAC_DELY2      =       0.0D0
C
C Kumakhov (KOMA) Block
C
        F_KOMA          =       0
        F_KOMA_BOUNCE   =       0
        F_EXIT_SHAPE    =       0
        F_INC_MNOR_ANG  =       0
        F_KOMA_CA       =       0
        F_DOT           =       0
        I_KOMA          =       0
        KOXX            =       0
        RKOMA_CX        =       0.0D0
        RKOMA_CY        =       0.0D0
        ZKO_LENGTH      =       0.0D0
C
C  LIGHT block
C
     	R_IND_OBJ	=       1.0D0
     	R_IND_IMA	=       1.0D0
     	ALFA		=	0.0D0
     	GAMMA		=	0.0D0
     	POL_ANGLE	=	0.0D0
     	POL_DEG		=	0.0D0
C	PHxx	not used again

C
C  SCREENS block
C
     	DO 41 I = 1,3
     	DO 51 J = 1,2
     	UX_SCR(I,J)	=	0.0D0
     	WY_SCR(I,J)	=	0.0D0
     	VZ_SCR(I,J)	=	0.0D0
51     	CONTINUE
41     	CONTINUE
     	DO 61 I=1,10
     	RX_SLIT(I)	=	0.0D0
     	RZ_SLIT(I)	=	0.0D0
     	SL_DIS(I)	=	0.0D0
     	THICK(I)	=	0.0D0
61     	CONTINUE
C
C  HOLO block
C
     	HOLO_R1		=	0.0D0
     	HOLO_R2		=	0.0D0
     	HOLO_DEL	=	0.0D0
     	HOLO_GAM	=	0.0D0
     	HOLO_W		=	0.0D0
     	HOLO_RT1	=	0.0D0
     	HOLO_RT2	=	0.0D0
     	DO 71 I=1,3
     	HOLO1(I)	=	0.0D0
     	HOLO2(I)	=	0.0D0
71     	CONTINUE
C
C Names Block
C
     	FILE_MIR	=	'NONE SPECIFIED'
     	FILE_REFL	=	'NONE SPECIFIED'
     	FILE_RIP	=	'NONE SPECIFIED'
	FILE_SOURCE	=	'NONE SPECIFIED'
        FILE_ROUGH      =       'NONE SPECIFIED'
        FILE_KOMA       =       'NONE SPECIFIED'
        FILE_KOMA_CA    =       'NONE SPECIFIED'
        FILE_SEGMENT    =       'NONE SPECIFIED'
        FILE_SEGP       =       'NONE SPECIFIED'
        FILE_FAC        =       'NONE SPECIFIED'

     	WRITE(6,*)'Exit from RESET'

     	RETURN

     	END
