C +++
C
C Source: src/trace/msetup.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: msetup.F
C Revision 1.9  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.8  91/04/05  15:05:55  cwelnak
C changed quotes on #includes
C 
C Revision 1.7  91/03/22  10:40:07  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.6  91/02/14  11:37:13  khan
C Latest VMS version (and a new bug...)
C 
C Revision 1.5  90/11/13  14:01:53  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  21:37:54  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.3  90/07/14  22:51:13  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:15:43  khan
C All files opened with STATUS=UNKNOWN (as opposed to NEW as in VMS).
C 
C Revision 1.1  90/07/10  14:56:34  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C	SUBROUTINE	MSETUP
C
C	PURPOSE		To compute the parameters specifying a given
C			mirror.
C
C	OUTPUT		a) to common block
C			b) MSETxx, xx being the OE number
C
C---
	SUBROUTINE MSETUP (IWHICH)

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

	DIMENSION 	VIN(3),VNORM(3),POS1(3),POS2(3),
     $			RNCEN(3),RTCEN(3),
     $			VI_DIV(3),VS_DIV(3),V_CENTER(3)
	INTEGER		SERR
C
     	WRITE(6,*) 'Call to MSETUP'
#ifdef vms
     	CALL	FNAME	(FFILE,'MSET',IWHICH,2)
#else
     	CALL	FNAME	(FFILE,'mset',IWHICH,2)
#endif
	VIN(1)	 = 0.0D0
	VIN(2)	 = COSDEL
	VIN(3)	 = -SINDEL
C
C Move from INPUT
C
	RWIDX2	= -RWIDX2
	RLEN2	= -RLEN2
C
C Add the polynomial reading section for the facet operation
C	5/12/92 G.J.
C
	IF (F_FACET.EQ.1) THEN
	  CALL	READPOLY(FILE_FAC,IERR)
	  IF (IERR.NE.0) CALL LEAVE
     $		('MSETUP','Error from READPOLY in Facet',IERR)
	ENDIF

C
C Defines ratio of refraction indeces for refractor case
C
     	IF (F_REFRAC.EQ.1) ALFA = R_IND_IMA/R_IND_OBJ
C
C clear array
C
     	DO 100 I=1,10
 100	CCC(I)	= 0.0D0
C
C Computes the mirror parameters for all cases
C
C              1 2 3 4 5 6 7 8 9
C
	GO TO (1,2,3,4,5,5,7,8,9) FMIRR

 1	CONTINUE
C
C Spherical 
C
     	IF (F_EXT.EQ.0) THEN
	RMIRR = SSOUR*SIMAG*2/COSTHE/(SSOUR + SIMAG)
	  IF (F_JOHANSSON.EQ.1) THEN
	    R_JOHANSSON = RMIRR
	    RMIRR = RMIRR/2.0D0
	  ELSE
	  ENDIF
     	ELSE
     	END IF

	CCC(1)	 =  1.0D0	! X**2  # = 0 in cylinder case
	CCC(2)	 =  1.0D0	! Y**2
	CCC(3)	 =  1.0D0	! Z**2
	CCC(4)	 =   .0D0	! X*Y   # = 0 in cylinder case
	CCC(5)	 =   .0D0	! Y*Z
	CCC(6)	 =   .0D0	! X*Z   # = 0 in cylinder case
	CCC(7)	 =   .0D0	! X     # = 0 in cylinder case
	CCC(8)	 =   .0D0	! Y
	CCC(9)	 = -2*RMIRR	! Z
	CCC(10)  =   .0D0	! G

	GO TO 3000
C
C Elliptical *
C
 2	CONTINUE
     	IF (F_EXT.EQ.0) THEN
	  AXMAJ 	=  ( SSOUR + SIMAG )/2	
	  AXMIN 	=  SQRT(SIMAG*SSOUR)*COSTHE
     	ELSE
     	  ELL_THE = ELL_THE*TORAD
     	END IF

	AFOCI 	=  SQRT( AXMAJ**2-AXMIN**2 )
	
	ECCENT 	=  AFOCI/AXMAJ
C
C Computes the mirror center position
C
     	IF (F_EXT.EQ.0) THEN
C
C The center is computed on the basis of the object and image positions
C
	  YCEN  = (SSOUR-SIMAG)*0.5D0/ECCENT
	  ZCEN  = -SQRT(1-YCEN**2/AXMAJ**2)*AXMIN
     	ELSE
C
C The center is computed based on the pole position supplied by the
C user; notice that ZCEN is always negative, by definition.
C
     	  YCEN  = AXMAJ*AXMIN
     	  YCEN  = YCEN/SQRT(AXMIN**2+AXMAJ**2*TAN(ELL_THE)**2)
     	  ZCEN  = YCEN*TAN(ELL_THE)
     	  ZCEN  = - ABS(ZCEN)
     	 IF (COS(ELL_THE).LT.0) THEN
     	   YCEN = - ABS(YCEN)
     	 ELSE
     	   YCEN = ABS(YCEN)
     	 END IF
     	END IF
C
C Computes now the normal in the mirror center.
C
	RNCEN(1)  =   .0D0
	RNCEN(2)  = - 2*YCEN/AXMAJ**2
	RNCEN(3)  = - 2*ZCEN/AXMIN**2

	CALL NORM(RNCEN,RNCEN)
C
C Computes the tangent versor in the mirror center.
C
	RTCEN(1)  =  .0D0
	RTCEN(2)  =   RNCEN(3)
	RTCEN(3)  = - RNCEN(2)
C
C Computes now the quadric coefficient with the mirror center
C located at (0,0,0) and normal along (0,0,1)
C
	A 	=  1/AXMIN**2
	B 	=  1/AXMAJ**2
     	C 	=  A

	CCC(1) 	=  A
	CCC(2) 	=  B*RTCEN(2)**2 + C*RTCEN(3)**2
	CCC(3) 	=  B*RNCEN(2)**2 + C*RNCEN(3)**2
	CCC(4) 	=  .0D0
	CCC(5) 	=  2*(B*RNCEN(2)*RTCEN(2)+C*RNCEN(3)*RTCEN(3))
	CCC(6) 	=  .0D0
	CCC(7) 	=  .0D0
	CCC(8) 	=  .0D0
	CCC(9) 	=  2*(B*YCEN*RNCEN(2)+C*ZCEN*RNCEN(3))
	CCC(10) =  .0D0

	GO TO 3000
 7	CONTINUE
C
C Hyperbolical *
C
     	IF (F_EXT.EQ.0) THEN
	AXMAJ 	=  ( SSOUR - SIMAG )/2
C
C If AXMAJ > 0, then we are on the left branch of the hyp. Else we
C are onto the right one. We have to discriminate between the two cases
C In particular, if AXMAJ.LT.0 then the hiperb. will be convex.
C
     	AFOCI	=  0.5D0*SQRT( SSOUR**2 + SIMAG**2 + 2*SSOUR*SIMAG*
     $			   COS(2*THETA) )
     	AXMIN  =  SQRT( AFOCI**2 - AXMAJ**2 )
     	ELSE
     	  ELL_THE = ELL_THE*TORAD
	  AFOCI = SQRT( AXMIN**2 + AXMAJ**2 )
     	END IF
	
	ECCENT 	=  AFOCI/ABS( AXMAJ )
C
C bug fix 02 april 1990, unable to specify own values for hyperbola. 
C moved line beginning with AXMIN to within IF statement, added AFOCI.
C
C
C Computes the center coordinates in the hiperbola RF. 
C
     	IF (AXMAJ.GT.0.0D0) THEN
     	 YCEN	=   ( AXMAJ - SSOUR )/ECCENT			! < 0
     	ELSE
     	 YCEN	=   ( SSOUR - AXMAJ )/ECCENT			! > 0
     	END IF
     	ZCEN_ARG = ABS( YCEN**2/AXMAJ**2 - 1.0D0)
     	IF (ZCEN_ARG.GT.1.0D-14) THEN
     	  ZCEN	= - AXMIN * SQRT(ZCEN_ARG)			! < 0
     	ELSE
     	  ZCEN  = 0.0D0
     	END IF
C
C Computes now the normal in the same RF. The signs are forced to
C suit our RF.
C
     	RNCEN (1) =   0.0D0
     	RNCEN (2) = - ABS( YCEN )/AXMAJ**2			! < 0
     	RNCEN (3) = - ZCEN/AXMIN**2				! > 0

     	CALL 	NORM	(RNCEN,RNCEN)
C
C Computes the tangent in the same RF
C
     	RTCEN (1) =   0.0D0
     	RTCEN (2) = - RNCEN(3)					! > 0
     	RTCEN (3) =   RNCEN(2)					! > 0
C
C Coefficients of the canonical form
C
     	A	= - 1/AXMIN**2
     	B	=   1/AXMAJ**2
     	C	=   A
C
C Rotate now in the mirror RF. The equations are the same as for the
C ellipse case.
C
	CCC(1) 	=  A
	CCC(2) 	=  B*RTCEN(2)**2 + C*RTCEN(3)**2
	CCC(3) 	=  B*RNCEN(2)**2 + C*RNCEN(3)**2
	CCC(4) 	=  .0D0
	CCC(5) 	=  2*(B*RNCEN(2)*RTCEN(2)+C*RNCEN(3)*RTCEN(3))
	CCC(6) 	=  .0D0
	CCC(7) 	=  .0D0
	CCC(8) 	=  .0D0
	CCC(9) 	=  2*(B*YCEN*RNCEN(2)+C*ZCEN*RNCEN(3))
	CCC(10) =  .0D0

     	GO TO 3000
 3	CONTINUE
C
C Toroidal *
C
     	IF (F_EXT.EQ.0) THEN
     	R_MAJ	=   SSOUR*SIMAG*2/COSTHE/(SSOUR + SIMAG)
     	R_MIN	=   SSOUR*SIMAG*2*COSTHE/(SSOUR + SIMAG)
     	ELSE
     	END IF
C
C NOTE : The major radius is the in reality the radius of the torus
C max. circle. The true major radius is then
C
     	R_MAJ	=   R_MAJ - R_MIN

     	GO TO 1		! This is used for possible later calculations
     			! involving MIRROR1.

 4	CONTINUE
C
C Parabolical *
C
C Computes the parabola 
C
     	IF (F_SIDE.EQ.0) THEN
     	  IF (F_EXT.EQ.0)	PARAM	=   2*SSOUR*COSTHE**2
     		YCEN	= - SSOUR*SINTHE**2
     		ZCEN	= - 2*SSOUR*SINTHE*COSTHE
     	ELSE
     	  IF (F_EXT.EQ.0)	PARAM	=   2*SIMAG*COSTHE**2
     		YCEN	= - SIMAG*SINTHE**2
     		ZCEN	= - 2*SIMAG*SINTHE*COSTHE
     	END IF

     	CCC(1)	=   1.0D0
     	CCC(2)	=   COSTHE**2
     	CCC(3)	=   SINTHE**2
     	CCC(4)  =    .0D0
     	CCC(5)	=   2*COSTHE*SINTHE
     	CCC(6)	=    .0D0
     	CCC(7)	=    .0D0
     	CCC(8)	=    .0D0
     	CCC(9)	=   2*ZCEN*SINTHE - 2*PARAM*COSTHE
     	CCC(10) =    .0D0

     	IF (F_SIDE.EQ.0) THEN

     	CCC(5)	= - CCC(5)

     	ELSE
     	END IF

	GO TO 3000

5	CONTINUE
C
C Plane *
C The sign of CCC(9) is < 0 to keep consistency with the other cases
C normal.
C
	DO 200 I = 1,10
200	CCC(I) 	=   0.0D0
	CCC(9) 	= - 1.0D0

	GO TO 3000
C
C Ice-cream cone
C
 8	CONTINUE
       	CCC(1)	=  1.0D0
       	CCC(2)	=  1.0D0
C      	CCC(3)	=  -(TAND (CONE_A))**2
       	CCC(3)	=  -(TAN (TORAD*CONE_A))**2
       	GO TO 3000
C
C Polynomial case
C
 9	CONTINUE
       	CALL	READPOLY (FILE_MIR, IERR)
       	IF (IERR.NE.0) CALL LEAVE 
     $		('MSETUP','Return error from READPOLY',IERR)
3000	CONTINUE
C
C Set to zero the coeff. involving X for the cylinder case, after 
C projecting the surface on the desired plane.
C
     	  CIL_ANG = TORAD*CIL_ANG
     	  COS_CIL = COS(CIL_ANG)
     	  SIN_CIL = SIN(CIL_ANG)
     	IF (FCYL.EQ.1) THEN
     	  A_1	=   CCC(1)
     	  A_2	=   CCC(2)
     	  A_3	=   CCC(3)
     	  A_4	=   CCC(4)
     	  A_5	=   CCC(5)
     	  A_6	=   CCC(6)
     	  A_7	=   CCC(7)
     	  A_8	=   CCC(8)
     	  A_9	=   CCC(9)
     	  A_10	=   CCC(10)
     	  CCC(1) =  A_1*SIN_CIL**4 + A_2*COS_CIL**2*SIN_CIL**2 - !X^2
     $		    A_4*COS_CIL*SIN_CIL**3
     	  CCC(2) =  A_2*COS_CIL**4 + A_1*COS_CIL**2*SIN_CIL**2 - !Y^2
     $		    A_4*COS_CIL**3*SIN_CIL
     	  CCC(3) =  A_3						 !Z^2
     	  CCC(4) =  - 2*A_1*COS_CIL*   SIN_CIL**3 - 
     $		      2*A_2*COS_CIL**3*SIN_CIL +
     $		      2*A_4*COS_CIL**2*SIN_CIL**2		 !X Y
     	  CCC(5) =  A_5*COS_CIL**2 - A_6*COS_CIL*SIN_CIL	 !Y Z
     	  CCC(6) =  A_6*SIN_CIL**2 - A_5*COS_CIL*SIN_CIL	 !X Z
     	  CCC(7) =  A_7*SIN_CIL**2 - A_8*COS_CIL*SIN_CIL	 !X
     	  CCC(8) =  A_8*COS_CIL**2 - A_7*COS_CIL*SIN_CIL	 !Y
     	  CCC(9) =  A_9						 !Z
     	  CCC(10)=  A_10
     	END IF
C
C Set the correct mirror convexity. 
C
     	IF (F_CONVEX.NE.0) THEN
     	  CCC(5)  = - CCC(5)
     	  CCC(6)  = - CCC(6)
     	  CCC(9)  = - CCC(9)
     	ELSE
     	END IF
C
C Sets up the mirror reference frame; this include rotations only;
C the translations are taken care of in ROTIT.
C The flag F_MOVE controls the mirror motions; when reset (=0), the
C variables are reset to zero here, leaving the START.xx file unchanged.
C 
C
     	IF (F_MOVE.EQ.0) THEN
     	  X_ROT = 0.0D0
     	  Y_ROT = 0.0D0
          Z_ROT = 0.0D0
     	  OFFX  = 0.0D0
     	  OFFY  = 0.0D0
     	  OFFZ  = 0.0D0
     	END IF
     	 X_ROT	=   TORAD*X_ROT
     	 Y_ROT	=   TORAD*Y_ROT
     	 Z_ROT	=   TORAD*Z_ROT

     	 COSX	=   COS ( X_ROT )
     	 SINX	= - SIN ( X_ROT )

     	 COSY	=   COS ( Y_ROT )
     	 SINY	= - SIN ( Y_ROT )

     	 COSZ	=   COS ( Z_ROT )
     	 SINZ	= - SIN ( Z_ROT )
C
C Computes the rotation matrix coefficients
C
     	 U_MIR(1)	=   COSZ*COSY
     	 V_MIR(1)	=   COSZ*SINX*SINY - SINZ*COSX
     	 W_MIR(1)	=   COSZ*SINY*COSX + SINZ*SINX

     	 U_MIR(2)	=   SINZ*COSY
     	 V_MIR(2)	=   SINZ*SINX*SINY + COSZ*COSX
     	 W_MIR(2)	=   SINZ*SINY*COSX - SINX*COSZ

     	 U_MIR(3)	= - SINY
     	 V_MIR(3)	=   COSY*SINX
     	 W_MIR(3)	=   COSY*COSX
C
C Set up the parameters for the ripple case, if needed
C
     	IF (F_RIPPLE.EQ.1) THEN
	  IF (F_G_S.EQ.1) THEN
C
C Gaussian ripple selected.
C
C 

C
C CHECK/FIXME: Replace OPEN calls with library routine FOPENR()
C	CALL FOPENR (20, FILE_RIP, 'FORMATTED', IFERR, IOSTAT)
C
#ifdef vms
	OPEN (20,FILE=FILE_RIP,STATUS='OLD',IOSTAT=IOSTAT,READONLY)
#else
	OPEN (20,FILE=FILE_RIP,STATUS='OLD',IOSTAT=IOSTAT)
#endif
C
	IF (IOSTAT.NE.0) THEN
	  CALL LEAVE ('MSETUP',
     $		      'Error opening file "' // 
     $		      FILE_RIP(1:IBLANK(FILE_RIP)) // '".',
     $		      IOSTAT)
	ENDIF
     	READ (20,*)	N_RIP
	READ (20,*)	F_R_RAN
	READ (20,*)	IG_SEED
     	  DO 300 I=1,N_RIP
     	 IF (F_R_RAN.NE.1) THEN
     	READ (20,*)	X_GR(I)
     	READ (20,*)	Y_GR(I)
     	READ (20,*)	AMPLI(I)
     	READ (20,*)	SIG_X(I)
     	READ (20,*)	SIG_Y(I)
     	READ (20,*)	SIGNUM(I)
     	 ELSE
     	READ (20,*)	AMPL_IN(I)
     	READ (20,*)	SIG_XMIN(I)
     	READ (20,*)	SIG_XMAX(I)
     	READ (20,*)	SIG_YMIN(I)
     	READ (20,*)	SIG_YMAX(I)
         END IF
300	  CONTINUE
     	CLOSE (20)

     	  IF (F_R_RAN.EQ.1) THEN
     		DO 1000 I=1,N_RIP
     		X_GR(I) =   RWIDX2 + WRAN(IG_SEED)*RWIDX1
     		Y_GR(I) =   RLEN2  + WRAN(IG_SEED)*RLEN1
     		AMPLI(I)	=   AMPL_IN(I)*WRAN(IG_SEED)
     		SIG_X(I)=   SIG_XMIN(I) + WRAN(IG_SEED)*
     $				(SIG_XMAX(I) - SIG_XMIN(I))
     		SIG_Y(I)=   SIG_YMIN(I) + WRAN(IG_SEED)*
     $				(SIG_YMAX(I) - SIG_YMIN(I))
     		TEST	=   WRAN(IG_SEED)
     			IF (TEST.LE.0.5) THEN
     		SIGNUM(I)	=   1.0D0
     			ELSE
     		SIGNUM(I)	= - 1.0D0
     			END IF
1000		CONTINUE
     	  END IF

C
C CHECK/FIXME: Replace OPEN calls with library routine FOPENR()
C	CALL FOPENW (22, 'SURFACE_ERRORS', 'FORMATTED', IFERR, IOSTAT)
C
#ifdef vms
	OPEN (22,STATUS='NEW',FILE='SURFACE_ERRORS',IOSTAT=IOSTAT)
#else
	OPEN (22,STATUS='UNKNOWN',FILE='SURFACE_ERRORS',IOSTAT=IOSTAT)
	REWIND (22)
#endif
	IF (IOSTAT.NE.0) THEN
	  CALL LEAVE ('MSETUP',
     $		      'Error opening output file "SURFACE_ERRORS".',
     $		      IOSTAT)
	ENDIF
	WRITE (22,*) 	X_GR
	WRITE (22,*)    Y_GR
	WRITE (22,*)	AMPLI
	WRITE (22,*)	SIG_X
	WRITE (22,*)	SIG_Y
	WRITE (22,*)	SIGNUM
	WRITE (22,*)	'RANDOM'
	WRITE (22,*)	AMPL_IN
	WRITE (22,*)	SIG_XMIN
	WRITE (22,*)	SIG_XMAX
	WRITE (22,*)	SIG_YMIN
	WRITE (22,*)	SIG_YMAX
	CLOSE (22)

     	  ELSE IF (F_G_S.EQ.2) THEN
C
C External spline distortion selected.
C
	IFLAG	= -1
	SERR    = 0
	CALL	SUR_SPLINE	(XIN,YIN,ZOUT,VIN,IFLAG,SERR)
	
	  ELSE
C
C sinusoidal ripples are selected
C
	  END IF
     	END IF

	RLEN	=   RLEN1 - RLEN2
	RWIDX	=   RWIDX1 - RWIDX2
C
C Store the mirror parametersi if debug mode is set
C
	FDEBUG = 0
C
C SET FDEBUG = 1 if you want debugging -- MK.
C
     	IF (FDEBUG.EQ.1) THEN
#ifdef vms
	OPEN(UNIT=20, FILE=FFILE, STATUS='NEW')
#else
	OPEN(UNIT=20, FILE=FFILE, STATUS='UNKNOWN')
	REWIND (20)
#endif
     	WRITE (20,1110) IWHICH,FMIRR,FCYL
     	WRITE (20,1110) FHIT_C,FSHAPE,F_CONVEX,F_EXT
	WRITE (20,1112) 'Mirror radius ',RMIRR
	WRITE (20,1112) 'Major axis ',AXMAJ
	WRITE (20,1112) 'Minor axis ',AXMIN
	WRITE (20,1112) 'Eccentricity',ECCENT
	WRITE (20,1112) 'Major radius (optical)',R_MAJ+R_MIN
	WRITE (20,1112) 'Minor radius',R_MIN
	WRITE (20,1112) 'Parameter',PARAM
     	WRITE (20,1112) 'Cone angle',CONE_A
	WRITE (20,1112) 'Image edge ',RLEN1
	WRITE (20,1112) 'Source edge',RLEN2
	WRITE (20,1112) 'Right width',RWIDX1
	WRITE (20,1112) 'Left width',RWIDX2
	WRITE (20,1112) 'Upper V. div',VDIV1
	WRITE (20,1112) 'Lower V. div',VDIV2
	WRITE (20,1112) 'Right H.div',HDIV1
	WRITE (20,1112) 'Left H. div',HDIV2
	WRITE (20,1114) 'Quadric coefficients'
	WRITE (20,1115) (CCC(I), I=1,10)
#ifdef vms
 	CLOSE (20,DISP='SAVE')
#else
 	CLOSE (20)
#endif
     	END IF
1110	FORMAT (1X,4(2X,I4))
1112	FORMAT (1X,A15,T17,G20.13)
1113	FORMAT (1X,G20.13,/)
1114	FORMAT (1X,A)
1115	FORMAT (1X,G20.13)
     	WRITE(6,*) 'Exit from MSETUP'

D	WRITE (17,*)	'--------------------------------------------'
D	WRITE (17,*)	'MSETUP INPUT'
D	WRITE (17,*)	IWHICH,FDIM,FMIRR,FCYL,F_MOVE
D	WRITE (17,*)	COSDEL,SINDEL,COSTHE,SINTHE
D	WRITE (17,*)	SSOUR,SIMAG
D	WRITE (17,*)	'****'
D	 WRITE (17,*)	DELTA,VDIV,HDIV
D	 WRITE (17,*)	PSOUR
D	WRITE (17,*)	'****'
D	 WRITE (17,*)   RLEN1,RLEN2,RWIDX1,RWIDX2
D	 WRITE (17,*)   PSOUR
D	WRITE (17,*)	'****'
D	 WRITE (17,*)	RLEN1,RLEN2,RWIDX1,RWIDX2
D	 WRITE (17,*)	VDIV1,VDIV2,HDIV1,HDIV2
D	WRITE (17,*)	'****'
D	WRITE (17,*)	F_RIPPLE,F_R_RAN,IG_SEED
D	WRITE (17,*)	FILE_RIP
D	WRITE (17,*)	'--------------------------------------------'

D	WRITE (17,*)	'--------------------------------------------'
D	WRITE (17,*)	'MSETUP OUTPUT'
D	WRITE (17,*)	RMIRR
D	WRITE (17,*)	AXMAJ,AXMIN,AFOCI,ECCENT
D	WRITE (17,*)	YCEN,ZCEN
D	WRITE (17,*)	RNCEN
D	WRITE (17,*)	RTCEN
D	WRITE (17,*)	A,B,C
D	WRITE (17,*)	R_MAJ,R_MIN
D	WRITE (17,*)	CCC
D	WRITE (17,*)
D	WRITE (17,*)    FDIM
D	 WRITE (17,*)	DELTA1
D	 WRITE (17,*)	RLEN1,RLEN2,RLEN
D	WRITE (17,*)	RWIDX,RWIDX1,RWIDX2
D	WRITE (17,*)	'****'
D	WRITE (17,*)    FDIM
D	 WRITE (17,*)	VS_DIV
D	 WRITE (17,*)	VI_DIV
D	 WRITE (17,*)	Z_IMAGE,Z_SOURCE,X_MIRROR_1,X_MIRROR_2
D	 WRITE (17,*)	VDIV1,VDIV2,HDIV1,HDIV2
D	WRITE (17,*)	COS_VDIV1,COS_VDIV2
D	WRITE (17,*)	TAN_HDIV1,TAN_HDIV2
D	WRITE (17,*)	'--------------------------------------------'
	END
