C +++
C
C Source: src/trace/image.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: image.F
C Revision 1.8  1991/07/06  20:07:38  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  15:05:46  cwelnak
C changed quotes on #includes
C 
C Revision 1.6  91/03/21  16:17:32  cwelnak
C SUN version -- INCLUDE to #include
C 
C Revision 1.5  90/11/13  14:01:47  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/19  21:37:48  khan
C Put #ifdef's to make it work on BOTH VMS and Ultrix
C 
C Revision 1.3  90/07/14  22:51:07  khan
C All public include files (common.blk, etc) are now in ./../include/ dir.
C 
C Revision 1.2  90/07/14  12:12:36  khan
C Added the new binary flag to WRITE_OFF (default in VMS).
C 
C Revision 1.1  90/07/10  14:56:14  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	IMAGE
C
C	PURPOSE		Computes the intercept of the beam with the 
C			continuation plane. May also compute intercepts
C			on plates.
C
C	ALGORITHM	Direct calculation.
C
C	INPUTS		a) The precomputed parameters through common 
C			   blocks, as obtained from IMREF.
C			b) i_what, OE counter.
C			c) ray, the array describing the beam.
C
C	OUTPUTS		a) ray, the array describing the beam.
C			b) STARxx.DAT, where xx = i_what
C
C---
	SUBROUTINE 	IMAGE1 	(RAY,AP,PHASE,I_WHAT)

** This s. computes the intersection of the ray with the image plane.
** The format is the standard (12,N) matrix. The result is in the form
** of the (u,v) coordinates onto the image plane. These will be used
** by the module RESTART to generate the source for the next optical
** element, if any.

#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif

	DIMENSION RAY(12,N_DIM),PLATE(12,N_DIM),AP(3,N_DIM),
     $		  PHASE(3,N_DIM),RAY_STORE(6,N_DIM)
	DIMENSION V_OUT(3),P_MIR(3),P_IMAG(3),A_VEC(3),AP_VEC(3)
     	DIMENSION PLATE_CEN(3)
	REAL*8 XNEW,ZNEW
C
C Save some local large arrays to avoid overflowing stack.
C
	SAVE		PLATE, RAY_STORE

     	WRITE(6,*)'Call to IMAGE'

** Computes first the intercept onto the true image plane, to be used
** by RESTART.

     	DO 100	J=1,NPOINT

** Checks if the ray has been reflected by the mirror.

     	IF (RAY(10,J).LT.-1.0D6)  GO TO 100
     	 IF (N_PLATES.GT.0) THEN
     	   RAY_STORE(1,J) = RAY(1,J)
     	   RAY_STORE(2,J) = RAY(2,J)
     	   RAY_STORE(3,J) = RAY(3,J)
     	   RAY_STORE(4,J) = RAY(4,J)
     	   RAY_STORE(5,J) = RAY(5,J)
     	   RAY_STORE(6,J) = RAY(6,J)
     	 END IF
     	P_MIR(1)	=   RAY(1,J)
     	P_MIR(2)	=   RAY(2,J)
		P_MIR(3)	=   RAY(3,J)

     	V_OUT(1)  =   RAY(4,J)
     	V_OUT(2)  =   RAY(5,J)
     	V_OUT(3)  =   RAY(6,J)

     	A_VEC(1)	=   RAY(7,J)
     	A_VEC(2)	=   RAY(8,J)
     	A_VEC(3)	=   RAY(9,J)

     	ABOVE	=   T_IMAGE - P_MIR(1)*C_STAR(1)
     $			    - P_MIR(2)*C_STAR(2)
     $			    - P_MIR(3)*C_STAR(3)

     	BELOW   =   C_STAR(1)*V_OUT(1) + C_STAR(2)*V_OUT(2) +
     $		    C_STAR(3)*V_OUT(3)

     	IF (BELOW.NE.0.0D0) THEN
     		DIST	=   ABOVE/BELOW
     	ELSE
     		RAY(10,J)  = - 3.0D6
     		GO TO 100
     	END IF

** Computes now the intersections onto TRUE image plane.

     	P_IMAG(1)  =   P_MIR(1) + DIST*V_OUT(1)
     	P_IMAG(2)  =   P_MIR(2) + DIST*V_OUT(2)
     	P_IMAG(3)  =   P_MIR(3) + DIST*V_OUT(3)

** Rotate now the results in the STAR (or TRUE image) reference plane.
** Computes the projection of P_MIR onto the image plane versors.

     	CALL VECTOR (RIMCEN,P_IMAG,P_IMAG)

     	CALL DOT (P_IMAG,UXIM,UX_1)
     	CALL DOT (P_IMAG,VZIM,VZ_1)
     	CALL DOT (P_IMAG,VNIMAG,WY_1)

** Computes now the new directions for the beam in the U,V,N ref.

     	CALL DOT (V_OUT,UXIM,VV_1)
     	CALL DOT (V_OUT,VNIMAG,VV_2)
     	CALL DOT (V_OUT,VZIM,VV_3)

** Computes the new directions of A in the U,V,N ref.frame

     	CALL DOT (A_VEC,UXIM,A_1)
     	CALL DOT (A_VEC,VNIMAG,A_2)
     	CALL DOT (A_VEC,VZIM,A_3)

** Saves the results

     	RAY(1,J)  =   UX_1
     	RAY(2,J)  =   WY_1
     	RAY(3,J)  =   VZ_1
     	RAY(4,J)  =   VV_1
     	RAY(5,J)  =   VV_2
     	RAY(6,J)  =   VV_3
     	RAY(7,J)  =   A_1
     	RAY(8,J)  =   A_2
     	RAY(9,J)  =   A_3

	IF (NCOL.GT.12) THEN
     	  PHASE	(1,J) = PHASE (1,J) + DIST*R_IND_IMA
	  IF (NCOL.EQ.18) THEN
	    AP_VEC(1)	= AP(1,J)
	    AP_VEC(2)	= AP(2,J)
	    AP_VEC(3)	= AP(3,J)
     	    CALL DOT (AP_VEC,UXIM,A_1)
     	    CALL DOT (AP_VEC,VNIMAG,A_2)
     	    CALL DOT (AP_VEC,VZIM,A_3)
	    AP(1,J)	= A_1
	    AP(2,J)	= A_2
	    AP(3,J)	= A_3
	  END IF
	END IF

100	CONTINUE

C
C 4/26/93 making use of the slit rotation option.
C

     	IF (FSLIT.EQ.1)	THEN

     		U_1   = - SLLEN/2
     		U_2   =   SLLEN/2
     		V_1   = - SLWID/2
     		V_2   =   SLWID/2
		SLTILT= TORAD*SLTILT

     	  DO 200 ICHECK=1,NPOINT
		XNEW = RAY(1,ICHECK)*COS(SLTILT) +
     $                 RAY(3,ICHECK)*SIN(SLTILT)
		ZNEW = RAY(3,ICHECK)*COS(SLTILT) -
     $                 RAY(1,ICHECK)*SIN(SLTILT)

     		TEST1 = (XNEW - U_1)*(U_2 - XNEW)
     		TEST2 = (ZNEW - V_1)*(V_2 - ZNEW)
C    		TEST1 = (RAY(1,ICHECK) - U_1)*(U_2 - RAY(1,ICHECK))
C    		TEST2 = (RAY(3,ICHECK) - V_1)*(V_2 - RAY(3,ICHECK))
     	    IF (TEST1.GE.0.0D0.AND.TEST2.GE.0.0D0) THEN
     		PLATE(10,ICHECK) = 1.0D0
     	    ELSE
     		RAY(10,ICHECK)   = - 2.0D0
     		PLATE(10,ICHECK) = - 2.0D0
     	    END IF

200	  CONTINUE

     	ELSE
     	END IF
C
C Write out file if flag is enabled
C
     	IF	((FWRITE.EQ.0).OR.(FWRITE.EQ.2)) THEN
#ifdef vms
     	  CALL	FNAME (FFILE, 'STAR', I_WHAT, 2)
#else
     	  CALL	FNAME (FFILE, 'star', I_WHAT, 2)
#endif
	  IFLAG	= 0
     	  CALL	WRITE_OFF (FFILE,RAY,PHASE,AP,NCOL,NPOINT,IFLAG,
     $			   0,IERR)
     	  IF (IERR.NE.0)	
     $		CALL LEAVE ('IMAGE','Error writing STAR',IERR)
     	END IF
C
C Computes now the (optional) images.
C
     	DO 300 JJ=1,N_PLATES

     	PLATE_CEN(1)	=    C_STAR(1)*D_PLATE(JJ)
     	PLATE_CEN(2)	=    C_STAR(2)*D_PLATE(JJ)
     	PLATE_CEN(3)	=    C_STAR(3)*D_PLATE(JJ)

     	DO 400 J=1,NPOINT
C
C Checks if the ray has been reflected by the mirror.
C
     	IF (RAY(10,J).LT.-1.0D6) THEN
     		PLATE(10,J)  = - 1.0D6
     		GO TO 400
     	ELSE
     	END IF
C
     	P_MIR(1)	=   RAY_STORE(1,J)	
     	P_MIR(2)	=   RAY_STORE(2,J)
	P_MIR(3)	=   RAY_STORE(3,J)

     	V_OUT(1)  =   RAY_STORE(4,J)
     	V_OUT(2)  =   RAY_STORE(5,J)
     	V_OUT(3)  =   RAY_STORE(6,J)

     	ABOVE	=   (PLATE_CEN(1) - P_MIR(1))*C_PLATE(1) +
     $		    (PLATE_CEN(2) - P_MIR(2))*C_PLATE(2) +
     $		    (PLATE_CEN(3) - P_MIR(3))*C_PLATE(3)

     	BELOW   =   C_PLATE(1)*V_OUT(1) + C_PLATE(2)*V_OUT(2) +
     $		    C_PLATE(3)*V_OUT(3)

     	IF (BELOW.NE.0.0D0) THEN
     		DIST	=   ABOVE/BELOW
     	ELSE
     		PLATE(10,J)  = - 3.0D0
     		GO TO 400
     	END IF
C
C Computes now the intersections onto the PLATE plane.
C
     	P_IMAG(1)  =   P_MIR(1) + DIST*V_OUT(1)
     	P_IMAG(2)  =   P_MIR(2) + DIST*V_OUT(2)
     	P_IMAG(3)  =   P_MIR(3) + DIST*V_OUT(3)
C
C Rotate now the results in the PLATE plane.
C Computes the projection of P_IMAG onto the image plane versors.
C
     	CALL VECTOR (PLATE_CEN,P_IMAG,P_IMAG)

     	CALL DOT (P_IMAG,UX_PL,UX_1)
     	CALL DOT (P_IMAG,VZ_PL,VZ_1)
     	CALL DOT (P_IMAG,WY_PL,WY_1)
C
C Computes now the new directions for the beam in the U,V,N ref.
C
     	CALL DOT (V_OUT,UX_PL,VV_1)
     	CALL DOT (V_OUT,WY_PL,VV_2)
     	CALL DOT (V_OUT,VZ_PL,VV_3)

     	PLATE(1,J)  =   UX_1
     	PLATE(2,J)  =   WY_1
     	PLATE(3,J)  =   VZ_1
     	PLATE(4,J)  =   VV_1
     	PLATE(5,J)  =   VV_2
     	PLATE(6,J)  =   VV_3
     	PLATE(7,J)   =   RAY(7,J)
     	PLATE(8,J)   =   RAY(8,J)
     	PLATE(9,J)   =   RAY(9,J)
     	PLATE(10,J)   =   RAY(10,J)
     	PLATE(11,J)   =   RAY(11,J)
     	PLATE(12,J)   =   RAY(12,J)
400	CONTINUE

C
	KOUNTS	= 100*I_WHAT + JJ
#ifdef vms
     	CALL	FNAME	(FFILE, 'PLATE', KOUNTS, 4)
#else
     	CALL	FNAME	(FFILE, 'plate', KOUNTS, 4)
#endif
	IFLAG	= 0
     	CALL	WRITE_OFF (FFILE,PLATE,PHASE,AP,NCOL,NPOINT,IFLAG,
     $			   0,IERR)
     	IF (IERR.NE.0)	CALL LEAVE ('IMAGE','Error writing PLATE',IERR)
C The following cannot be implemented until the phase and AP is recompute at
C the plate.
C	IF (F_POLAR.EQ.1) THEN
C	  CALL	FNAME	(FFILE, 'PLATEP', I_WHAT, 2)
C	  CALL  WRITE_AP	(FFILE,NPOINT,PLATE,AP,IERR)
C	  IF (IERR.EQ.1) STOP 'Error writing PLATEP'
C	  CALL	FNAME	(FFILE, 'PHPLAT', I_WHAT, 2)
C	  CALL  WRITE_PHA	(FFILE,NPOINT,PHASE,IERR)
C	  IF (IERR.EQ.1) STOP 'Error writing PLATEP'
C	END IF

300	CONTINUE
#ifdef vms
	MPURGE(1)	= %LOC(PLATE(1,1))
	MPURGE(2)	= %LOC(PLATE(12,N_DIM))
	CALL	SYS$PURGWS (MPURGE)
	MPURGE(1)	= %LOC(RAY_STORE(1,1))
	MPURGE(2)	= %LOC(RAY_STORE(6,N_DIM))
	CALL	SYS$PURGWS (MPURGE)
#endif
9990	FORMAT (I4.4)
     	WRITE(6,*)'Exit from IMAGE'

	END
