C +++
C
C Source: src/tools/math/bpold.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	bpold.f
C Revision 1.1  90/07/17  13:54:47  khan
C Initial revision
C 
C 
C ---

C+++
C	FUNCTION	BPOL (X,J)
C
C	Purpose		Computes the shifted Legendre polinomials of 
C			degree J at point X
C
C	Algorithm	Direct definition of the shifted Legendre
C			polinomials.
C
C	Limits		Argument domain must be within [ 0,1 ]
C
C---
     	FUNCTION	BPOL (X,J)
     	IMPLICIT	REAL*8 (A-H,O-Z)
     	DIMENSION	XTEMP (20)
     	IF (X.GT.1.0.OR.X.LT.0.0)	WRITE(6,*)'Invalid argument ',X,J
     	XVAR	=  2*X - 1

	XTEMP(1)	=   1	
C 	ZERO DEGREE

	XTEMP(2)	=   XVAR
	XTEMP(3)	=   0.5D0*( 3*XVAR**2 - 1.0D0 )
     	DO 10  I=3,J
     	 XTEMP(I+1) = (2*I+1)*XVAR*XTEMP(I) - I*XTEMP(I-1)
     	 XTEMP(I+1) = XTEMP(I+1)/(I+1)
10      CONTINUE
     	BPOL = XTEMP(J+1)
     	RETURN
     	END
