//
// global.h: All EXCON globals.
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef excon_ui_global_h
#define excon_ui_global_h

#include <string>

// All global variables in excon.

// ===================================================================== //

struct Globals {
    static class CleanupMgr* cleanupmgr;
    static class Stats* stats;
    static char* programname;
    static class Pmu* pmu;
    static class ExpMgr* expmgr;
    static class ToolsMgr* toolsmgr;
    static class JobMgr* jobmgr;
    static class Logger* logger;
    static class Stq* file_search_path;
    static class Stq* program_search_path;

    static bool abort_on_error;

    static bool debug;

    //
    // info about user
    // 
    static std::string username;
    static std::string homedir;
    static std::string curdir;
    static std::string shell;
};

// ===================================================================== //

//
// useful macros used everywhere. Should these be in util.h?
//

//
// simple macro to do the logging depending on current log level.
//
// Example:
//
//    EXCON_LOG(Logger::run) << "Running program ... " << endl;
//
// where EXCON_logger is an existing Logger object.
//
// If you never use OR'd combos in LOG macro, use the following:
//
//    EXCON_LOG2(run) << "Running program ..." << endl;
//
// log always, not matter what the setting is!
//
//    EXCON_LOG_ALWAYS << "Running program ..." << endl;
//

#define EXCON_LOG(lvl) \
    if (!(Globals::logger->cur_loglevel() & (lvl))); else (*Globals::logger)

#define EXCON_LOG2(lvl) \
    if (!(Globals::logger->cur_loglevel() & Logger::lvl)); \
    else (*Globals::logger)

#define EXCON_LOG_ALWAYS (*Globals::logger)

// ====================================================================== //

#endif/*excon_ui_global_h*/
