C +++
C
C Source: src/lib/quartic.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	quartic.F
C Revision 1.8  92/09/22  08:50:08  cwelnak
C Facet calculations -- G.J. Chen
C 
C Revision 1.7  91/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C 
C Revision 1.6  91/04/05  13:54:34  cwelnak
C changed quotes on #include
C 
C Revision 1.5  91/03/25  10:45:51  cwelnak
C SUN version - INC to #inc
C 
C Revision 1.4  90/11/13  14:05:02  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/20  22:05:20  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.2  90/07/15  15:31:06  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.1  90/07/10  14:56:40  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	QUARTIC
C
C	PURPOSE		To compute the intercepts on a given torus for
C			a ray.
C
C	INPUT		XIN	ray starting point
C			V       ray direction
C			i_res	-1, ripple case
C				 1, ordinary torus
C
C	OUTPUT		a) "answer", distance from point to intercept
C			    the value returned is the LARGEST of the 4
C			    possible values.
C			b) "i_res", status flag; +1 good
C			  			 -1 all intercepts complex
C---
     	SUBROUTINE QUARTIC (XIN, V, ANSWER, I_RES)
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
#endif
C
     	COMPLEX*16	H_OUTPUT(4)
     	DIMENSION	XIN(3),P(3),V(3),COEFF(5),TEST1(4),TEST2(4)
	ANSWER	=   0.0D0
     	P(1)	= XIN(1)
     	P(2)	= XIN(2)
C
C move the ref. frame to the torus one.
C
	IF (F_TORUS.EQ.0) THEN
     	  P(3)	= XIN(3) - R_MAJ - R_MIN   
	ELSE IF (F_TORUS.EQ.1) THEN
     	  P(3)	= XIN(3) - R_MAJ + R_MIN   
	ELSE IF (F_TORUS.EQ.2) THEN
     	  P(3)	= XIN(3) + R_MAJ - R_MIN   
	ELSE IF (F_TORUS.EQ.3) THEN
     	  P(3)	= XIN(3) + R_MAJ + R_MIN   
	END IF     					   
** Evaluates the quartic coefficients **
      	A	= R_MAJ**2 - R_MIN**2
      	B	= - (R_MAJ**2 + R_MIN**2)
      	AA	= P(1)*V(1)**3 + P(2)*V(2)**3 + P(3)*V(3)**3 +
     $		  V(1)*V(2)**2*P(1) + V(1)**2*V(2)*P(2) +
     $		  V(1)*V(3)**2*P(1) + V(1)**2*V(3)*P(3) +
     $		  V(2)*V(3)**2*P(2) + V(2)**2*V(3)*P(3)
     	AA	= 4*AA
      	BB	= 3*P(1)**2*V(1)**2 + 3*P(2)**2*V(2)**2 + 
     $						3*P(3)**2*V(3)**2 +
     $		  V(2)**2*P(1)**2 + V(1)**2*P(2)**2 + 
     $		  V(3)**2*P(1)**2 + V(1)**2*P(3)**2 +
     $		  V(3)**2*P(2)**2 + V(2)**2*P(3)**2 +
     $		  A*V(1)**2 + B*V(2)**2 + B*V(3)**2 +
     $		  4*V(1)*V(2)*P(1)*P(2) + 
     $		  4*V(1)*V(3)*P(1)*P(3) + 
     $		  4*V(2)*V(3)*P(2)*P(3)
     	BB	= 2*BB
      	CC	= P(1)**3*V(1) + P(2)**3*V(2) + P(3)**3*V(3) +
     $		  P(2)*P(1)**2*V(2) + P(1)*P(2)**2*V(1) +
     $		  P(3)*P(1)**2*V(3) + P(1)*P(3)**2*V(1) +
     $		  P(3)*P(2)**2*V(3) + P(2)*P(3)**2*V(2) +
     $		  A*V(1)*P(1) + B*V(2)*P(2) + B*V(3)*P(3)
     	CC	= 4*CC
      	DD	= P(1)**4 + P(2)**4 + P(3)**4 +
     $		  2*P(1)**2*P(2)**2 + 2*P(1)**2*P(3)**2 +
     $		  2*P(2)**2*P(3)**2 +
     $		  2*A*P(1)**2 + 2*B*P(2)**2 + 2*B*P(3)**2 +
     $		  A**2
D	WRITE(6,*)' AA ',AA
D	WRITE(6,*)' BB ',BB
D	WRITE(6,*)' CC ',CC
D	WRITE(6,*)' DD ',DD
     	COEFF(1)	=  1.0D0
     	COEFF(2)	=  AA
     	COEFF(3)	=  BB
     	COEFF(4)	=  CC
     	COEFF(5)	=  DD
     	CALL 	ZRPOLY (COEFF,4,H_OUTPUT,IER)
     	IF (IER.NE.0) WRITE(6,*)'Watch out: error in ZRPOLY',IER
	DO 91 I = 1,4
     	  TEST1(I)	= DIMAG( H_OUTPUT(I) )
91	CONTINUE
     	CHECK 	= TEST1(1)*TEST1(2)*TEST1(3)*TEST1(4)
     	IF (CHECK.NE.0.0D0) THEN
C all the solutions are complex; the beam is completely out of
C of the mirror.
     		I_RES	= -1
     		RETURN
     	ELSE
     	END IF
	IF (I_RES.LT.0) THEN
C
C Ripple case : take the closest intercept.
C
     	  ANSWER	= 1.0D+20
	  DO 11 I = 1,4 
     	    IF (TEST1(I).EQ.0.0D0) THEN
	      IF (ABS(DREAL(H_OUTPUT(I))).LT.ABS(ANSWER))
     $		 ANSWER = DREAL( H_OUTPUT(I) )
     	      END IF
11	  CONTINUE
	ELSE
C
C Usual case. 
C
	  N_TEST	= 0
	  DO 21 I = 1, 4
	    TEMP=DREAL(H_OUTPUT(I))
	    IF (TEST1(I).EQ.0.0D0) THEN
C
C In the facet calculation, we only consider the positive
C intercepted length while in the Shadow we consider both the
C positive and negative solutions.
C the following arrangement can seperate the facet and
C original calculations. 5/12/92 G.J.
C
	 IF (F_FACET.GT.0) THEN
	  IF (TEMP.GE.0.0D0) THEN
	    N_TEST       =N_TEST + 1
	    TEST2(N_TEST)        = TEMP
	  ENDIF
	 ELSE
	  N_TEST = N_TEST + 1
	  TEST2(N_TEST)	= TEMP
	 END IF
	    END IF
21	  CONTINUE
C
C Sort the real intercept in ascending order.
C
	  DO 31 I = 1, N_TEST
	    IMIN	= I
	    AMIN	= TEST2(I)
	    DO 41 J = I, N_TEST
	      IF (TEST2(J).LT.AMIN) THEN
	        AMIN	= TEST2(J)
	        IMIN	= J
	      END IF
41	    CONTINUE
	    XTEMP	= TEST2(I)
	    TEST2(I)	= TEST2(IMIN)
	    TEST2(IMIN)	= XTEMP
31	  CONTINUE
C
C Pick the output according to F_TORUS.
C
	  IF (F_TORUS.EQ.0) THEN
	    ANSWER	= TEST2(N_TEST)
	  ELSE IF (F_TORUS.EQ.1) THEN
	   IF (N_TEST.GT.1) THEN
	    ANSWER	= TEST2(N_TEST-1)
	   ELSE
	    I_RES	= -1
	    RETURN
	   END IF
	  ELSE IF (F_TORUS.EQ.2) THEN
	   IF (N_TEST.GT.1) THEN
	    ANSWER	= TEST2(2)
	   ELSE
	    I_RES	= -1
	    RETURN
	   END IF
	  ELSE IF (F_TORUS.EQ.3) THEN
	    ANSWER	= TEST2(1)
	  END IF
	END IF

     	IF (ANSWER.GT.0.0D0.AND.ANSWER.LT.1.0D+20) THEN
     	 I_RES = 1
     	 RETURN
     	ELSE
     	 I_RES	= - 1
     	 RETURN
     	END IF
     	END
