C +++
C
C Source: src/lib/mfp.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: mfp.F
C Revision 1.5  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.4  91/04/05  13:54:30  cwelnak
C changed quotes on #include
C 
C Revision 1.3  91/03/25  14:44:57  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/03/15  15:38:09  khan
C Getting ready for Sun port...
C 
C Revision 1.1  91/01/24  10:41:33  khan
C Initial revision
C 
C 
C ---


#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C
C	SUBROUTINE MFP  (mean free path)
C
C       This subroutine return a value following the exponential decay
C	distribution law. We initialize the subroutine (flag negative) 
C	calling it with ARG the minimum and the maximun of the interval
C	in which we want the result. After that, we call again the 
C	subroutine with a flag no negative to have the result.
C
C
C
	SUBROUTINE	MFP (ARG,ISEED,IFLAG)

     	IMPLICIT	REAL*8		(A-H,O-Z)
	SAVE		YMIN, YMAX
C
	IF (IFLAG.LT.0) THEN
	 IF (IFLAG.EQ.-2)  YMIN = 1.0D0 - DEXP(-ARG)
	 IF (IFLAG.EQ.-1)  YMAX = 1.0D0 - DEXP(-ARG)
	ELSE
	 AA0  = WRAN(ISEED)
	 YVAL = YMIN + AA0*(YMAX-YMIN)
	 IF ((YVAL.GT.1.0D0).OR.(YVAL.LT.0.0D0)) CALL MSSG
     $ ('Error from MFP','Argument outside of [0,1] interval',0)
	 ARG  = -LOG(1-YVAL)
	END IF
	RETURN
	END
