C +++
C
C Source: src/lib/gnormal.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: gnormal.F
C Revision 1.7  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  13:54:20  cwelnak
C changed quotes on #include
C 
C Revision 1.5  91/03/23  14:38:27  khan
C SUN version -- INC to #inc
C 
C Revision 1.4  91/03/15  15:38:04  khan
C Getting ready for Sun port...
C 
C Revision 1.3  91/02/21  14:33:52  khan
C replaced RAN with WRAN (wrapper for RAN with checks for 0.0D0 return)
C 
C Revision 1.2  91/01/29  13:56:00  cwelnak
C added REAL*4 RAN statement
C 
C Revision 1.1  91/01/24  10:41:30  khan
C Initial revision
C 
C 
C ---


#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C
C	SUBROUTINE GNORMAL
C
C       This subroutine give us a value following the gaussian
C	distribution law. We initialize the subroutine (flag negative) 
C	calling it with ARG the minimum and the maximun of the interval
C	in which we want the result. After that, we call again the 
C	subroutine with a flag no negative to have the result.
C
C
C
     	SUBROUTINE	GNORMAL (ARG,ISEED,IFLAG)

     	IMPLICIT	REAL*8		(A-H,O-Z)
	SAVE		YMIN, YMAX

	IF (IFLAG.LT.0) THEN
	 IF (IFLAG.EQ.-2)  CALL GNORFUNC (ARG,YMIN)
	 IF (IFLAG.EQ.-1)  CALL GNORFUNC (ARG,YMAX)
	ELSE
	 YVAL = YMIN + WRAN(ISEED)*(YMAX-YMIN)
	 CALL MDNRIS(YVAL,ARG,IERR)
	 IF (IERR.NE.0) CALL MSSG
     $('Error from GNORMAL','Value outside the interval',IERR) 
	END IF
	RETURN
	END
C
C	Subroutine GNORFUNC (Normal or gaussian probability distribution
C	function).
C
	SUBROUTINE GNORFUNC (Y,P)

     	IMPLICIT	REAL*8		(A-H,O-Z)
#if defined(G77)
	EXTERNAL ERFC
#endif

	Y0 =-Y/DSQRT(2.0D0)
	P  = 0.5D0*ERFC(Y0)

	RETURN
	END

C
C	FUNCTION ERFC (Complemented Error Fuction)
C	Reference: See Numerical Recipes in Fortran, Cambridge U. Press
C	(1989) for a description of this and following subroutines.
C
      DOUBLE PRECISION FUNCTION ERFC(X)
      IMPLICIT	REAL*8	(A-H,O-Z)
      IF(X.LT.0D0)THEN
        ERFC=1.0D0+GAMMP(0.5D0,X**2)
      ELSE
        ERFC=GAMMQ(0.5D0,X**2)
      ENDIF
      RETURN
      END
C
C
C
      DOUBLE PRECISION FUNCTION GAMMP(A,X)
      IMPLICIT	REAL*8	(A-H,O-Z)
      IF(X.LT.0.0D0.OR.A.LE.0.0D0)PAUSE
      IF(X.LT.A+1.0D0)THEN
        CALL GSER(GAMSER,A,X,GLN)
        GAMMP=GAMSER
      ELSE
        CALL GCF(GAMMCF,A,X,GLN)
        GAMMP=1.0D0-GAMMCF
      ENDIF
      RETURN
      END
C
C
C
      DOUBLE PRECISION FUNCTION GAMMQ(A,X)
      IMPLICIT	REAL*8	(A-H,O-Z)
      IF(X.LT.0.0D0.OR.A.LE.0.0D0)PAUSE
      IF(X.LT.A+1.0D0)THEN
        CALL GSER(GAMSER,A,X,GLN)
        GAMMQ=1.0D0-GAMSER
      ELSE
        CALL GCF(GAMMCF,A,X,GLN)
        GAMMQ=GAMMCF
      ENDIF
      RETURN
      END
C
C
C
      SUBROUTINE GCF(GAMMCF,A,X,GLN)
      IMPLICIT	REAL*8	(A-H,O-Z)
      PARAMETER (ITMAX=100,EPS=3.D-7)
      GLN=GAMMLN(A)
      GOLD=0.D0
      A0=1.D0
      A1=X
      B0=0.D0
      B1=1.D0
      FAC=1.D0
      DO 11 N=1,ITMAX
        AN=FLOAT(N)
        ANA=AN-A
        A0=(A1+A0*ANA)*FAC
        B0=(B1+B0*ANA)*FAC
        ANF=AN*FAC
        A1=X*A0+ANF*A1
        B1=X*B0+ANF*B1
        IF(A1.NE.0.)THEN
          FAC=1.0D0/A1
          G=B1*FAC
          IF(ABS((G-GOLD)/G).LT.EPS)GO TO 1
          GOLD=G
        ENDIF
11    CONTINUE
      PAUSE 'A too large, ITMAX too small'
1     GAMMCF=DEXP(-X+A*DLOG(X)-GLN)*G
      RETURN
      END
C
C
C
      SUBROUTINE GSER(GAMSER,A,X,GLN)
      IMPLICIT	REAL*8	(A-H,O-Z)
      PARAMETER (ITMAX=100,EPS=3.D-7)
      GLN=GAMMLN(A)
      IF(X.LE.0.0D0)THEN
        IF(X.LT.0.0D0)PAUSE
        GAMSER=0.0D0
        RETURN
      ENDIF
      AP=A
      SUM=1.0D0/A
      DEL=SUM
      DO 11 N=1,ITMAX
        AP=AP+1.0D0
        DEL=DEL*X/AP
        SUM=SUM+DEL
        IF(ABS(DEL).LT.ABS(SUM)*EPS)GO TO 1
11    CONTINUE
      PAUSE 'A too large, ITMAX too small'
1     GAMSER=SUM*DEXP(-X+A*DLOG(X)-GLN)
      RETURN
      END
C
C
C
      DOUBLE PRECISION FUNCTION GAMMLN(XX)
      IMPLICIT	REAL*8	(A-H,O-Z)
      REAL*8 COF(6),STP,HALF,ONE,FPF,X,TMP,SER
      DATA COF,STP/76.18009173D0,-86.50532033D0,24.01409822D0,
     *    -1.231739516D0,.120858003D-2,-.536382D-5,2.50662827465D0/
      DATA HALF,ONE,FPF/0.5D0,1.0D0,5.5D0/
      X=XX-ONE
      TMP=X+FPF
      TMP=(X+HALF)*DLOG(TMP)-TMP
      SER=ONE
      DO 11 J=1,6
        X=X+ONE
        SER=SER+COF(J)/X
11    CONTINUE
      GAMMLN=TMP+DLOG(STP*SER)
      RETURN
      END
C
