C +++
C
C Source: src/utils/post/tdconn.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	tdconn.F
C Revision 1.6  92/01/16  11:29:19  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:43:52  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:51:03  cwelnak
C changed quotes in #includes
C 
C Revision 1.3  91/03/25  15:56:45  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:48:08  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:51  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C++++
C
C	PROGRAM		TDCONN
C
C	PURPOSE		To generate a connected x-y plot.
C
C	INPUT		2-columns file
C
C	OUTPUT		A file suitable for TOPDRAWER
C
C----
     	PROGRAM		TDCONN
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
	INCLUDE		'SHADOW$INC:DIM.PAR/LIST'
#endif
	DIMENSION	X(N_DIM),Y(N_DIM)
     	CHARACTER*80	INFILE,OUTFILE,RSTRING
	INFILE	=   RSTRING ('TDCONN> Input file : ')
#ifdef vms
	OPEN	(20,FILE=INFILE,STATUS='OLD',READONLY)
#else
	OPEN	(20,FILE=INFILE,STATUS='OLD')
#endif
	DO 10 I = 1, N_DIM + 1
	  READ	(20,*,END=100)	X(I),Y(I)
10	CONTINUE
	STOP 'Input file contains too many data points (*N_DIM* max.)'
100	CLOSE	(20)
	NPOINT	= I - 1
	WRITE(6,*)'Read ',NPOINT,' from ',INFILE
101	WRITE(6,*)'TDCONN> Grid size [ Nx by Ny ].'
     	NGX	=   IRINT ('TDCONN> Nx : ')
     	NGY	=   IRINT ('TDCONN> Ny : ')
	IF ((NGX*NGY).NE.NPOINT) THEN
	  WRITE(6,*)'Nx * Ny is not equal to ',NPOINT
	  GO TO 101
	END IF
	XMAX	= -1D+20
	XMIN	=  1D+20
	YMAX	= -1D+20
	YMIN	=  1D+20
	DO 20 I = 1, NPOINT
	  XMAX	= MAX(X(I),XMAX)
	  XMIN	= MIN(X(I),XMIN)
	  YMAX	= MAX(Y(I),YMAX)
	  YMIN	= MIN(Y(I),YMIN)
20	CONTINUE
	WRITE(6,*)'Xmax = ',XMAX,' Xmin = ',XMIN
	WRITE(6,*)'Ymax = ',YMAX,' Ymin = ',YMIN
	WRITE(6,*)'TDCONN> Limits to use on the plot : '
	XMIN	= RNUMBER ('TDCONN> Xmin : ')
	XMAX	= RNUMBER ('TDCONN> Xmax : ')
	YMIN	= RNUMBER ('TDCONN> Ymin : ')
	YMAX	= RNUMBER ('TDCONN> Ymax : ')
	OUTFILE	=   RSTRING ('TDCONN> Output file : ')
#ifdef vms
	OPEN	(21,FILE=OUTFILE,STATUS='NEW')
#elif unix
	OPEN	(21,FILE=OUTFILE,STATUS='UNKNOWN')
	REWIND  (21)
#endif
C
C Write out the data points.
C
	WRITE	(21,*)	'LIMIT X ',XMIN,' ',XMAX
	WRITE	(21,*)	'LIMIT Y ',YMIN,' ',YMAX
	KX	= 0
	DO 30 I = 1, NPOINT
	  WRITE	(21,*)	X(I),Y(I)
	  KX	= KX + 1
     	  IF (KX.EQ.NGX) THEN
	    WRITE	(21,*)	'JOIN 1'
	    KX	= 0
     	  END IF
30	CONTINUE
	KY	= 0
	DO 40 I = 1, NGX
	  DO 35 K = 0, NGY-1
	    WRITE	(21,*)	X(K*NGX+I),Y(K*NGX+I)
35	  CONTINUE
	  WRITE	(21,*)	'JOIN 1'
40	CONTINUE
	END 
