	subroutine new_record1 (record_type,req_own1,req_own2)
	implicit integer (a-z)
c++
c	subroutine new_record1 (record_type,req_own1,req_own2)
c
c  Adds all the variables constituting a record to the list
c  of variables which are defined.  Initializes these variables
c  to their default values.  If record_type is blank all are added
c  regardless of record type.
c
c	record_type	- input/string*(l_rec)
c			  name of record (all caps)
c
c	req_own1	- input/integer
c			  value to use for owner 1 field if user
c			    defaults it in the data file
c
c	req_own2	- input/integer
c			  value to use for owner 2 field if user
c			    defaults it in the data file
c--
	character*(*) record_type
c
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "nldata.inc"
#	include "nl1data.inc"
#	include "acc.inc"
#	include "context.inc"
#	include "io.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
	include 'nl1data.inc'
	include 'acc.inc'
	include 'context.inc'
	include 'io.inc'
#endif
c
	character*(l_rec) rec
	character*(l_name) name
	character*(l_val) default_val
	character*(l_val) full_symbol
	character*1 datatype
c
c  table of valid datatypes
c
	character*1 valid_datatype (5)
	data valid_datatype /'A','E','I','R','Y'/
c
c  staging area for input
c
	character*80 data
c
c  assume file is positioned at right spot
c
	record=0
c
c  when adding a variable to the Namelist list start from the
c  last free spot found rather than from the beginning
c
	place_hold=0
c
c  next record
c
 100	record=record+1
	read (menu_unit,101,end=900) data
 101	format (a)
c
c  check for end sentinel ('=')
c
	if (data(1:1) .eq. ' ' .or. data(1:1) .eq. '*') goto 100
	if (data(1:1) .eq. '=') goto 900
c
c  convert input
c
	read (data,110,err=120) rec,name,datatype,default_val
 110	format (a3,5x,a16,a1,7x,a20)
	goto 130
c
c  conversion error
c
 120	write (message,121) record
 121	format ('NEW_RECORD: Error reading record ',i4,
     *		' of the DEFAULT value data file')
	call fatal 
c
c  check for end sentinel ($)
c  ignore if blanks
c  ignore if not of proper record type
c
 130	call upcase (rec)
	if (rec .ne. record_type .and. record_type .ne. ' ') goto 100
	call upcase (name)
	call upcase (datatype)
#ifdef vms
	call upcase (default_val)
#else
	if (datatype .ne. 'A') then
	   call upcase (default_val)
	endif
#endif
	   
c
c  check datatype
c	E => enumerate
c	I => integer
c	A => alphanumeric
c	R => real double precision
c	Y => Yes/No
c
	do idatatype=1,5
	  if (datatype .eq. valid_datatype(idatatype)) goto 150
	enddo
c
	write (message,149) record,datatype
 149	format ('NEW_RECORD: Record ',i4,' has an unrecognized ',
     *		'Datatype ("',a,'") - Use A,E,I,R, or Y')
	call fatal 
 150	continue
c
c  Verify default data value
c  Special case for synonym/enumeraed variables since it is a fatal
c    error if the namelist name is not in the synonym table
c    
	if (datatype .eq. 'E') then
	  call translate_synonym (name,default_val,code,full_symbol)
	  if (code .eq. -3) then
	    write (message,1005) name,record
 1005	    format ('NEW_RECORD: Synonym variable "',a,
     *		'" described in record ',
     *		i4,' is not in the synonym table')
	    goto 290
	  endif
	endif
c
c  Call conventional conversion routine
c
	call convert (name,datatype,default_val,code)

	if (code .eq. 0) goto 300
	goto (210,220,230,240,250) idatatype
c
c  alphanumeric error message
c
 210	write (message,1010) name,record,default_val
 1010   format ('NEW_RECORD: Variable "',a,'" described in record ',
     *		i4,' has default value "',a,'" but this contains ',
     *		'non-printing characters')
	goto 290
c
c  synonym error messages
c
 220	if (code .eq. -2) then
	  write (message,1015) name,record,default_val
 1015	  format ('NEW_RECORD: Variable "',a,'" described in record ',
     *		i4,' has default value "',a,'" but this is not in the ',
     *		'synonym table')
	else if (code .eq. -3) then
	  write (message,1020) name,record,default_val
 1020	  format ('NEW_RECORD: Variable "',a,'" described in record ',
     *		i4,' has default value "',a,'" - this is an ',
     *		'ambiguous entry in the synonym table')
	endif
	goto 290
c
c  integer error messages
c
 230	write (message,1025) name,record,default_val
 1025	format ('NEW_RECORD: Variable "',a,'" record ',
     *		i4,' has default value "',a,'" - not ',
     *		'an integer')
	goto 290
c
c  double precision error messages
c
 240	write (message,1030) name,record,default_val
 1030	format ('NEW_RECORD: Variable "',a,'" record ',
     *		i4,' has default value "',a,'" - not ',
     *		'a real number')
	goto 290
c
c  YES/NO/ON/OFF error messages
c
 250	write (message,1035) name,record,default_val
 1035	format ('NEW_RECORD: Variable "',a,'" described in record ',
     *		i4,' has default value "',a,'" - the value must ',
     *		'be one of YES, NO, ON, or OFF')
	goto 290
c
c  print error message for default values
c
 290	call fatal 
c
c  Default value is okay
c  Add record to Namelist data list
c  First check those that have been used
c
 300	place_hold=place_hold+1
	do i=place_hold,n_nl1data
	  if (nl1_name(i) .eq. ' ') goto 310
	end do
c
c  Then those that haven't been used
c
	i=n_nl1data+1
	if (i .le. max_nl1data) goto 310
c
	write (message,305) max_nl1data
 305	format ('NEW_RECORD: Namelist pool is full - ',
     *		'Can''t handle more than ',i4,' variables')
	call fatal 
c
c  found an empty spot
c
 310	place_hold=i
c
c  now pack the data away
c
	nl_string=acc_string
	nl_real=acc_real
	nl_int=acc_int
	nl_name=name
	nl_rec=rec
	nl_own1=req_own1
	nl_own2=req_own2
	nl_datatype=datatype
c
	call nl_pack (i)
	n_nl1data=max (place_hold,n_nl1data)
	goto 100
c
 900	continue
c
c  Special cases are OE_NUMBER and SCR_NUMBER
c    these should be set equal to req_own1 and req_own2 respectively
c
	if (record_type .eq. 'OE') then
	   cur_oe=req_own1
	   call store_i ('OE','OE_NUMBER',req_own1,req_own2,req_own1)
	endif
	if (record_type .eq. 'SCR') then
	   cur_scr=req_own2
	   call store_i ('SCR','SCR_NUMBER',req_own1,req_own2,req_own2)
	endif
	return
	end
