/*
 * libcxrl.h - declarations for all the functions in libcxrl.a
 * 
 * Contents :
 * C - routines:
 *      1. int fix_fort_str (char *str, char *fort_str, int len);
 *      2. char *trim_leading_white (char *);
 *      3. char *trim_trailing_white (char *);
 *      4. char *lo_case (char *);
 *      5. char *xmalloc (unsigned);
 *      6. int error (char *);
 *
 * FORTRAN - routines:
 *      1. integer function iargc ()
 *      2. subroutine getarg (integer, character*(*))
 *      3. g-routines.
 *    
 * $Author: khan $ (Mumit Khan)
 *
 * $RCSfile: libcxrl.h,v $ 
 *
 * $Source: /home/cvsroot/shadow/src/tools/io/libcxrl.h,v $
 *
 * $Revision: 1.2 $
 *
 * $Log: libcxrl.h,v $
 * Revision 1.2  1997/06/29 06:36:28  khan
 * Added getopt. Prototyped libcxrl.h
 *
 * Revision 1.1.1.1  1996/01/02  17:07:14  khan
 * Toolset 2.0 release
 *
 * Revision 1.4  90/08/30  18:03:07  khan
 * About to add my own hashing routines.
 * 
 * Revision 1.3  90/05/01  14:32:12  khan
 * routine
 * 
 * Revision 1.2  90/04/12  20:48:34  khan
 * Cleanup
 * 
 * Revision 1.1  90/01/09  18:38:56  khan
 * Initial revision
 * 
 * Revision 1.1  89/10/24  17:19:12  khan
 * Initial revision
 * 
 */

#ifndef _LIBCXRL_H_
#define _LIBCXRL_H_

/* 
 * The definitions used by the g-set routine.
 */

#define CASE (1 << 0)
#define NOCASE (1 << 1)
#define DEBUG (1 << 2)
#define NODEBUG (1 << 3)
#define ABORT (1 << 4)
#define NOABORT (1 << 5)
#define HASH (1 << 6)
#define NOHASH (1 << 7)
#define XWINDOW (1 << 8)
#define NOXWINDOW (1 << 9)
#define DEFAULT (NOABORT | NOHASH | CASE | NODEBUG | NOXWINDOW)

#ifdef __cplusplus
extern "C" {
#endif

/* 
 * The g-routines themselves.
 */

#if defined(__STDC__) || defined(__cplusplus) || defined(USE_PROTOTYPES)
int g_set (unsigned int code);
int g_peek (char *query);
int g_debug ();
int g_print ();
int g_case ();
int g_nocase ();
int g_file (char *gfilename);
int g_close ();
int g_cleanup ();
int g_int(char *query, char *uprompt, int *result);
double g_number (char *query, char* uprompt, double *result);
char *g_string (char *query, char* uprompt, char *result);

int s_set ();
int s_peek ();
int s_debug ();
int s_print ();
int s_case ();
int s_nocase ();
int s_file ();
int s_close ();
int s_cleanup ();
int s_int ();
int s_number ();
int s_string ();

#else

int g_set ();
int g_peek ();
int g_debug ();
int g_print ();
int g_case ();
int g_nocase ();
int g_file ();
int g_close ();
int g_cleanup ();
int g_int ();
double g_number ();
char *g_string ();

int s_set ();
int s_peek ();
int s_debug ();
int s_print ();
int s_case ();
int s_nocase ();
int s_file ();
int s_close ();
int s_cleanup ();
int s_int ();
int s_number ();
int s_string ();

#endif

/*
 * Misc. utility routines used by the library routines themselves.
 */
int fix_fort_str ();
char *fort_str ();
char *pad_fort_str ();
char *trim_leading_white ();
char *trim_trailing_white ();
char *lo_case ();
char *xmalloc ();
void xfree ();
int error ();

#ifdef __cplusplus
}
#endif


#endif /* _LIBCXRL_H_ */
