C +++
C
C Source: src/lib/rwname.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: rwname.F
C Revision 1.8  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.7  91/04/05  13:54:39  cwelnak
C changed quotes on #include
C 
C Revision 1.6  91/03/22  12:05:37  cwelnak
C SUN version -- split TOTOE ==> TOTOE1, TOTOE2
C INCLUDE to #inlcude
C 
C Revision 1.5  90/11/13  14:05:07  khan
C Cleanup and SAVE statements
C 
C Revision 1.4  90/07/20  22:05:25  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.3  90/07/15  15:31:10  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.2  90/07/12  17:22:46  khan
C Deleted duplicate version of DESPACE (also in DESPACE.F).
C 
C Revision 1.1  90/07/10  14:56:54  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

#ifndef SHADOW_START_FORMAT
# define SHADOW_START_FORMAT 'GFILE'
#endif

C+++
C	SUBROUTINE	RWNAME ( File, Flag )
C
C	PURPOSE		To read or write the optical element parameters
C			to the disk.
C
C	ALGORITHM	None.
C
C	ARGUMENTS	NAME   file-name
C
C			WHAT   on input, 'R_SOUR' read source
C			                 'W_SOUR' write source
C					 'R_OE'   read oe
C					 'W_OE'   write oe
C
C			IFLAG  on input   0 = do not LEAVE on error
C					  else = do LEAVE on error
C
C			IFLAG  on output, 0 = successful completion
C				         -1 = namelist error
C				      	 -2 = file-not-found
C					 -3 = error in flag
C---
     	SUBROUTINE	RWNAME	( NAME, WHAT, IFLAG)
     	CHARACTER *(*)	NAME, WHAT
C
C
C On VMS we force the FORTRAN namelist I/O, but others are different.
C
#if defined(vms)
	CALL RWNAME_F77(NAME, WHAT, IFLAG)
	RETURN
	END
#else
	CHARACTER *80	FFORMAT
	LOGICAL LINITED, LGFORMAT
	SAVE LINITED, LGFORMAT
	DATA LINITED /.FALSE./
c
c default is FORTRAN NAMELIST.
c
	IF (.NOT.LINITED) THEN
	  CALL GETENV('SHADOW_START_FORMAT', FFORMAT)
	  IF (FFORMAT(1:1) .EQ. ' ') THEN
	    FFORMAT = SHADOW_START_FORMAT
	  ELSE IF (FFORMAT(1:1).EQ.'F'.OR.FFORMAT(1:1).EQ.'f') THEN
	    FFORMAT = 'FORTRAN'
	  ELSE IF (FFORMAT(1:1).EQ.'G'.OR.FFORMAT(1:1).EQ.'g') THEN
	    FFORMAT = 'GFILE'
	  ELSE
	    FFORMAT = 'GFILE'
	  ENDIF
	  IF (FFORMAT(1:1).EQ.'G') THEN
	    LGFORMAT = .TRUE.
	  ELSE
	    LGFORMAT = .FALSE.
	  ENDIF
	  LINITED = .TRUE.
	ENDIF
	IF (LGFORMAT) THEN
	  CALL RWNAME_G(NAME, WHAT, IFLAG)
	ELSE
	  CALL RWNAME_F77(NAME, WHAT, IFLAG)
	ENDIF
	RETURN
	END
#endif

#if !defined(vms)
C+++
C	SUBROUTINE	RWNAME_G ( File, Flag )
C
C	PURPOSE		To read or write the optical element parameters
C			to the disk.
C
C	ALGORITHM	None.
C
C	ARGUMENTS	NAME   file-name
C
C			WHAT   on input, 'R_SOUR' read source
C			                 'W_SOUR' write source
C					 'R_OE'   read oe
C					 'W_OE'   write oe
C
C			IFLAG  on input   0 = do not LEAVE on error
C					  else = do LEAVE on error
C
C			IFLAG  on output, 0 = successful completion
C				         -1 = namelist error
C				      	 -2 = file-not-found
C					 -3 = error in flag
C---
     	SUBROUTINE	RWNAME_G	( NAME, WHAT, IFLAG)
C
     	CHARACTER *(*)	NAME, WHAT
     	LOGICAL		TEST
     	TEST	=   (WHAT(1:1).EQ.'R').OR.(WHAT(1:1).EQ.'W')
     	IF (.NOT.TEST) GO TO 20
CCCCC
c
c Performs I/O
c
     	IF (WHAT(1:6).EQ.'W_SOUR') THEN
	  CALL gfsave_source (NAME, IFLAG)
     	ELSE IF (WHAT(1:6).EQ.'R_SOUR') THEN
	  CALL gfload_source (NAME, IFLAG)
     	ELSE IF (WHAT(1:4).EQ.'W_OE') THEN
	  CALL gfsave_oe (NAME, IFLAG)
     	ELSE IF (WHAT(1:4).EQ.'R_OE') THEN
	  CALL gfload_oe (NAME, IFLAG)
     	END IF
c
c
c
	RETURN
20     	CALL LEAVE ( 'RWNAME', 'Undefined action. Check code.',IFLAG)
	END
#endif

C+++
C	SUBROUTINE	RWNAME_F77 ( File, Flag )
C
C	PURPOSE		To read or write the optical element parameters
C			to the disk.
C
C	ALGORITHM	None.
C
C	ARGUMENTS	NAME   file-name
C
C			WHAT   on input, 'R_SOUR' read source
C			                 'W_SOUR' write source
C					 'R_OE'   read oe
C					 'W_OE'   write oe
C
C			IFLAG  on input   0 = do not LEAVE on error
C					  else = do LEAVE on error
C
C			IFLAG  on output, 0 = successful completion
C				         -1 = namelist error
C				      	 -2 = file-not-found
C					 -3 = error in flag
C---
     	SUBROUTINE	RWNAME_F77	( NAME, WHAT, IFLAG)
C
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../include/common.blk'
c
c
#	include		<common.blk>
#	include		<namelist.blk>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:COMMON.BLK/LIST'
     	INCLUDE		'SHADOW$INC:NAMELIST.BLK/LIST'
#endif
C
     	CHARACTER *(*)	NAME, WHAT
     	CHARACTER *80	TMESS,LOCNAME,TNAME
     	LOGICAL		TEST,IRET
     	TEST	=   (WHAT(1:1).EQ.'R').OR.(WHAT(1:1).EQ.'W')
     	IOUNIT	=  25
     	IF (.NOT.TEST) GO TO 20
     	DO 11 I=1,80
     	  TNAME(I:I) = ' '
     	  LOCNAME(I:I) = ' '
11	CONTINUE
#if defined(vms)
C
C Tests for logical-name definitions in input file-name. For VMS version
C only. The unix version checks for ENVIRONMENT in the calling routine,
C and passes fully expanded name.
C
     	IF (NAME(1:10).EQ.'SYS$START:') THEN
C
C Found it; tests if it exists
C
 	 IRET = LIB$SYS_TRNLOG ('SYS$START',,TNAME,,,)
     	 DO 21 I=1,180
     	   TNAME = ' '
21     	 CONTINUE
     	 IF (.NOT. IRET) THEN
C
C Does not exist; warn user and get rid of SYS$START: prefix
C
     	   WRITE(6,*)' '
     	   WRITE(6,*)'Warning: logical name SYS$START is undefined'
     	   WRITE(6,*)'Try locally.'
     	   WRITE(6,*)' '
     	   I = 1
31     	   IF (NAME(10+I:10+I).NE.' ') THEN
     	    TNAME (I:I) = NAME (10+I:10+I)
     	    I=I+1
		   GOTO 31
     	   END IF
     	 ELSE
C
C Does exist; assume is ok
C
     	   LTEMP = LEN (NAME)
     	   TNAME(1:LTEMP) = NAME(1:LTEMP)
     	 END IF
     	ELSE
C
C Not in the file-name; proceed
C
     	  LTEMP = LEN (NAME)
     	  TNAME(1:LTEMP) = NAME(1:LTEMP)
     	END IF
#else
        LTEMP = LEN (NAME)
        TNAME(1:LTEMP) = NAME(1:LTEMP)
#endif
C
C Get rid of possible spaces
C
     	CALL	DESPACE	(TNAME, LOCNAME, KLEN)
C
CCCCC
c
c Opens files
c
#if defined(vms)
     	IF 	(WHAT(1:1).EQ.'R') THEN
     	  OPEN	(ioUnit, FILE=LOCNAME(1:KLEN), STATUS='OLD', READONLY,
     $		     IOSTAT=IERR, ERR=100)
     	ELSE IF (WHAT(1:1).EQ.'W') THEN
     	  OPEN	(ioUnit, FILE=LOCNAME(1:KLEN), STATUS='NEW', 
     $		     IOSTAT=IERR, ERR=200)
     	END IF
#else
     	IF 	(WHAT(1:1).EQ.'R') THEN
     	  OPEN	(ioUnit, FILE=LOCNAME(1:KLEN), STATUS='OLD', 
     $		     IOSTAT=IERR, ERR=100)
     	ELSE IF (WHAT(1:1).EQ.'W') THEN
     	  OPEN	(ioUnit, FILE=LOCNAME(1:KLEN), STATUS='UNKNOWN', 
     $		     IOSTAT=IERR, ERR=200)
	  REWIND (ioUnit)
     	END IF
#endif
c
c Performs I/O
c
     	IF (WHAT(1:6).EQ.'W_SOUR') THEN
     	  WRITE (ioUnit, NML=TSOUR, IOSTAT=IERR, ERR=10)
     	ELSE IF (WHAT(1:6).EQ.'R_SOUR') THEN
     	  READ  (ioUnit, NML=TSOUR, IOSTAT=IERR, ERR=10)
     	ELSE IF (WHAT(1:4).EQ.'W_OE') THEN
     	  WRITE (ioUnit, NML=TOTOE1, IOSTAT=IERR, ERR=10)
     	  WRITE (ioUnit, NML=TOTOE2, IOSTAT=IERR, ERR=10)
     	ELSE IF (WHAT(1:4).EQ.'R_OE') THEN
     	  READ  (ioUnit, NML=TOTOE1, IOSTAT=IERR, ERR=10)
     	  READ  (ioUnit, NML=TOTOE2, IOSTAT=IERR, ERR=10)
     	END IF
c
c close files
c
     	CLOSE (ioUnit)
C
C Succesful completion
C
     	IFLAG = 0
     	RETURN
C
C Error messages
C
100	IF (IFLAG.EQ.0) THEN
     	  IFLAG = -1
     	  RETURN
     	ELSE
     	  CALL LEAVE('RWNAME: File not found ', LOCNAME(1:KLEN),IERR)
     	END IF
200	IF (IFLAG.EQ.0) THEN
     	  IFLAG = -1
     	  RETURN
     	ELSE
     	  CALL LEAVE('RWNAME: Could not open file. Check status.',
     $	LOCNAME(1:klen), IERR)
     	END IF

C
C IERR == -1 implies EOF is reached before the Namelist can be read
C completely. If this is good or bad I don't know, but ignoring it does 
C allow old SHADOW namelist files (with not as many namelist elements)
C to be read and used.
C
10	IF (IERR.EQ.-1) THEN
     	  IFLAG = 0
     	  RETURN
     	END IF
C
C Not successful
C
     	IF (IERR.EQ.17) THEN
     	   TMESS = 'RWNAME: Syntax error in Namelist input'
     	ELSE IF (IERR.EQ.18) THEN
     	   TMESS = 'RWNAME: Too many values for Namelist variable'
     	ELSE IF (IERR.EQ.19) THEN
     	   TMESS = 'RWNAME: Non-existent variable in Namelist list'
     	END IF
     	IF (IFLAG.EQ.0) THEN
     	  IFLAG = -1
     	  RETURN
     	ELSE
     	  CALL LEAVE ( TMESS, NAME, IERR)
     	END IF
20     	CALL LEAVE ( 'RWNAME', 'Undefined action. Check code.',IFLAG)
     	END
