C +++
C
C Source: src/tools/math/proof.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	proof.f
C Revision 1.1  90/07/17  13:55:05  khan
C Initial revision
C 
C 
C ---

C+++
C	PROGRAM		PROOF
C
C	PURPOSE		To manipulate files
C
C---
     	PROGRAM		PROOF
     	CHARACTER*80	INLINE
     	CHARACTER*20	FIL1,FIL2,FIL3
     	INTEGER		FLAG	(20)
     	LOGICAL		ANSW
C Meaning of flag
C
C	(#)	values	meaning		Field
C	 1	0	ERROR   	
C		 #	OK	        
C	 2      0       ERROR		Command ID
C		 # 	OK		
C	 3	0	ERROR		Numeric field
C		 #	OK
C	 4	0	ERROR		Symbol
C		 #	OK	
C	 5
C	 6
C	 7
C	 8
C	 9
C	10
C	11	0	No 		File 1
C		 1	Yes
C	12	0	N0		File 2
C		 1	Yes	
C	13	0	NO		File 3
C		 1 	Yes
C	14      0       NO              1st Operand (Array)
C               1-6     Yes
C	15      0       NO              2nd   "
C	16      0       NO              3rd   "
C	17
C	18
C	19
C	20
C
     	COMMON	/X	/X1(10000), X2(10000), X3(10000),X(10000)
     	COMMON	/Y	/Y1(10000), Y2(10000), Y3(10000),Y(10000)
C
C Meaning of control block variables:
C
C		      NOT ZERO		ZERO
C	(1)	       LUN		off		log-file
C        2	      array to use       1              data-arrays
C        3              x-data          y-data          
C
     	COMMON	/ONE	/IJK(20)

C
C Reads in command line
C
11	DO 10 I=1,20
     	  IJK(I) = 0
10    	CONTINUE
     	CALL	LIB$ERASEPAGE (1,1)
1	DO 20 I=1,20
     	  FLAG(I) = 0
20    	CONTINUE
	DO 30 I=1,80
     	  INLINE(I:I) = ' '
30    	CONTINUE
     	CALL	PROMPT	('CMD>',INLINE,LLINE,ISTAT)
     	IF (ISTAT.EQ.-1) THEN
     	  CALL	ERRMSG	(' Warning: EOF detected ',INLINE)
     	  IF (LLINE.EQ.0) GO TO 1
     	ELSE IF (ISTAT.EQ.-2) THEN
     	  CALL	ERRMSG	(' Unable to process input: ',INLINE)
     	  GO TO 1
     	END IF
     	CALL	COMMAND	(INLINE,LLINE,FIL1,FIL2,FIL3,FLAG)
     	IF (FLAG(1).EQ.0) THEN
     	  CALL ERRMSG ('Unrecognized input',' ')
     	  GO TO 1
     	ELSE IF (FLAG(1).EQ.-1) THEN
     	  GO TO 1
     	END IF
C 
C Tests to see if the operand is a file. If so, an error is printed
C unless the operation is allowed.
C
C
C The line has been processed. There are 3 possible choices:
C
C Algebraic operation:		A = B + C
C This is automatically performed ONLY as:
C				Y3 = Y2 + Y1
C-----------------------------------------------------------
C File command: file-names must be preceded by '@'
C	@myfile = $save
C --> writes X3,Y3 to file "myfile"
C For example to read a file in X1,Y1 we must:
C       @myfile = $open
C	@myfile = $assgn1
C-----------------------------------------------------------
C Commands: preceded by $. Eg:
C	$type
C will prompt CMD> Go? Y[es] will set the default values.
C Some commands will replace the file itself, unless the
C protection is ON.
C For example, the command
C	@myfile = $integral @myfile1
C will put in the FILE @myfile the integral of @myfile1,
C while the command
C       >Y1 = $integr >Y2
C will put in the array Y1 the integral of array y2.
C-----------------------------------------------------------
C
     	IF (FLAG(2).EQ.1) THEN
     	 ITEST = FLAG(11) + FLAG(12) + FLAG(13)
     	 IF (ITEST.NE.0) THEN
     	   CALL ERRMSG ('Cannot process file directly',' ')
     	   GO TO 1
     	 END IF
     	  CALL	IYES	('INTEGRAL: Go? [ Y/N ] ',ANSW)
     	 IF (.NOT.ANSW) GO TO 1
     	 IF (FLAG(15).LT.4) THEN
     	   CALL ERRMSG ('Wrong type of operands',' ')
     	   GO TO 1
     	 END IF
     	 IF (FLAG(15).EQ.4) THEN
     	   CALL  INTEGRAL ( X1, Y1, Y, NN)
     	 ELSE IF (FLAG(15).EQ.5) THEN
     	   CALL  INTEGRAL ( X2, Y2, Y, NN)
     	 ELSE IF (FLAG(15).EQ.6) THEN
     	   CALL  INTEGRAL ( X3, Y3, Y, NN)
     	 END IF
     	 IF (FLAG(14).EQ.4) THEN
     	   CALL  EQUAL	( Y1, Y)
     	 ELSE IF (FLAG(14).EQ.5) THEN
     	   CALL  EQUAL ( Y2, Y)
     	 ELSE IF (FLAG(14).EQ.6) THEN
     	   CALL  EQUAL ( Y3, Y)
     	 END IF
     	GO TO 1
C
C Open-read
C
     	ELSE IF (FLAG(2).EQ.21) THEN
     	 IF (FLAG(11).NE.0) THEN
     	   OPEN (21, FILE=FIL1, STATUS='OLD', READONLY)
     	  IF (IOSTAT.NE.0) THEN
     	    CALL ERRMSG ('File not found: ',FIL1)
     	    GO TO 1
     	  END IF
     	 ELSE IF (FLAG(12).NE.0) THEN
     	   OPEN (22, FILE=FIL2, STATUS='OLD', READONLY)
     	  IF (IOSTAT.NE.0) THEN
     	    CALL ERRMSG ('File not found: ',FIL2)
     	    GO TO 1
     	  END IF
     	 ELSE IF (FLAG(13).NE.0) THEN
     	   OPEN (23, FILE=FIL3, STATUS='OLD', READONLY)
     	  IF (IOSTAT.NE.0) THEN
     	    CALL ERRMSG ('File not found: ',FIL3)
     	    GO TO 1
     	  END IF
     	 END IF
     	  GO TO 1
     	ELSE IF (FLAG(2).EQ.28) THEN
     	  DO 40 I=1,10000
     	   READ (23, *,ERR=111) X(I),Y(I)
40    	  CONTINUE
111	  NN1 = I - 1
     	 IF (FLAG(14).EQ.7) THEN
     	   CALL	EQUAL (X1,X,NN1)
     	   CALL EQUAL (Y1,Y,NN1)
     	 ELSE IF (FLAG(14).EQ.8) THEN
     	   CALL EQUAL (X2,X,NN1)
     	   CALL EQUAL (Y2,Y,NN1)
     	   NN2 = NN1
     	 ELSE
     	   CALL EQUAL (X3,X,NN1)
     	   CALL EQUAL (Y3,Y,NN1)
     	   NN3 = NN1
  	 END IF
     	CONTINUE
     	ELSE IF (FLAG(2).EQ.16) THEN
     	   WRITE(6,*)'Type command'
     	   WRITE(6,*)'T1 :',X1(1),Y1(1)
     	CONTINUE
     	ELSE IF (FLAG(2).EQ.5) THEN
     	CONTINUE
     	ELSE IF (FLAG(2).EQ.6) THEN
     	CONTINUE
     	ELSE IF (FLAG(2).EQ.7) THEN
     	CONTINUE
     	ELSE IF (FLAG(2).EQ.8) THEN
     	CONTINUE
     	ELSE IF (FLAG(2).EQ.9) THEN
     	CONTINUE
     	ELSE IF (FLAG(2).EQ.10) THEN
     	IJK(1) = 1
     	ELSE IF (FLAG(2).EQ.11) THEN
     	IJK(1) = 0
     	END IF
     	GO TO 1
     	END

C+++
C	SUBROUTINE 	COMMAND
C
C	PURPOSE		To decode a line of input
C
C---
     	SUBROUTINE	COMMAND (INLINE, LLINE, FIL1, FIL2, FIL3, FLAG)
 	IMPLICIT	INTEGER*4	(A-Z)
     	CHARACTER	*80	INLINE
     	CHARACTER	*20	FIL1, FIL2, FIL3
     	REAL*4		VALUE
     	DIMENSION	ICHAR	(80), VALID(2,80), FLAG(10)
C
C Resets l flags
C
     	DO 5 I=1,10
     	  FLAG(I) = 0
5    	CONTINUE
C
C Finds all blanks positions
C
     	WORD	=   0
     	NWORD	=   0
     	DO 20 I=1,LLINE
C
C An exclamation mark indicates the beginning of comment
C
     	 IF (INLINE(I:I).EQ.'!') GO TO 10
     	 IF (INLINE(I:I).NE.' ') THEN
     	  IF (WORD.EQ.0) THEN
     	    NWORD = NWORD + 1
     	    WORD = 1
     	    VALID(1,NWORD) = I
     	  END IF
     	 ELSE
     	  IF (WORD.EQ.1) THEN
     	    WORD = 0
     	    VALID(2,NWORD) = I - 1
     	  END IF
     	 END IF
20    	CONTINUE
10	CONTINUE
     	IF (I.EQ.1) THEN
C
C Comment line only
C
     	  FLAG(1) = -1
     	  RETURN
     	END IF
C
C The number and location of words is now known 
C Starts the identification process
C
C If too many words truncation occurs
C
     	IF (NWORD.GT.5) NWORD = 5
     	NFIL	= 0
     	NARR	= 1
     	DO 30 I =1,NWORD
     	  LOW	=  VALID (1,I)
     	  UPP	=  VALID (2,I)
     	 IF (LOW.NE.UPP) THEN
     	  IF (INLINE(LOW:LOW).EQ.'$') THEN
     	    CALL IDCOMM (INLINE(LOW+1:UPP), FLAG(2))
     	   IF (FLAG(2).EQ.0) THEN
     	     CALL ERRMSG (INLINE(LOW+1:UPP),'Command not defined')
     	     FLAG(1) = 0
     	     RETURN
     	   END IF
     	  ELSE IF (INLINE(LOW:LOW).EQ.'%') THEN
     	    CALL IDNUM	(INLINE(LOW+1:UPP), VALUE, FLAG(3))
     	   IF (FLAG(3).EQ.0) THEN
     	     CALL ERRMSG (INLINE(LOW+1:UPP),
     $			   'Error reading numeric field')
     	     FLAG(1) = 0
     	     RETURN
     	   END IF
     	  ELSE IF (INLINE(LOW:LOW).EQ.'@') THEN
     	    NFIL = NFIL + 1
     	    FLAG (10+NFIL) = 1
     	   IF (NFIL.EQ.1) FIL1 = INLINE(LOW+1:UPP)
     	   IF (NFIL.EQ.2) FIL2 = INLINE(LOW+1:UPP)
     	   IF (NFIL.EQ.3) FIL3 = INLINE(LOW+1:UPP)
4     	  ELSE	IF (INLINE(LOW:LOW).EQ.'>') THEN
     	    NARR = NARR + 1
     	    CALL IDARRAY(INLINE(LOW+1:UPP),FLAG(NARR+13))
     	  END IF
     	 ELSE
     	   CALL	IDSYMBOL (INLINE(LOW:UPP), FLAG(4))
     	  IF (FLAG(4).EQ.0) THEN
     	    CALL ERRMSG (INLINE(LOW:UPP),' Symbol non recognized')
     	    FLAG(1) = 0
     	    RETURN
     	  END IF
     	 END IF
30    	CONTINUE
C
C Succesful completion
C
     	FLAG(1) = 1
     	RETURN
C
C Errors
C
999	DO 40 I=1,10
     	  FLAG(I) = 0
40    	CONTINUE
     	RETURN
     	END
C+++
C	SUBROUTINE	IDARRAY
C
C	PURPOSE		Identify the operands
C
C---
     	SUBROUTINE IDARRAY( STR, IFLAG)
     	CHARACTER*(*)	STR
     	CHARACTER*2	DAT(9)
     	DATA	DAT(1)	/'X1'/
     	DATA	DAT(2)	/'X2'/
     	DATA	DAT(3)	/'X3'/
     	DATA	DAT(4)	/'Y1'/
     	DATA	DAT(5)	/'Y2'/
     	DATA	DAT(6)	/'Y3'/
     	DATA	DAT(7)	/'T1'/
     	DATA	DAT(8)	/'T2'/
     	DATA	DAT(9)	/'T3'/
     	DO 10 I=1,9
     	 IF (STR(1:3).EQ.DAT(I)) THEN
     	   IFLAG = I
     	   RETURN
     	 END IF
10    	CONTINUE
     	IFLAG	= 0
     	RETURN
     	END
C+++
C	SUBROUTINE	IDCOMM
C
C	PURPOSE		Decode the command string
C
C---
     	SUBROUTINE	IDCOMM	( STRING, FLAG)
     	IMPLICIT	INTEGER*4	(A-Z)
     	CHARACTER *20	KNOWN	(50)
     	CHARACTER *(*)	STRING
     	DATA	KNOWN	(1)	/'INTEGRAL'/
     	DATA	KNOWN	(2)	/'DERIVATIVE'/
     	DATA	KNOWN	(3)	/'SMOOTH'/
     	DATA	KNOWN	(4)	/'INVERT'/
     	DATA	KNOWN	(5)	/'SUM '/
     	DATA	KNOWN	(6)	/'PLOT'/
     	DATA	KNOWN	(7)	/'EXCHANGE'/
     	DATA	KNOWN	(8)	/'REVERSE'/
     	DATA	KNOWN	(9)	/'SAVE'/
     	DATA	KNOWN	(10)	/'LOG  '/
     	DATA	KNOWN	(11)	/'NOLOG'/
     	DATA	KNOWN	(15)	/'PRINT'/
     	DATA	KNOWN	(16)	/'TYPE'/
     	DATA	KNOWN	(17)	/'LIST'/
     	DATA	KNOWN	(18)	/'NORMALIZE'/
     	DATA	KNOWN	(19)	/'SQRT'/
     	DATA	KNOWN	(20)	/'CLIP'/
     	DATA	KNOWN	(21)	/'OPEN'/
     	DATA	KNOWN	(22)	/'CLOSE'/
     	DATA	KNOWN	(23)	/'READ'/
     	DATA	KNOWN	(24)	/'PROTECT'/
     	DATA	KNOWN	(25)	/'RESTORE'/
     	DATA	KNOWN	(26)	/'UNPROTECT'/
     	DATA	KNOWN	(27)	/'SHOW'/
     	DATA	KNOWN	(28)	/'FROM'/
     	DO 10 I=1,28
     	 IF (STRING(1:5).EQ.KNOWN(I)(1:5)) THEN
     	   FLAG	=  I
     	   RETURN
     	 END IF
10    	CONTINUE
C
C Command not recognized
C
     	FLAG = 0
     	RETURN
     	END

C+++
C	SUBROUTINE	IDSYMBOL
C
C	Identifies an algebraic comamnd
C
C---
     	SUBROUTINE	IDSYMBOL ( IN, IOUT)
     	CHARACTER	*1	IN, SYMB(10)
     	DATA	SYMB(1)	/'+'/
     	DATA	SYMB(2)	/'-'/
     	DATA	SYMB(3)	/'*'/
     	DATA	SYMB(4)	/'/'/
     	DATA	SYMB(5) /'='/
     	DATA	SYMB(6) /'>'/
     	DO 10 I=1,6
     	 IF (IN.EQ.SYMB(I)) THEN
     	   IOUT = I
     	   RETURN
     	 END IF
C
C Symbol non identified
C
     	  IOUT = 0
10      CONTINUE
     	RETURN
     	END

C+++
C	SUBROUTINE	IDNUM
C
C	PURPOSE		To convert from ASCII string to REAL*4
C
C---
     	SUBROUTINE	IDNUM	( STRING, VAL, IOUT)
     	CHARACTER *(*)	STRING
     	READ (STRING,1000,ERR=100)	VAL
1000	FORMAT (BN,F29.0)
     	IOUT	= 1
     	RETURN
100	IOUT	= 0
     	RETURN
     	END

C+++
C	SUBROUTINE	ERRMSG
C
C	PURPOSE		Outputs an error message
C
C---
     	SUBROUTINE	ERRMSG	( STR1, STR2 )
     	CHARACTER *(*)	STR1,STR2
     	COMMON	/ONE/	IJK (20)
     	WRITE (6,1000)  STR2,STR1
     	IF (IJK(1).NE.0)	WRITE	(IJK(1),1000) STR2,STR1
1000	FORMAT	(1X,'** ERROR ** ',A,1X,A)
     	RETURN
     	END

C+++
C	SUBROUTINE	PROMPT
C
C	PURPOSE		Output a prompt and reads in answer
C
C---
     	SUBROUTINE	PROMPT	(STR1, STR2, LLIN, ISTAT)
     	CHARACTER *(*)	STR1,STR2
     	COMMON	/ONE	/IJK (20)
     	ISTAT	=  1
     	WRITE (6,1000)	STR1
1000	FORMAT	(1X,A,$)
     	READ	(5,1001,END=10,ERR=20)	LLIN,STR2
1001	FORMAT	(Q,A)
     	GO TO 100
10	ISTAT	= -1
     	GO TO 100
20	ISTAT	= -2
100	IF (IJK(1).NE.0) THEN
     	  WRITE (IJK(1),1002) STR1,STR2
1002	FORMAT	(1X,A,' ',A)
     	END IF
     	RETURN
     	END

C+++
C	SUBROUTINE	INTEGRAL
C
C	PURPOSE		Computes integral of array
C
C---
     	SUBROUTINE	INTEGRAL  ( X, Y1, Y, NN )
     	DIMENSION	X(NN),Y(NN),Y1(NN)
     	Y(1) = Y1(1)
     	DO 10 I=2,NN
     	  Y(I) = Y1(I-1) + (Y1(I)+Y1(I-1))/2*(X(I)-X(I-1))
10    	CONTINUE
     	RETURN
     	END
C+++
C	SUBROUTINE	IYES
C
C	PURPOSE		Analyzes an answer for Yes/No
C			Note: any word beginning with Y is accepted
C---
     	SUBROUTINE	IYES	( STR, OUT)
     	COMMON	/ONE	/IJK(20)
     	LOGICAL		OUT
     	CHARACTER*(*)	STR
     	CHARACTER*20	INP
     	OUT	= .FALSE.
     	WRITE (6,1000)	STR
1000	FORMAT	(1X,A,$)
     	READ	(5,1001,ERR=10,END=10)	INP
     	IF (INP(1:1).EQ.'Y'.OR.INP(1:1).EQ.'y') OUT = .TRUE.
     	GO TO 20
10     	OUT = .FALSE.
20     	IF (IJK(1).NE.0) THEN
     	  WRITE(IJK(1),1001) STR,INP
1001	FORMAT	(1X,A,' ',A)
     	END IF
     	RETURN
     	END

C+++
C	SUBROUTINE	EQUAL
C	
C	PURPOSE		Equates two arrays
C
C---
     	SUBROUTINE	EQUAL	(A1, A2, NN)
     	DIMENSION	A1 (NN), A2 (NN)
     	DO 10 I=1,NN
     	  A1(I) = A2(I)
10    	CONTINUE
     	RETURN
     	END
