C +++
C
C Source: src/tools/math/fsincos.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	fsincos.f
C Revision 1.1  90/07/17  13:54:53  khan
C Initial revision
C 
C 
C ---

C+++
C	subroutine	fsincos (x, fsin, fcos, ier)
C
C	purpose		returns the fresnel integral sine and cosine
C			functions using IMSL routine MERRCZ
C
C	arguments (input) x:  value of variable (unbounded)
C
C    		  (output):
C			  fsin: integral sine
C			  fcos:          cosine
C			  ier:  error flag, 0 on success
C					    1 fatal error
C
C	precision	double (real*16)
C
C---
	SUBROUTINE FSINCOS(X,FSIN,FCOS,IER)
C
	IMPLICIT REAL*8 (A-H,O-Z)
	DIMENSION Z(2),W(2)
	COMPLEX*16 CW,CY,CANS
	PI = 3.141592653 D0
	IF (X .GT. 0.0D0) THEN
	  IFLAG = 0
	ELSE 
	  IFLAG = 1
	  X = -X
	END IF
	Z(1) = X*DSQRT(PI)/2.0D0
	Z(2) = Z(1)
	CALL MERRCZ(Z,W,IER)
	IF (IER .NE. 0) GOTO 999
	CW = (1,0)*W(1) + (0,1)*W(2)
	CY = (0,1)*PI*X*X/2.0D0
	CANS = (0.5D0,0.5D0)*((1,0) - CW*CDEXP(CY))
	FCOS = DREAL(CANS)
	FSIN = DIMAG(CANS)
	IF (IFLAG .EQ. 1) THEN
	  FCOS = -FCOS
	  FSIN = -FSIN
	  X = -X
	END IF
 999	RETURN
	END 
