C +++
C
C Source: src/tools/math/bpol.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	bpol.f
C Revision 1.1  90/07/17  13:54:45  khan
C Initial revision
C 
C 
C ---

C+++
C	FUNCTION	BPOL (X,J)
C
C	Purpose		Computes the shifted Legendre polinomials of 
C			degree J at point X
C
C	Algorithm	Direct definition of the shifted Legendre
C			polinomials.
C
C	Limits		Argument domain must be within [ 0,1 ]
C
C---
     	FUNCTION	BPOL1 (II,J,NN)
     	DIMENSION	XTEMP (20)
     	IF (X.GT.1.0.OR.X.LT.0.0)	WRITE(6,*)'Invalid argument ',X,J
     	XNN	=   FLOAT (NN)

	XTEMP(1)	=   1	
C    	ZERO DEGREE

	XTEMP(2)	=   1 - 2*II/XNN
	XTEMP(3)	=   1 - 6*II/XNN + 6*II/XNN*(II-1)/(XNN-1.0)
	XTEMP(4)	=   1 - 12*II/XNN + 30*II/XNN*(II-1)/(XNN-1.0)
     $	 - 20*II/XNN*(II-1)/(XNN-1.0)*(II-2)/(XNN-2)
	XTEMP(5)	=   1 - 20*II/XNN + 90*II/XNN*(II-1)/(XNN-1.0) 
     $	- 140*II/XNN*(II-1)/(XNN-1.0)*(II-2)/(XNN-2) 
     $  + 70*II/XNN*(II-1)/(XNN-1.0)*(II-2)/(XNN-2)*(II-3)/(XNN-3)
     	IF (J.LT.5) THEN
     	  BPOL	= XTEMP(J+1)
     	  RETURN
     	END IF
c
c uses recurrence formulae for terms greater than 4
c
     	DO 10 I=6,J+1
     	 XTEMP(I) = (XTEMP(I-1)*(2*I-1-(4*I-2)*X)
     $			 - XTEMP(I-2)*(I-1))/I
10      CONTINUE
     	BPOL = XTEMP(J+1)
     	RETURN
     	END
