//
// misc.cc: misc helper classes
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#include <iostream>
#include <unistd.h>

#include "misc.h"
#include "utils.h"

using namespace std;

/************************************************************************/

class CleanupItem {
public:
    CleanupItem(int iteration);
    ~CleanupItem();

    Hashtable* getnametable()			{ return names_; }
    int getiteration()				{ return iteration_; }

private:
    Hashtable* names_;
    int iteration_;
};

CleanupItem::CleanupItem(int iteration) {
    iteration_ = iteration;
    names_ = new Hashtable(17);
}

CleanupItem::~CleanupItem() {
    iteration_ = -1;
    delete names_;
}

/************************************************************************/

CleanupMgr::CleanupMgr () { 
    unlinktablist_ = new Stq;		// LIST of CleanupItem's.
}

CleanupMgr::~CleanupMgr() {
    for (int i = 1; i <= unlinktablist_->size(); i++) {
	CleanupItem* citem = (CleanupItem*)unlinktablist_->pop();
	delete citem;
    }
    delete unlinktablist_;
}

// ADD COPY OF path TO unlink TABLE (IF ITS NOT ALREADY THERE)
void CleanupMgr::addunlink (const char* path, int iteration) {
    Hashtable* names = 0;
    if ((names = find_unlinktable(iteration)) == 0) {
	CleanupItem* citem = new CleanupItem(iteration);
	unlinktablist_->enq(citem);
	names = citem->getnametable();
    }
    if (!names->find (path)) {
	const char* val = strcpy_with_alloc (path);
	names->insert (val, val);
    }
}

// PERFORM CLEANUP OPERATIONS
void CleanupMgr::cleanup (int iteration) {
    Hashtable* names = find_unlinktable(iteration);
    if (names != 0) {			// maybe nothing was added to cleanup.
	for (int i=1;i<=names->size();i++) {
	    const char* path = (const char*)names->get (i);
	    unlink (path);
	}
    }
}

Hashtable* CleanupMgr::find_unlinktable(int iteration) {
    Hashtable* names = 0;
    int size = unlinktablist_->size();
    for (int i = 1; i <= size; i++) {
	CleanupItem* citem = (CleanupItem*)unlinktablist_->cycle();
	if (citem->getiteration() == iteration)
	    names = citem->getnametable();
    }
    return names;
}
	
/************************************************************************/

Stats::Stats () {
   nprograms_ = ninputfiles_ = noutputfiles_ = 0;
}

void Stats::report () {
   cout 
       << ninputfiles_ << " files were edited for input, "
       << nprograms_ << " programs were run and "
       << noutputfiles_ << " files were searched for outputs." << endl; 
}

/************************************************************************/
