//
// link.h: dependency linker for input/output variables.
//
// ------------------------------------------------
// Mumit Khan <khan@xraylith.wisc.edu>
// Center for X-ray Lithography
// University of Wisconsin-Madison
// 3731 Schneider Dr., Stoughton, WI, 53589
// ------------------------------------------------
//
// Copyright (c) 1991-1996 Mumit Khan
//
//

#ifndef excon_batch_link_h
#define excon_batch_link_h

/*******************************************************************************
*
*  LINKS
*
*******************************************************************************/

// EX: inspectrum:sync  :$GETVAR outspectrum
class Link {
public:
    Link(
	const char* text, const char* tool, const char* var, 
	const char* actioncode, const char* actionval
    );
    ~Link();
    Link* clone() const;
    const char* getlinktext() const		{ return text_; }
    const char* getlinktool() const		{ return tool_; }
    const char* getlinkvar() const		{ return var_; }
    const char* getactioncode() const		{ return actioncode_; }
    const char* getactionval() const		{ return actionval_; }

private:
    char* text_;		// COMPLETE TEXT OF LINK
    char* tool_;      
    char* var_;
    char* actioncode_;
    char* actionval_;
};

class ResolvedLink {
public:
    ResolvedLink(const Link*, const char* toolinstance);
    ~ResolvedLink();
    ResolvedLink* clone() const;
    const Link* getlink() const			{ return link_;; }
    const char* gettoolinstance() const		{ return instance_; }
private:
    const Link* link_;
    char* instance_;
};

#endif/*excon_batch_link_h*/
