#ifndef _WIN32
# error run-primvs.c: This file should only be compiled for WIN32 platform.
#endif

#ifdef _MSC_VER
# define F77_NAME(name) __stdcall name
#else
# if !NO_FORT_UNDERSCORE
#  define F77_NAME(name) name ## _
# else
#  define F77_NAME(name) name
# endif
#endif

#ifdef _MSC_VER
# define RUNPRIMVS F77_NAME(RUNPRIMVS)
#else
# define RUNPRIMVS F77_NAME(runprimvs)
#endif

#include <process.h>
#include <errno.h>

/*
 * this is thanks to a bug in libc:system() in cygwin32 B16-18.1.
 */

#warning "CYGWIN32 bug-fix call-primvs routine. FIX"

void RUNPRIMVS (char* ftn_prog, char *ftn_script, int* iflag, 
    unsigned long prog_len, unsigned long script_len) {
    char prog[256];
    char script[256];
    int i;
    int retcode;

    /* fix fortran string */
    for(i = prog_len; ftn_prog[i-1] == ' '; --i)
	;
    strncpy(prog, ftn_prog, i);
    prog[i] = '\0';
    for (--i; i >= 0; --i) {
        if (prog[i] == '/')
	    prog[i] = '\\';
    }
    /* now dequote */
    if (strchr(prog, '\"')) {
	char tmpbuf[256];
	int j;
	int k = strlen(prog);
	for (i = 0, j = 0; i < k; i++) {
	    if (prog[i] == '\"')
	        continue;
	    tmpbuf[j++] = prog[i];
	}
	tmpbuf[j] = '\0';
	strcpy(prog, tmpbuf);
    }

    /* fix fortran string */
    for(i = script_len; ftn_script[i-1] == ' '; --i)
	;
    strncpy(script, ftn_script, i);
    script[i] = '\0';

    *iflag = 0;
    retcode = spawnl(_P_WAIT, prog, "primvs", "-x", "-i", script, 0);
    if (retcode == -1) {
        perror("Primvs execution error:");
    }
    *iflag = retcode;
}
