C +++
C
C Source: src/lib/irint.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: irint.F
C Revision 1.7  1991/07/06  19:56:48  khan
C Grenoble and after. Minor changes
C
C Revision 1.6  91/04/05  13:54:24  cwelnak
C changed quotes on #include
C 
C Revision 1.5  91/03/22  12:22:17  cwelnak
C SUN version -- INC to #inc
C 
C Revision 1.4  90/11/13  14:04:53  khan
C Cleanup and SAVE statements
C 
C Revision 1.3  90/07/20  22:05:09  khan
C put #if unix ... to make it work also on vms
C 
C Revision 1.2  90/07/15  15:31:02  khan
C All public include files (common.blk, etc) are now in ./../../include dir.
C 
C Revision 1.1  90/07/10  14:56:20  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	SUBROUTINE	RINT
C
C	Purpose		Error-proof read-in routine for an I*4 number
C
C
C---
     	INTEGER 	FUNCTION	IRINT	( PROMPT )
     	CHARACTER*(*)	PROMPT
C
C The error iteration limit is 10 right now.
C
	ICOUNT	= 0
10	WRITE 	(6, '(1X,A,2X,$)')	PROMPT
#ifdef MICROSOFT
     	READ	(5, *, IOSTAT=IRET)	IVAL
#else
     	READ	(5, '(I10.0)', IOSTAT=IRET)	IVAL
#endif
     	IF (IRET.NE.0) THEN
     	  WRITE (6,*)
     $	'What ? [ Program expects integer number input ]'
	  ICOUNT = ICOUNT + 1
	  IF (ICOUNT.GT.10) 
     $	CALL LEAVE ('IRINT : ','Exceed error iteration limit.',IRET)
     	  GO TO 10
     	ELSE
     	  IRINT = IVAL
     	  RETURN
     	END IF
     	END
