C +++
C
C Source: src/utils/post/slits.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	slits.F
C Revision 1.7  92/01/16  10:54:31  cwelnak
C 6000 changes
C 
C Revision 1.6  1991/07/06  19:43:52  khan
C Grenoble Changes ...
C
C Revision 1.5  91/04/05  15:50:56  cwelnak
C changed quotes in #includes
C 
C Revision 1.4  91/03/25  16:10:06  khan
C PROGRAM SLITS statement MUST be present before any INCLUDE statement.
C 
C Revision 1.3  91/03/25  15:56:34  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:47:57  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/08  17:03:49  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		SLITS
C
C	PURPOSE		To study the transmission and resolution for various
C			settings of the entrance and exit slit.
C
C	NOTE		The monochromator should be run thru SHADOW with the
C			2 slits completely opened.  All the other size limits
C			(mirror length etc.) should be defined.
C---
	PROGRAM		SLITS
	IMPLICIT	REAL*8	(A-H,O-Z)
#if defined(unix) || HAVE_F77_CPP
#       include	        <dim.par>
#elif defined(vms)
        INCLUDE	        'SHADOW$INC:DIM.PAR/LIST'
#endif
C	IMPLICIT	REAL*8	(A-H,O-Z)
	REAL*8		SLIT1(12,N_DIM),SLIT2(12,N_DIM)
	REAL*8		PHASE(3,N_DIM),AP(3,N_DIM)
	REAL*8		RELATE(4,N_DIM)
	REAL*8		TOCM,TWOPI
	REAL*4		SW1,SW2,RRMIN,RRMAX,RAVE,RDEL,AVEINTENS
	CHARACTER*80	FIN1,FIN2,FOUT,RSTRING
     	
     	DATA	TWOPI 	/  6.2831 85307 17958 64769 25287 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /

	FIN1	= RSTRING ('Entrance slit file : ')
	FIN2	= RSTRING ('Exit slit file     : ')
	WRITE(6,*)'Units : [ 0 ]  eV'
	WRITE(6,*)'        [ 1 ]  Angstroms'
	WRITE(6,*)'        [ 2 ]  cm-1'
	IUNIT	= IRINT ('Then ? ')
	CALL	RBEAM	(FIN1,SLIT1,PHASE,AP,NCOL,NPOINT,IFLAG,IERR)
	CALL	RBEAM	(FIN2,SLIT2,PHASE,AP,NCOL,NPOINT,IFLAG,IERR)
C
C Store the good rays into RELATE : abs(Z1), abs(Z2), hv, A**2.
C
	NGOOD	= 0
	TRANS	= 0
	DO 10 I = 1, NPOINT
	  IF (SLIT2(10,I).GT.0.0D0) THEN
	    NGOOD	= NGOOD + 1
	    RELATE(1,NGOOD)	= ABS(SLIT1(3,I))
	    RELATE(2,NGOOD)	= ABS(SLIT2(3,I))
	    IF (IUNIT.EQ.0) THEN
	      RELATE(3,NGOOD)	= SLIT2(11,I)*TOCM/TWOPI
	    ELSE IF (IUNIT.EQ.1) THEN
	      RELATE(3,NGOOD)	= TWOPI/SLIT2(11,I)*1.0D8
	    ELSE
	      RELATE(3,NGOOD)	= SLIT2(11,I)
	    END IF
 	 RELATE(4,NGOOD) = SLIT2(7,I)**2 + SLIT2(8,I)**2 + SLIT2(9,I)**2
 	    IF (NCOL.EQ.18) RELATE(4,NGOOD) = RELATE(4,NGOOD)
     $			+ AP(1,I)**2 + AP(2,I)**2 + AP(3,I)**2
	    TRANS	= TRANS + RELATE(4,NGOOD)
	  END IF
10	CONTINUE
	WRITE(6,*)'So far we are working with :'
	WRITE(6,*)'  Total number of rays          = ',NPOINT
	WRITE(6,*)'  Number of rays transmitted    = ',NGOOD
     	WRITE(6,*)'  Intensity of transmitted rays = ',TRANS
C
C Now vary the slit opening.
C
	S1MAX	= RNUMBER ('Maximum entrance slit width : ')
	S1MIN	= RNUMBER ('Minimum entrance slit width : ')
	NP1	= IRINT ('No. of points : ')
	IF (S1MAX.EQ.S1MIN.OR.NP1.LT.2) THEN
	  STEP1	= 0.0D0
	ELSE
	  STEP1	= (S1MAX-S1MIN)/(NP1-1)
	END IF
	S2MAX	= RNUMBER ('Maximum exit slit width : ')
	S2MIN	= RNUMBER ('Minimum exit slit width : ')
	NP2	= IRINT ('No. of points : ')
	IF (S2MAX.EQ.S2MIN.OR.NP2.LT.2) THEN
	  STEP2	= 0.0D0
	ELSE
	  STEP2	= (S2MAX-S2MIN)/(NP2-1)
	END IF
	FOUT	= RSTRING ('Output file : ')
#ifdef vms
	OPEN	(21, FILE=FOUT, STATUS='NEW')
#else
	OPEN	(21, FILE=FOUT, STATUS='UNKNOWN')
	REWIND  (21)
#endif
	DO 20 I = 1, NP1
	  S1	= S1MAX - STEP1*(I-1)
	  S1	= S1/2.0D0
	  DO 15 J = 1, NP2
	    S2	= S2MAX - STEP2*(J-1)
	    S2	= S2/2.0D0
	    NFINAL	= 0
	    RMAX	= 0.0D0
	    RMIN	= 1.0D20
	    RTOT	= 0.0D0
	    RTOT2	= 0.0D0
	    TRANS	= 0.0D0
	    DO 12 KK = 1, NGOOD
	      IF (RELATE(1,KK).LE.S1.AND.RELATE(2,KK).LE.S2) THEN
		NFINAL	= NFINAL + 1
	        RMAX	= MAX(RMAX,RELATE(3,KK))
	        RMIN	= MIN(RMIN,RELATE(3,KK))
	      	RTOT	= RTOT + RELATE(3,KK)*RELATE(4,KK)
		RTOT2	= RTOT2 + (RELATE(3,KK)**2)*RELATE(4,KK)
		TRANS	= TRANS + RELATE(4,KK)
	      END IF
12	    CONTINUE
	    SW1		= S1*2
	    SW2		= S2*2
	    RRMIN	= RMIN
	    RRMAX	= RMAX
	    RAVE	= RTOT/TRANS
	    RDEL	= SQRT(RTOT2/TRANS - (RTOT/TRANS)**2)
	    AVEINTENS	= TRANS/NFINAL
	    WRITE (21,*)  SW1,SW2,RRMIN,RRMAX,RAVE,RDEL,NFINAL,AVEINTENS
15	  CONTINUE
20	CONTINUE
	CLOSE	(21)
	END
