/*****************************************************************************
 *                                                                           *
 *  PRIMVS - Graphic Interpreter for X-Ray Lithography
 *                                                                           *
 ***************************************************************************** 
 *
 *  Author:   Luigi Capodieci
 *  Project:  PLPLOT based graphic interpreter
 *
 *  $Source: 
 *  $Revision:
 *  $Date: 
 *  $Log: init.c,v $
 *  Revision 1.2  1997/12/07 21:57:48  khan
 *  various fixes
 *
 *  Revision 1.1.1.1  1996/07/11 13:52:45  khan
 *  Initial checkin of SHADOW 2.1 distribution sources
 *
 * Revision 1.1.1.1  1996/01/02  17:07:39  khan
 * Toolset 2.0 release
 *
 *****************************************************************************/ 

#include	"allinclude.h"

/*****************************************************************************/ 

var_type	findvar(thekey)

char		thekey[MAX_WORD_LENGTH];
{
	   if ((strcmp(thekey,V_PPOSXMIN))==0) return(PPOSXMIN);
	   if ((strcmp(thekey,V_PPOSXMAX))==0) return(PPOSXMAX);
	   if ((strcmp(thekey,V_PPOSYMIN))==0) return(PPOSYMIN);
	   if ((strcmp(thekey,V_PPOSYMAX))==0) return(PPOSYMAX);
	   if ((strcmp(thekey,V_XLABEL))==0) return(XLABEL);
}

void	read_default()

{
char	tempstr[MAX_WORD_LENGTH];


	fscanf(deftablefile,"%lf",&pposxmin);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&pposxmax);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&pposymin);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&pposymax);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);

	fscanf(deftablefile,"%lf",&mposxmin);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&mposxmax);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&mposymin);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&mposymax);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);

	fscanf(deftablefile,"%lf",&cxmin);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&cxmax);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&cymin);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&cymax);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);

	fscanf(deftablefile,"%d",&cnx);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%d",&cny);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);

	fscanf(deftablefile,"%s",xoptions);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%s",yoptions);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&xtickint);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%lf",&ytickint);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%d",&xticksub);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%d",&yticksub);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);

	fscanf(deftablefile,"%d",&color);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%d",&linestyle);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%d",&linewidth);
	fgets(tempstr,MAX_WORD_LENGTH,deftablefile);
	fscanf(deftablefile,"%d",&point_symbol);


}

void	read_built_in()

{

	pposxmin=DPPOSXMIN;
	pposxmax=DPPOSXMAX;
	pposymin=DPPOSYMIN;
	pposymax=DPPOSYMAX;

	mposxmin=DMPOSXMIN;
	mposxmax=DMPOSXMAX;
	mposymin=DMPOSYMIN;
	mposymax=DMPOSYMAX;

	cxmin=DCXMIN;
	cxmax=DCXMAX;
	cymin=DCYMIN;
	cymax=DCYMAX;

	cnx=DCNX;
	cny=DCNY;

	strcpy(xoptions,DXOPTIONS);
	strcpy(yoptions,DYOPTIONS);
	xtickint=DXTICKINT;
	ytickint=DYTICKINT;
	xticksub=DXTICKSUB;
	yticksub=DYTICKSUB;

	color=DCOLOR;
	linestyle=DLINESTYLE;
	linewidth=DLINEWIDTH;
	point_symbol=DPOINT_SYMBOL;


}
/*****************************************************************************/ 

char	gfilename[MAX_WORD_LENGTH]="";	    /* Name for gfile */
char	gcmdfilename[MAX_WORD_LENGTH]="";   /* Command filename (in gfile) */

void   initialize(argc, argv)
int argc;
char *argv[];

{
   int p;

/*** Initialize the default files: standard input,output,error */

  infile = stdin;
  outfile = stdout;
  errfile = stderr;

  strcpy(deftable_name,DEFTABLE_NAME);

/*** Initialize character set to NORMAL ***/

  charset=NORMAL_CHARSET;

/********** Read optional parameters ************************************/

  while ((p = getopt(argc,argv, "i:g:o:t:xh")) != EOF) {
    switch(p) {
      case 'o':
                 if ((outfile = fopen(optarg,"w")) == NULL)
                        {
                         fprintf(stderr,"ERROR opening output file\n");
                         exit(-1);
                        }
                 break;
      case 'i':
                 if ((infile = fopen(optarg,"r")) == NULL)
                        {
                         fprintf(stderr,"ERROR opening input file\n");
                         exit(-1);
                        }
                 break;
      case 'g':
                 if ((gfile = fopen(optarg,"r")) == NULL)
                        {
                         fprintf(stderr,"ERROR opening Gfile\n");
                         exit(-1);
                        }
		   else {
	     	    strcpy(gfilename,optarg);
		    g_file(gfilename);	/* Setup GFILE data structure */
		    g_string("cmdfile","Warning: GFILE Problems!",gcmdfilename);
		    g_close();
                    if ((infile = fopen(gcmdfilename,"r")) == NULL)
                        {
                         fprintf(stderr,"ERROR opening g-command file\n");
                         exit(-1);
                        }
		    }
		 break;
      case 't':
	     	 strcpy(deftable_name,optarg);
		 break;
      case 'x':
		 charset=EXT_CHARSET;
		 fprintf(errfile,"... Loading extended character set\n");
		 break;

      case '?':
          (void) fprintf(stderr, "USAGE: primvs [-o outfile]\n");
          (void) fprintf(stderr, "              [-i infile]\n");
          (void) fprintf(stderr, "              [-t default-table]\n");
          (void) fprintf(stderr, "              [-x (load extended character set)]\n");
          (void) fprintf(stderr, "              [-h help]\n");
		 exit(-1);
		 break;
      case 'h':
          (void) fprintf(stderr, "USAGE: primvs [-o outfile]\n");
          (void) fprintf(stderr, "              [-i infile]\n");
          (void) fprintf(stderr, "              [-t default-table]\n");
          (void) fprintf(stderr, "              [-x (load extended character set)]\n");
          (void) fprintf(stderr, "              [-h help]\n");
		 exit(-1);
    }
  }

/*************************************************************************/

/*************************************************************************/

	if ((deftablefile=fopen(deftable_name,"r")) == NULL) {
	   fprintf(stderr,"WARNING: default table not found (using built-in)\n");
	   read_built_in();
	   }
	 else {
	   read_default();
	   }

}
