C +++
C
C Source: src/tools/math/pp.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	pp.f
C Revision 1.1  90/07/17  13:55:04  khan
C Initial revision
C 
C 
C ---

     	IMPLICIT REAL*8	(A-G,O-Z)
     	CHARACTER *1	DUMMY
     	DIMENSION	REG (12),STACK (10)
     	DATA	PI	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA    TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOANGS	/  1.239 852	D+4		     /
     	REG (11)  =	TOANGS
     	REG (12)  =	PI
     	write(6,*)'This program simulates an RPN calculator, like an HP.'
     	write(6,*)'It works in double precision.For the moment,the stack'
     	write(6,*)'is 10 registers.The trig functions work in radians,'
     	write(6,*)'but there is an easy conversion key.'
     	write(6,*)'The "display" is the lowest register in the stack.'
     	write(6,*)'Enter the number correspondent to the function.'
     	write(6,*)' Use the negative code for the inverse function.'
     	write(6,*)'Press RETURN when ready to go'
     	READ (5,1111)	DUMMY
1111	FORMAT (A)
200	CALL	LIB$ERASEPAGE(1,1)
     	write(6,*)'- 10 	 	clear all'
     	write(6,*)'0 		enter X'
     	write(6,*)'1   SIN	,2   COS  ,3   TAN'
     	write(6,*)'4   LN  ,5   LOG  ,6  - not used yet-	'
     	write(6,*)'7  		SQRT	'
     	write(6,*)'8  		to degrees'
     	write(6,*)'9 		+9 CHS, -9 1/x'
     	write(6,*)'10		EXIT'
     	write(6,*)'11 (*) , 12 (+) , 13 (-) ,14 (/) '
     	write(6,*)'15		write x to register'
     	write(6,*)'16		read in x from register'
     	write(6,*)'17		exchange the two lowest stack regs.'
     	write(6,*)'18		step up (down) the stack'
     	write(6,*)'19		E (G) Format'
     	write(6,*)'20		print the registers and stack'
     	write(6,*)'Register 11 contains conversion eV-angstroms,12 PI.'
100	CALL LIB$ERASEPAGE (17,1)
     	write(6,*)'--------------------------------------------------'
     	IF (KFORM.EQ.0) THEN
     	write(6,*)'  Display =      ',STACK(1)
     	ELSE
     	WRITE (6,1112) STACK(1)
1112	FORMAT (1X,'  Display =      ',E24.16)
     	END IF
     	write(6,*)'--------------------------------------------------'
     	read(5,*)IWHAT
     	IF (IWHAT.EQ.-10) THEN
     	 DO 110 I=1,10
     	  STACK(I) 	=  0.0D0
     	  REG(I)	=  0.0D0
110       continue
     	 GO TO 100
     	ELSE
     	END IF
     	KSIGN = 1
     	IF (IWHAT.LT.0.AND.IWHAT.NE.-10) THEN
     	 KSIGN = - 1
     	 IWHAT = - IWHAT
     	ELSE
     	END IF
     	IF (IWHAT.EQ.0) THEN
     	 write(6,*)'?'
     	 read(5,*)X
     	 DO 20 I=9,1,-1
     	  STACK(I+1) 	=   STACK(I)
20       continue
     	  STACK(1)	=   X
     	  GO TO 100
     	END IF
     	IF (IWHAT.EQ.15.OR.IWHAT.EQ.16) THEN
     	 write(6,*)'Register (1-10) ?'
     	 read(5,*)IREG
     	END IF
     	GO TO (1,2,3,4,5,6,7,8,9,10)	IWHAT
     	GO TO (11,12,13,14,15,16,17,18,19) IWHAT - 10
     	IF (IWHAT.EQ.20) THEN
     	 write(6,*)'Registers and stack dump'
     	  DO 30 I=1,10
     	   write(6,*)I,REG(I),STACK(I)
30       continue
     	END IF
     	PAUSE

     	GO TO 200
1	IF (KSIGN.EQ.-1) THEN
     	STACK(1)	=    ASIN(STACK(1))
     	ELSE
     	STACK(1)	=     SIN(STACK(1))
     	END IF
     	GO TO 100
2	IF (KSIGN.EQ.-1) THEN
     	STACK(1)	=    ACOS(STACK(1))
     	ELSE
     	STACK(1)	=     COS(STACK(1))
     	END IF
     	GO TO 100
3	IF (KSIGN.EQ.-1) THEN
     	STACK(1)	=    ATAN(STACK(1))
     	ELSE
     	STACK(1)	=     TAN(STACK(1))
     	END IF
     	GO TO 100
4	IF (KSIGN.EQ.-1) THEN
     	STACK(1)	=    EXP(STACK(1))
     	ELSE
     	STACK(1)	=    LOG(STACK(1))
     	END IF
     	GO TO 100
5	IF (KSIGN.EQ.-1) THEN
     	STACK(1)	=    10.0D0**STACK(1)
     	ELSE
     	STACK(1)	=    LOG10(STACK(1))
     	END IF
     	GO TO 100
6	CONTINUE
     	GO TO 100
7	IF (KSIGN.EQ.-1) THEN
     	STACK(1)	=    STACK(1)**2
     	ELSE
     	STACK(1)	=    SQRT(STACK(1))
     	END IF
     	GO TO 100
8	IF (KSIGN.EQ.-1) THEN
	STACK(1)	=    TORAD*STACK(1)
     	ELSE
     	STACK(1)	=    TODEG*STACK(1)
     	END IF
     	GO TO 100
9	IF (KSIGN.EQ.-1) THEN
     	STACK(1)	=   1.0/STACK(1)
     	ELSE
     	STACK(1)	= - STACK(1)
     	END IF
     	GO TO 100

10	STOP

11	STACK(2)	=   STACK(1)*STACK(2)
     	GO TO 1000
12	STACK(2)  =   STACK(1) + STACK(2)
     	GO TO 1000
13	STACK(2)	=   STACK(2) - STACK(1)
     	GO TO 1000
14	STACK(2)	=   STACK(1)/STACK(2)
     	GO TO 1000
15	REG(IREG) 	=   STACK(1)
     	GO TO 100
16	STACK(1)	=   REG(IREG)
     	GO TO 100
17	X	=   STACK(1)
     	STACK(1)=   STACK(2)
     	STACK(2)=   X
     	GO TO 100
18     	IF (KSIGN.EQ.-1) THEN
     	GO TO 1000
     	ELSE
     	DO 40 I=9,1,-1
     	STACK(I+1) = STACK(I)
40      continue
     	STACK (1) = 0.0D0
     	END IF
     	GO TO 100
19	IF (KSIGN.EQ.-1) THEN
     	KFORM	= 1
     	ELSE
     	KFORM	= 0
     	END IF
     	GO TO 100

1000	CONTINUE
** Reorders the stack.
     	DO 50 I=1,9
     	STACK(I) = STACK(I+1)
50       continue
     	STACK(10) =  0.0D0
     	GO TO 100

     	END
