C +++
C
C Source: src/tools/tek-graphics/set_color.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: set_color.F
C Revision 1.3  1991/04/22  00:06:47  khan
C Fixed #include quotes
C
C Revision 1.2  1991/03/25  14:45:50  khan
C SUN port -- INCLUDE -> #include
C
C Revision 1.1  90/11/01  11:24:10  khan
C Initial revision
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

#ifndef vms
	subroutine set_color ()
	return
	end

#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'

C+++
C	SUBROUTINE	SET_COLOR
C
C	PURPOSE		To set the color for subsequent graphics on TEK 4107.
C
C	COLOR INDEX :	0  - Transparent
C			1  - White
C			2  - Red
C			3  - Green
C			4  - Blue
C			5  - Cyan
C			6  - Magenta
C			7  - Yellow
C			8  - Orange
C			9  - Green-Yellow
C			10 - Green-Cyan
C			11 - Blue-Cyan
C			12 - Blue-magenta
C			13 - Red-megenta
C			14 - Dark-Gray
C			15 - Light-Gray
C
C !!! NOTE: ONLY USED FOR SHADOW/VMS !!!
C
C+++
	SUBROUTINE	SET_COLOR (INDEX)
	INTEGER		COLOR_INDEX,INDEX
	CHARACTER*4	OUT
C
C The color index must be between 0 and 15.
C
	COLOR_INDEX	= MOD(INDEX,16)
	OUT(1:1)	= CHAR(27)
	OUT(2:2)	= CHAR(77)
	OUT(3:3)	= CHAR(76)
	OUT(4:4)	= CHAR(COLOR_INDEX+48)
	WRITE	(6,1111)	OUT
1111	FORMAT	(1X,A,$)
	RETURN
	END

#endif
