	subroutine nl_subs
	implicit integer (a-z)
c++
c
c  Functions for managing the Namelist table
c
c  NL_INIT
c  NL_UPDATE (key)
c  NL_DELETE (key)
c
c  Special cases of keys
c	-101	goto an optical element
c	-102	goto a screen
c	
c--
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "nldata.inc"
#	include "nl1data.inc"
#	include "context.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
	include 'nl1data.inc'
	include 'context.inc'
#endif
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	entry nl_init
c
	n_nl1data=0
	nl_key=0
	return
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
	entry nl_update (key)
c
	i=key
c
c  check for GOTO types of items
c
	if (i .lt. 0) then
	  if (i .eq. -101) goto_oe=nl_int
	  if (i .eq. -102) goto_scr=nl_int
	  goto 1002
	endif
c
	if (i .lt. 1 .or. i .gt. max_nl1data) then
	  write (message,1000) i,max_nl1data
 1000	  format ('NL_UPDATE: Key of ',i6,' exceeds maximum of ',i6)
	  call fatal
	endif
c
	call nl_pack (i)
c
 1002	return
c
ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc
c
c
	entry nl_delete (key)
c
	i=key
	if (i .lt. 1 .or. i .gt. max_nl1data) then
	  write (message,1005) i,max_nl1data
 1005	  format ('NL_DELETE: Key of ',i6,' exceeds maximum of ',i6)
	  call fatal
	endif
c
	nl1_rec(i)=' '
	nl1_name(i)=' '
	nl1_own1(i)=0
	nl1_own2(i)=0
c
	return
	end

	subroutine nl_find (key,rec,name,own1,own2)
	implicit integer (a-z)
c++
c
c	subroutine nl_find (key,rec,name,own1,own2)
c
c	key		- transput/integer
c			  on input
c			    0 => start search from beginning
c			      otherwise start search from this point
c			  on output
c			    0 => no match found
c			      else key to be used for later reference
c
c	rec		- input/string
c			    name to be used for searching table
c			    must not be blank
c
c	name		- input/string
c			    name to be used for searching table
c			    if blank interpreted as wild-card
c				'GOTO_OE' and "GOTO_SCR' are special cases
c
c	own1		- input/integer
c			    owner1 field ( 0 => use cur_own1 as value
c			                 (      if rec='OE' or rec='SCR'
c				         (-1 => wild-card)
c
c	own2		- input/integer
c			    owner2 field ( 0 => use cur_own2 as value
c					 (      if rec='SCR'
c					 (-1 => wild-card)
c			    
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "nldata.inc"
#	include "nl1data.inc"
#	include "context.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
	include 'nl1data.inc'
	include 'context.inc'
#endif
c
	character*(*) rec,name
c
c  special cases:
c
	if (name .eq. 'GOTO_OE') then
	  key=-101
	  nl_rec=rec
	  nl_name=name
	  nl_own1=0
	  nl_own2=0
	  nl_int=0
	  nl_real=0.0
	  nl_string=' '
	  nl_datatype='I'
	  nl_key=key
	  goto 3900
	endif
	if (name .eq. 'GOTO_SCR') then
	  key=-102
	  nl_rec=rec
	  nl_name=name
	  nl_own1=0
	  nl_own2=0
	  nl_int=0
	  nl_real=0.0
	  nl_string=' '
	  nl_datatype='I'
	  nl_key=key
	  goto 3900
	endif
c
c  copy subscript information
c
	tmp1=own1
	tmp2=own2
c
c  Disallow wild rec names
c
	if (rec .eq. ' ') then
	  message='NL_FIND: No wild card record names allowed'
	  call fatal
	endif
c
c  assume no wild cards
c
	some_wild=0
	wild_name=0
	wild_own1=0
	wild_own2=0
c
c  check for defaulted subscripts
c
	if (rec .eq. 'OE' .and. tmp1 .eq. 0) then
	  tmp1=cur_oe
	  tmp2=0
	endif
	if (rec .eq. 'SCR' .and. tmp1 .eq. 0) then
	  tmp1=cur_oe
	endif
	if (rec .eq. 'SCR' .and. tmp2 .eq. 0) then
	  tmp2=cur_scr
	endif
	if (rec .eq. 'PHO' .and. tmp1 .eq. 0) then
	  tmp1=cur_scr
	  tmp2=0
	endif
c
c  consider case of starting from middle
c
	start_key=key+1
	if (start_key .gt. n_nl1data) goto 3800
c
c  determine which ones are wildcards
c
	if (name .eq. ' ') wild_name=1
	if (tmp1 .eq. -1) wild_own1=1
	if (tmp2 .eq. -1) wild_own2=1
	some_wild=wild_name+wild_own1+wild_own2
c
	if (some_wild .ne. 0) goto 3200
c
c  optimize case of no wild cards
c
	do i=start_key,n_nl1data
	  if (nl1_rec(i) .eq. rec   .and.
     *	      nl1_name(i) .eq. name .and.
     *	      nl1_own1(i) .eq. tmp1 .and.
     *	      nl1_own2(i) .eq. tmp2) goto 3700
	end do
c
	goto 3800
c
c  wild card search
c
 3200	do i=start_key,n_nl1data
	  if (			     rec  .ne. nl1_rec(i))  goto 3220
	  if (wild_name .eq. 0 .and. name .ne. nl1_name(i)) goto 3220
	  if (wild_own1 .eq. 0 .and. tmp1 .ne. nl1_own1(i)) goto 3220
	  if (wild_own2 .eq. 0 .and. tmp2 .ne. nl1_own2(i)) goto 3220
	  goto 3700
 3220	continue
	end do
c
c  no match
c
	goto 3800
c
c  found a match
c
 3700	call nl_unpack (i)
	key=i
	goto 3900
c
c  no more matches found
c
 3800	key=0
c
 3900	return	
	end

	subroutine nl_unpack (key)
	implicit integer (a-z)
c++
c	subroutine nl_unpack (key)
c
c  Unpacks namelist entries
c
c	key		- input/integer
c			  indicates which element to unpack
c--
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "nldata.inc"
#	include "nl1data.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
	include 'nl1data.inc'
#endif
c
	nl_key=key
c
c  check for goto_oe
c
	if (key .eq. -101) then
	  nl_rec='OE'
	  nl_name='GOTO_OE'
	  nl_own1=0
	  nl_own2=0
	  nl_int=0
	  nl_real=0.0
	  nl_string=' '
	  nl_datatype='I'
	  nl_key=key
	  goto 100
	endif
c
c  check for goto_scr
c
	if (key .eq. -102) then
	  nl_rec='SCR'
	  nl_name='GOTO_SCR'
	  nl_own1=0
	  nl_own2=0
	  nl_int=0
	  nl_real=0.0
	  nl_string=' '
	  nl_datatype='I'
	  nl_key=key
	  goto 100
	endif
c
	nl_rec=nl1_rec(key)
	nl_name=nl1_name(key)
	nl_own1=nl1_own1(key)
	nl_own2=nl1_own2(key)
	nl_int=nl1_int(key)
	nl_real=nl1_real(key)
	nl_string=nl1_string(key)
	nl_datatype=nl1_datatype(key)
c
 100	return
	end

	subroutine nl_pack (key)
	implicit integer (a-z)
c++
c	subroutine nl_pack (key)
c
c  packs namelist entries
c
c	key		- input/integer
c			  indicates which element to pack
c--
#if defined(unix) || HAVE_F77_CPP
#	include "parms.inc"
#	include "nldata.inc"
#	include "nl1data.inc"
#elif defined(vms)
	include 'parms.inc'
	include 'nldata.inc'
	include 'nl1data.inc'
#endif
c
	nl1_rec(key)=nl_rec
	nl1_name(key)=nl_name
	nl1_own1(key)=nl_own1
	nl1_own2(key)=nl_own2
	nl1_int(key)=nl_int
	nl1_real(key)=nl_real
	nl1_string(key)=nl_string
	nl1_datatype(key)=nl_datatype
c
	return
	end

	subroutine nl_delete_wild (rec,name,own1,own2)
	implicit integer (a-z)
c++
c	subroutine nl_delete_wild (rec,name,own1,own2)
c
c  Allows user to select using wildcards variables for deletion
c
c	rec		- input/string
c	name		- input/string
c	own1		- input/integer
c	own2		- input/integer
c
c--
	character*(*) rec,name
	key=0
 10	call nl_find (key,rec,name,own1,own2)
	if (key .eq. 0) goto 99
	call nl_delete (key)
	goto 10
 99	return
	end
