C +++
C
C Source: src/tools/math/dportho.f
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	dportho.f
C Revision 1.2  90/11/13  14:02:59  khan
C Cleanup and SAVE statements
C 
C Revision 1.1  90/07/17  13:54:51  khan
C Initial revision
C 
C 
C ---

C+++
C	Program		POLORTHO
C
C	Purpose:	To fit a discrete array of data with orthogonal
C			polinomial of any degree.
C
C	Algorithm	Least square fit using modified Legendre 
C			polinomials in discrete form
C			
C			IMSL's DCADRE is used for the integration and
C			a spline fit if data are not equispaced.
C
C	Limitations	The input array data must be in
C			ascending X order: X(I+1).GT.X(I)
C---
     	PROGRAM		POLORTHO
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	DIMENSION	X(1000),Y(1000),A(20),XOUT(1000),YOUT(1000)
	DIMENSION	SPL (999,3)
     	CHARACTER*40	INFILE,OUTFIL
	EXTERNAL	BPOL,FINT
     	WRITE(6,*)'This program will generate the following files:'
     	WRITE(6,*)'	POLFIT.DAT   : fitted function'
     	WRITE(6,*)'	CHIFIT.DAT   : error'
     	WRITE(6,*)'        user defined : fitting coefficients'

100	WRITE(6,*)'Input file ?'
     	READ (5,1000)	INFILE
1000	FORMAT (A)
     	WRITE(6,*)'Output file ?'
     	READ (5,1000)	OUTFIL
     	OPEN (20,FILE=INFILE,STATUS='OLD',READONLY,ERR=100)
     	DO 10 I = 1,1000
     	READ (20,*,ERR=110,END=111)	X(I),Y(I)
10      CONTINUE     	
110	WRITE(6,*)'Error reading data file.'
     	STOP
111	CLOSE (20)
     	NN = I - 1
     	WRITE(6,*)'Read ',NN,' records.'
	WRITE(6,*)'Is the X-array equispaced ?'
	READ(5,*)IANSW
	IF (IANSW.NE.1) THEN
	 WRITE(6,*)'X(1) = ',X(1)
	 WRITE(6,*)'X(end) = ',X(NN)
	 WRITE(6,*)'Change limits ?'
	 READ(5,*)IANSW
	  IF (IANSW.EQ.1) THEN
	   WRITE(6,*)'Xmin, Xmax ?'
	   READ(5,*)XMIN,XMAX
	  ELSE
	    XMIN	=  X(1)
	    XMAX	=  X(NN)
	  END IF
	 WRITE(6,*)'Rescaling step ?'
	 READ(5,*)STEP
	   NCOM	=  (XMAX - XMIN)/STEP + 1
	 CALL	ICSCCU( X,Y,NN,SPL,999,IER)
	  IF (IER.NE.0) WRITE(6,*)'ERROR FROM ICSCCU ',IER
	 DO 20 I=1,NCOM
	   XOUT(I)	=   XMIN + (I-1)*STEP
20       CONTINUE
	 CALL	ICSEVU (X,Y,NN,SPL,999,XOUT,YOUT,NCOM,IER)
	  IF (IER.NE.0) WRITE(6,*)'ERROR FROM ICSEVU ',IER
	 DO 30 I=1,NCOM
	   Y(I) = YOUT(I)
	   X(I) = XOUT(I)
30       CONTINUE
     	  DELTA =  XMAX - XMIN
     	 OPEN (20,FILE='SPLFIT',STATUS='UNKNOWN')
C     	 OPEN (20,FILE='SPLFIT',STATUS='NEW')
     	  DO 40 I=1,NCOM
     	   WRITE (20,*) X(I),Y(I)
40       CONTINUE
     	 CLOSE (20)
	ELSE
	  XMIN	=  X(1)
	  XMAX	=  X(NN)
     	  DELTA	=  XMAX - XMIN
	  STEP	=  DELTA/(NN-1)
	  NCOM	=  NN
	END IF
     	 WRITE(6,*)'Polinomial degree ?'
     	 READ(5,*)NPOL
     	RSTEP  = 1.0/(NCOM-1)
     	DO 50 I=1,NCOM
     	X(I) = RSTEP*(I-1)
50      CONTINUE
     	CALL	LEGENDRE (X,Y,NCOM,NPOL,A)
     	WRITE(6,*)'Computation done.'
     	CHI	=  0.0
     	OPEN (21, FILE='CHIFIT', STATUS='UNKNOWN')
C     	OPEN (21, FILE='CHIFIT', STATUS='NEW')
	DO 60 I=1,NCOM
	   YARG = 0.0
     	   X(I) = XMIN + (I-1)*STEP
     	   XARG	= (X(I) - XMIN)/DELTA
	 DO 55 J =1,NPOL+1
	   YARG = YARG + A(J)*BPOL(XARG,J-1)
55       CONTINUE
     	DIFF	=  Y(I) - YARG
     	CHI	=  DIFF**2 + CHI
     	WRITE (21,*)	X(I),DIFF
60      CONTINUE
	CLOSE (21)
     	CHI	=  SQRT(CHI/NCOM)
     	WRITE(6,*)'Output step ?'
     	READ(5,*)STEP
     	OPEN (20,FILE=OUTFIL,STATUS='UNKNOWN')
C     	OPEN (20,FILE=OUTFIL,STATUS='NEW')
     	  WRITE (20,*) NPOL,'     Polinomial degree '
     	  WRITE (20,*) CHI,'     ERORR RMS'
     	 DO 70 I=0,NPOL
     	  WRITE (20,*)	A(I+1),'     term: ',I
70       CONTINUE
     	CLOSE (20)
     	NOUT = DELTA/STEP + 1
C	OPEN (20,FILE='POLFIT',STATUS='NEW')
	OPEN (20,FILE='POLFIT',STATUS='UNKNOWN')
	DO 80 I=1,NOUT
	   YARG = 0.0
     	   X(I) = XMIN + (I-1)*STEP
     	   XARG	= (X(I) - XMIN)/DELTA
	 DO 75 J =1,NPOL+1
	   YARG = YARG + A(J)*BPOL(XARG,J-1)
75       CONTINUE
	WRITE (20,*)	X(I),YARG
     	DIFF	=  Y(I) - YARG
     	WRITE (21,*)	X(I),DIFF
80      CONTINUE
	CLOSE (20)
     	WRITE(6,*)'All done.'
     	STOP
     	END

C+++
C	FUNCTION	BPOL (X,J)
C
C	Purpose		Computes the shifted Legendre polinomials of 
C			degree J at point X
C
C	Algorithm	Direct definition of the shifted Legendre
C			polinomials.
C
C	Limits		Argument domain must be within [ 0,1 ]
C
C---
     	FUNCTION	BPOL (X,J)
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	DIMENSION	XTEMP (20)
     	IF (X.GT.1.0.OR.X.LT.0.0)	WRITE(6,*)'Invalid argument ',X,J

	XTEMP(1)	=   1	
C 	ZERO DEGREE

	XTEMP(2)	=   1 - 2*X
	XTEMP(3)	=   1 - 6*X + 6*X**2
	XTEMP(4)	=   1 - 12*X + 30*X**2 - 20*X**3
	XTEMP(5)	=   1 - 20*X + 90*X**2 - 140*X**3 + 70*X**4
     	IF (J.LT.5) THEN
     	  BPOL	= XTEMP(J+1)
     	  RETURN
     	END IF
c
c uses recurrence formulae for terms greater than 4
c
     	DO 130 I=6,J+1
     	 XTEMP(I) = (XTEMP(I-1)*(2*I-1-(4*I-2)*X)
     $			 - XTEMP(I-2)*(I-1))/I
130     CONTINUE
     	BPOL = XTEMP(J+1)
     	RETURN
     	END

C+++
C	SUBROUTINE	LEGENDRE
C
C	Purpose		To find the coefficient of the best fit to a
C			set of data by means of Legendre Polinomials
C
C	Algorithm	1.) Fits a smooth spline to data array.
C			2.) Ths spline is used to define FINT
C			3.) DCADRE is used to evaluate the projection of
C			    FINT onto P(J)
C
C	Limitations     The X-array must be between [ 0,1 ]
C
C---
     	SUBROUTINE	LEGENDRE (X,Y,NP,NORD,COEFF)
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	DIMENSION	COEFF (20)
     	DIMENSION	X(1000),Y(1000)
     	COMMON	/LEG	/SPL(1000,999),X1(1000),Y1(1000),NPOINT,I
     	EXTERNAL	FINT,DCADRE
     	WRITE(6,*)'Call to LEGENDRE'
     	DO 140 I =1,NP
     	  X1(I) = X(I)
     	  Y1(I) = Y(I)
140     CONTINUE
     	NPOINT = NP
     	CALL	ICSCCU	(X,Y,NP,SPL,999,IER)
     	IF (IER.NE.0)	WRITE(6,*)'Error ICSCCU -- LEGENDRE'
     	AERR = 0.0
     	RERR = 1.0E-4
     	DO 150 I = 0,NORD
     	  VAL  =	DCADRE	(FINT,X(1),X(NP),AERR,RERR,ERROR,IER)
     	 IF (IER.NE.0)	WRITE(6,*)'Error ',IER,' DCADRE'
     	  COEFF(I+1) = VAL*(2*I+1)
150     CONTINUE
     	RETURN
     	END
C+++
C	Function	FINT (x)
C
C	Purpose		This function returns the integrand function for
C			the expansion of a spline function in a set of
C			Legendre polinomials
C
C	Algorithm	Direct definition
C
C	Limitations	Argument domain [ 0,1 ]
C
C---
     	FUNCTION	FINT(XVAR)
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	EXTERNAL	BPOL
     	COMMON	/LEG	/SPL(1000,999),X(1000),Y(1000),NP,JJ
     	DIMENSION	U(1),V(1)
     	U(1)	=   XVAR
     	CALL	ICSEVU	(X,Y,NP,SPL,999,U,V,1,IER)
     	IF (IER.NE.0) WRITE(6,*)'Error ICSEVU ( FINT) '
     	FINT	=   V(1)*BPOL(XVAR,JJ)
     	RETURN
     	END
