/*
 * chvalues.c:
 *
 * Author: Mumit Khan <khan@xraylith.wisc.edu>
 *
 * Source: src/utils/special/chvalues.c
 *
 * ------------------------------------------------
 * Mumit Khan
 * Center for X-ray Lithography
 * University of Wisconsin-Madison
 * 3731 Schneider Dr., Stoughton, WI, 53589
 * ------------------------------------------------
 *
 * Log: chvalues.c
 * Revision 1.1  1991/05/14  19:13:33  khan
 * Initial revision
 *
 *
 */

#include <unistd.h>		/* for R_OK, F_OK */
#include <stdio.h>
#include <math.h>
#include <sys/file.h>		/* for access() parameters */
#include <string.h>
#include <signal.h>
#ifdef decstation
#include <cursesX.h>
#else
#include <curses.h>
#endif
#include "chval.h"
#include <common.h>
#include "command.h"

#include <libcxrl.h>

/*
 * these are also defined in namelist.c, so when chval uses the standard
 * interface, these should go away.
 */

int OE_NUMBER;
double DUMMY;
int IDUMMY;
int SCR_NUMBER[10];


#define True	(char)1
#define False	(char)0

/*
 * now decide whether to use array variables in x(i) or x_i notation.
 * This is for the various array memebers of SCR_NUMBER, etc.
 *
 * the default is to use the paren notation.
 *
 * G_ARRAY_ELEM(f,5) becomes f(5) or f_5 depending on the choice.
 * MAKE_XSTR(G_ARRAY_ELEM(f,5)) produces "f(5)" or "f_5"
 */

#define MAKE_XSTR(foo) MAKE_STR(foo)
#define MAKE_STR(foo) #foo
#if G_UNDERSCORE_ARRAY_NOTATION
# define G_ARRAY_ELEM(a,i) a ## _ ## i
#else
# define G_ARRAY_ELEM(a,i) a ## ( ## i ## )
#endif

#define ARR_ELEM(a,i) MAKE_XSTR(G_ARRAY_ELEM(a,i))

#define	Number(arr)	((unsigned int) (sizeof(arr) / sizeof(arr[0])))

static NmlDataRec nml_source_list[] = {
    {"Source angle distribution",		TRUE,
	"fdistr", 		DT_int, 	(char *)&FLAGS.fdistr},
    {"Source modelling type",			TRUE,
	"fgrid", 		DT_int, 	(char *)&FLAGS.fgrid},
    {"Source cross-section (X-Z)",		TRUE,
	"fsour", 		DT_int, 	(char *)&FLAGS.fsour},
    {"Source depth (Y)",			TRUE,
	"fsource_depth", 	DT_int, 	(char *)&FLAGS.fsource_depth},
    {"Incoherent (0) or coherent (1)",		TRUE,
	"f_coher", 		DT_int, 	(char *)&FLAGS.f_coher},
    {"Photon Energy Distribution",		TRUE,
	"f_color",		DT_int, 	(char *)&FLAGS.f_color},
    {"Photon Energy (eV (0)/Ang (1))",		TRUE,
	"f_phot", 		DT_int, 	(char *)&FLAGS.f_phot},
    {"Polarization component-S, P, TOT",	TRUE,
	"f_pol", 		DT_int, 	(char *)&FLAGS.f_pol},
    {"Generate A vectors: y/n (1/0)",		TRUE,
	"f_polar", 		DT_int, 	(char *)&FLAGS.f_polar},
    {"Save optical paths: y/n (1/0)",		TRUE,
	"f_opd", 		DT_int, 	(char *)&FLAGS.f_opd},
    {"Source: SR (0), wiggler (1), und (2)",	TRUE,
	"f_wiggler",		DT_int, 	(char *)&FLAGS.f_wiggler},
    {"Optimize the source: y/n (1/0)",		TRUE,
	"f_bound_sour", 	DT_int, 	(char *)&FLAGS.f_bound_sour},
    {"SR: photon (0)/power (1) distrib",	TRUE,
	"f_sr_type",		DT_int, 	(char *)&FLAGS.f_sr_type},
    {"Random number seed, odd",			TRUE,
	"istar1", 		DT_int, 	(char *)&CALC.istar1},
    {"Number of random rays (0-5000)",		TRUE,
	"npoint", 		DT_int, 	(char *)&CALC.npoint},
    {"Internal parameter",			FALSE,
	"ncol", 		DT_int, 	(char *)&CALC.ncol},
    {"Grid points on each circle",		TRUE,
	"n_circle",		DT_int, 	(char *)&CALC.n_circle},
    {"Number of energy lines",			TRUE,
	"n_color", 		DT_int, 	(char *)&CALC.n_color},
    {"Number of concentric circles",		TRUE,
	"n_cone", 		DT_int, 	(char *)&CALC.n_cone},
    {"Points in horizontal angle distrib",	TRUE,
	"ido_vx", 		DT_int, 	(char *)&CALC.ido_vx},
    {"Points in vertical angle distrib",	TRUE,
	"ido_vz", 		DT_int, 	(char *)&CALC.ido_vz},
    {"fsour=1 pts on x, =2 no. ellipses",	TRUE,
	"ido_x_s", 		DT_int, 	(char *)&CALC.ido_x_s},
    {"Points along depth (Y)",			TRUE,
	"ido_y_s", 		DT_int, 	(char *)&CALC.ido_y_s},
    {"fsour=1 pts on z, =2 no. ellipses",	TRUE,
	"ido_z_s", 		DT_int, 	(char *)&CALC.ido_z_s},
    {"No. of sigma levels (X)",			TRUE,
	"ido_xl", 		DT_int, 	(char *)&CALC.ido_xl},
    {"No. of rays/sigma level in X",		TRUE,
	"ido_xn", 		DT_int, 	(char *)&CALC.ido_xn},
    {"No. of sigma levels (Z)",			TRUE,
	"ido_zl", 		DT_int, 	(char *)&CALC.ido_zl},
    {"No. of rays/sigma level in Z",		TRUE,
	"ido_zn", 		DT_int, 	(char *)&CALC.ido_zn},
    {"Value for sigma level 1 (X)",		TRUE,
	"sigxl1", 		DT_dbl, 	(char *)&LIGHT.sigxl1},
    {"Value for sigma level 2 (X)",		TRUE,
	"sigxl2", 		DT_dbl, 	(char *)&LIGHT.sigxl2},
    {"Value for sigma level 3 (X)",		TRUE,
	"sigxl3", 		DT_dbl, 	(char *)&LIGHT.sigxl3},
    {"Value for sigma level 4 (X)",		TRUE,
	"sigxl4", 		DT_dbl, 	(char *)&LIGHT.sigxl4},
    {"Value for sigma level 5 (X)",		TRUE,
	"sigxl5", 		DT_dbl, 	(char *)&LIGHT.sigxl5},
    {"Value for sigma level 6 (X)",		TRUE,
	"sigxl6", 		DT_dbl, 	(char *)&LIGHT.sigxl6},
    {"Value for sigma level 7 (X)",		TRUE,
	"sigxl7", 		DT_dbl, 	(char *)&LIGHT.sigxl7},
    {"Value for sigma level 8 (X)",		TRUE,
	"sigxl8", 		DT_dbl, 	(char *)&LIGHT.sigxl8},
    {"Value for sigma level 9 (X)",		TRUE,
	"sigxl9", 		DT_dbl, 	(char *)&LIGHT.sigxl9},
    {"Value for sigma level 10 (X)",		TRUE,
	"sigxl10",		DT_dbl, 	(char *)&LIGHT.sigxl10},
    {"Value for sigma level 1 (Z)",		TRUE,
	"sigzl1", 		DT_dbl, 	(char *)&LIGHT.sigzl1},
    {"Value for sigma level 2 (Z)",		TRUE,
	"sigzl2", 		DT_dbl, 	(char *)&LIGHT.sigzl2},
    {"Value for sigma level 3 (Z)",		TRUE,
	"sigzl3", 		DT_dbl, 	(char *)&LIGHT.sigzl3},
    {"Value for sigma level 4 (Z)",		TRUE,
	"sigzl4", 		DT_dbl, 	(char *)&LIGHT.sigzl4},
    {"Value for sigma level 5 (Z)",		TRUE,
	"sigzl5", 		DT_dbl, 	(char *)&LIGHT.sigzl5},
    {"Value for sigma level 6 (Z)",		TRUE,
	"sigzl6", 		DT_dbl, 	(char *)&LIGHT.sigzl6},
    {"Value for sigma level 7 (Z)",		TRUE,
	"sigzl7", 		DT_dbl, 	(char *)&LIGHT.sigzl7},
    {"Value for sigma level 8 (Z)",		TRUE,
	"sigzl8", 		DT_dbl, 	(char *)&LIGHT.sigzl8},
    {"Value for sigma level 9 (Z)",		TRUE,
	"sigzl9", 		DT_dbl, 	(char *)&LIGHT.sigzl9},
    {"Value for sigma level 10 (Z)",		TRUE,
	"sigzl10",		DT_dbl, 	(char *)&LIGHT.sigzl10},
    {"From meters to user units",		TRUE,
	"conv_fact", 		DT_dbl, 	(char *)&SOURCE.conv_fact},
    {"fdistr=5; max half divergence",		TRUE,
	"cone_max", 		DT_dbl, 	(char *)&SOURCE.cone_max},
    {"fdistr=5; min half divergence",		TRUE,
	"cone_min", 		DT_dbl, 	(char *)&SOURCE.cone_min},
    {"X dist from waist of emittance",		TRUE,
	"epsi_dx", 		DT_dbl, 	(char *)&ALADDIN.epsi_dx},
    {"Z dist from waist of emittance",		TRUE,
	"epsi_dz", 		DT_dbl, 	(char *)&ALADDIN.epsi_dz},
    {"Beam emitt.-X rad*length units",		TRUE,
	"epsi_x", 		DT_dbl, 	(char *)&ALADDIN.epsi_x},
    {"Beam emitt.-Z rad*length units",		TRUE,
	"epsi_z", 		DT_dbl, 	(char *)&ALADDIN.epsi_z},
    {"Horizontal div. in +X (rads)",		TRUE,
	"hdiv1", 		DT_dbl, 	(char *)&SOURCE.hdiv1},
    {"Horizontal div. in -X (rads)",		TRUE,
	"hdiv2", 		DT_dbl, 	(char *)&SOURCE.hdiv2},
    {"Photon energy: min or 1st line",		TRUE,
	"ph1", 			DT_dbl, 	(char *)&LIGHT.ph1},
    {"Photon energy: max or 2nd line",		TRUE,
	"ph2", 			DT_dbl, 	(char *)&LIGHT.ph2},
    {"Third energy line",			TRUE,
	"ph3", 			DT_dbl, 	(char *)&LIGHT.ph3},
    {"Fourth energy line",			TRUE,
	"ph4", 			DT_dbl, 	(char *)&LIGHT.ph4},
    {"Fifth energy line",			TRUE,
	"ph5", 			DT_dbl, 	(char *)&LIGHT.ph5},
    {"Sixth energy line",			TRUE,
	"ph6", 			DT_dbl, 	(char *)&LIGHT.ph6},
    {"Seventh energy line",			TRUE,
	"ph7", 			DT_dbl, 	(char *)&LIGHT.ph7},
    {"Eigth energy line",			TRUE,
	"ph8", 			DT_dbl, 	(char *)&LIGHT.ph8},
    {"Ninth energy line",			TRUE,
	"ph9", 			DT_dbl, 	(char *)&LIGHT.ph9},
    {"Tength energy line",			TRUE,
	"ph10", 		DT_dbl, 	(char *)&LIGHT.ph10},
    {"Electron beam energy (GeV)",		TRUE,
	"bener", 		DT_dbl, 	(char *)&ALADDIN.bener},
    {"Phase difference in degrees",		TRUE,
	"pol_angle",		DT_dbl, 	(char *)&LIGHT.pol_angle},
    {"Degree of polarization (0<x<1)",		TRUE,
	"pol_deg", 		DT_dbl, 	(char *)&LIGHT.pol_deg},
    {"Bending magnet radius in user units",	TRUE,
	"r_aladdin", 		DT_dbl, 	(char *)&ALADDIN.r_aladdin},
    {"Bending magnet radius (m)",		TRUE,
	"r_magnet", 		DT_dbl, 	(char *)&ALADDIN.r_magnet},
    {"Sigma (rad) for horizontal div.",		TRUE,
	"sigdix", 		DT_dbl, 	(char *)&SOURCE.sigdix},
    {"Sigma (rad) for vertical div.",		TRUE,
	"sigdiz", 		DT_dbl, 	(char *)&SOURCE.sigdiz},
    {"Sigma in X",				TRUE,
	"sigmax", 		DT_dbl, 	(char *)&SOURCE.sigmax},
    {"Sigma in Y",				TRUE,
	"sigmay", 		DT_dbl, 	(char *)&SOURCE.sigmay},
    {"Sigma in Z",				TRUE,
	"sigmaz", 		DT_dbl, 	(char *)&SOURCE.sigmaz},
    {"Vertical div. in +Z (radians)",		TRUE,
	"vdiv1", 		DT_dbl, 	(char *)&SOURCE.vdiv1},
    {"Vertical div. in -Z (radians)",		TRUE,
	"vdiv2", 		DT_dbl, 	(char *)&SOURCE.vdiv2},
    {"Source width (X)",			TRUE,
	"wxsou", 		DT_dbl, 	(char *)&SOURCE.wxsou},
    {"Source depth (Y)",			TRUE,
	"wysou", 		DT_dbl, 	(char *)&SOURCE.wysou},
    {"Source height (Z)",			TRUE,
	"wzsou", 		DT_dbl, 	(char *)&SOURCE.wzsou},
    {"Source cone full opening (radians)",	TRUE,
	"plasma_angle", 	DT_dbl, 	(char *)&SOURCE.plasma_angle},
    {"Filename from make_id",			TRUE,
	"file_traj", 		DT_str, 	(char *)NAMES.file_traj},
    {"Internal parameter",			FALSE,
	"file_source", 		DT_str, 	(char *)NAMES.file_source},
    {"File from reflag and histo3",		TRUE,
	"file_bound", 		DT_str, 	(char *)NAMES.file_bound},
    {"Internal parameter",			FALSE,
	"oe_number",		DT_int, 	(char *)&OE_NUMBER},
    {"Internal parameter",			FALSE,
	"idummy", 		DT_int, 	(char *)&IDUMMY},
    {"Internal parameter",			FALSE,
	"dummy", 		DT_dbl, 	(char *)&DUMMY},
    {"Internal parameter",			FALSE,
	"f_new", 		DT_int, 	(char *)&FLAGS.f_new},
};

    /* end of source namelist block */

static NmlDataRec nml_oe_list[] = {
    {"Mirror surface, ie., spherical",		TRUE,
	"fmirr", 		DT_int, 	(char *)&FLAGS.fmirr},
    {"fmirr=3; mirror pole location",		TRUE,
	"f_torus",		DT_int, 	(char *)&FLAGS.f_torus},
    {"Cylindrical (1), regular(0)",		TRUE,
	"fcyl", 		DT_int, 	(char *)&FLAGS.fcyl},
    {"Internal (0), external (1) parms",	TRUE,
	"f_ext", 		DT_int, 	(char *)&FLAGS.f_ext},
    {"Move source; yes (1), no (0)",		TRUE,
	"fstat", 		DT_int, 	(char *)&FLAGS.fstat},
    {"Screens; yes (1), no (0)",		TRUE,
	"f_screen",		DT_int, 	(char *)&FLAGS.f_screen},
    {"Im. plates orth to opt axis",		TRUE,
	"f_plate", 		DT_int, 	(char *)&FLAGS.f_plate},
    {"Slit at contin plane",			TRUE,
	"fslit", 		DT_int, 	(char *)&FLAGS.fslit},
    {"Files to save option",			TRUE,
	"fwrite", 		DT_int, 	(char *)&FLAGS.fwrite},
    {"Distorted surface; yes(1), no(0)",	TRUE,
	"f_ripple", 		DT_int, 	(char *)&FLAGS.f_ripple},
    {"Move mirror; yes (1), no (0)",		TRUE,
	"f_move", 		DT_int, 	(char *)&FLAGS.f_move},
    {"Multilayer vary as the cosine (1/0)",	TRUE,
	"f_thick", 		DT_int, 	(char *)&FLAGS.f_thick},
    {"Asymmetric xtal; yes (1), no (0)",	TRUE,
	"f_bragg_a", 		DT_int, 	(char *)&FLAGS.f_bragg_a},
    {"Type of distortion",			TRUE,
	"f_g_s", 		DT_int, 	(char *)&FLAGS.f_g_s},
    {"Internal parameter",			FALSE,
	"f_r_ran", 		DT_int, 	(char *)&FLAGS.f_r_ran},
    {"Grating; yes (1), no (0)",		TRUE,
	"f_grating", 		DT_int, 	(char *)&FLAGS.f_grating},
    {"Mosaic xtal; yes (1), no (0)",		TRUE,
	"f_mosaic", 		DT_int, 	(char *)&FLAGS.f_mosaic},
    {"Johansson Geom; yes(1), no (0)",		TRUE,
	"f_johansson", 		DT_int, 	(char *)&FLAGS.f_johansson},
    {"Focus location; image/source",		TRUE,
	"f_side",		DT_int, 	(char *)&FLAGS.f_side},
    {"Autotuning of grating/xtal",		TRUE,
	"f_central", 		DT_int, 	(char *)&FLAGS.f_central},
    {"Mirror concave (0) or convex (1)",	TRUE,
	"f_convex", 		DT_int, 	(char *)&FLAGS.f_convex},
    {"Reflectivity of surface",			TRUE,
	"f_reflec", 		DT_int, 	(char *)&FLAGS.f_reflec},
    {"Line density absolute/signed",		TRUE,
	"f_rul_abs", 		DT_int, 	(char *)&FLAGS.f_rul_abs},
    {"Ruling type",				TRUE,
	"f_ruling", 		DT_int, 	(char *)&FLAGS.f_ruling},
    {"Recording sources spher/plane",		TRUE,
	"f_pw", 		DT_int, 	(char *)&FLAGS.f_pw},
    {"Recording sources cylindrical",		TRUE,
	"f_pw_c", 		DT_int, 	(char *)&FLAGS.f_pw_c},
    {"Source type real/virtual",		TRUE,
	"f_virtual", 		DT_int, 	(char *)&FLAGS.f_virtual},
    {"Mirror shape",				TRUE,
	"fshape", 		DT_int, 	(char *)&FLAGS.fshape},
    {"Mirror dimensions finite",		TRUE,
	"fhit_c", 		DT_int, 	(char *)&FLAGS.fhit_c},
    {"Monochromator type",			TRUE,
	"f_mono", 		DT_int, 	(char *)&FLAGS.f_mono},
    {"Reflector (0) refractor (1)",		TRUE,
	"f_refrac", 		DT_int, 	(char *)&FLAGS.f_refrac},
    {"Focii at contin plane",			TRUE,
	"f_default", 		DT_int, 	(char *)&FLAGS.f_default},
    {"Source of optical constants",		TRUE,
	"f_refl", 		DT_int, 	(char *)&FLAGS.f_refl},
    {"First(1) or second (2) grating",		TRUE,
	"f_hunt", 		DT_int, 	(char *)&FLAGS.f_hunt},
    {"xtal; yes (1), no (0)",			TRUE,
	"f_crystal", 		DT_int, 	(char *)&FLAGS.f_crystal},
    {"Tune to eV(0) or Angst(1)",		TRUE,
	"f_phot_cent", 		DT_int, 	(char *)&FLAGS.f_phot_cent},
    {"Roughness; y(1), n(0)",			TRUE,
	"f_roughness",		DT_int,		(char *)&FLAGS.f_roughness},
    {"Save inc. angle; y/1,n/0",		TRUE,
	"f_angle",		DT_int,		(char *)&FLAGS.f_angle},
    {"Internal parameter",			FALSE,
	"npoint", 		DT_int, 	(char *)&CALC.npoint},
    {"Internal parameter",			FALSE,
	"ncol", 		DT_int, 	(char *)&CALC.ncol},

    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,1), DT_int, 	(char *)&SCR_NUMBER[0]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,2), DT_int, 	(char *)&SCR_NUMBER[1]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,3), DT_int, 	(char *)&SCR_NUMBER[2]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,4), DT_int, 	(char *)&SCR_NUMBER[3]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,5), DT_int, 	(char *)&SCR_NUMBER[4]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,6), DT_int, 	(char *)&SCR_NUMBER[5]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,7), DT_int, 	(char *)&SCR_NUMBER[6]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,8), DT_int, 	(char *)&SCR_NUMBER[7]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,9), DT_int, 	(char *)&SCR_NUMBER[8]},
    {"Internal parameter",			FALSE,
	ARR_ELEM(scr_number,10), DT_int, 	(char *)&SCR_NUMBER[9]},

    {"Number of screens",			TRUE,
	"n_screen", 		DT_int, 	(char *)&CALC.n_screen},

    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,1), 	DT_int, 	(char *)&CALC.i_screen[0]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,2), 	DT_int, 	(char *)&CALC.i_screen[1]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,3), 	DT_int, 	(char *)&CALC.i_screen[2]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,4), 	DT_int, 	(char *)&CALC.i_screen[3]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,5), 	DT_int, 	(char *)&CALC.i_screen[4]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,6), 	DT_int, 	(char *)&CALC.i_screen[5]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,7), 	DT_int, 	(char *)&CALC.i_screen[6]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,8), 	DT_int, 	(char *)&CALC.i_screen[7]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,9), 	DT_int, 	(char *)&CALC.i_screen[8]},
    {"Screen before/after (1/0) mirror",	TRUE,
	ARR_ELEM(i_screen,10), DT_int, 	(char *)&CALC.i_screen[9]},

    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,1), 	DT_int, 	(char *)&CALC.i_abs[0]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,2), 	DT_int, 	(char *)&CALC.i_abs[1]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,3), 	DT_int, 	(char *)&CALC.i_abs[2]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,4), 	DT_int, 	(char *)&CALC.i_abs[3]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,5), 	DT_int, 	(char *)&CALC.i_abs[4]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,6), 	DT_int, 	(char *)&CALC.i_abs[5]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,7), 	DT_int, 	(char *)&CALC.i_abs[6]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,8), 	DT_int, 	(char *)&CALC.i_abs[7]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,9), 	DT_int, 	(char *)&CALC.i_abs[8]},
    {"Screen incl. absorption (1/0)",		TRUE,
	ARR_ELEM(i_abs,10), 	DT_int, 	(char *)&CALC.i_abs[9]},

    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,1), 	DT_int, 	(char *)&CALC.i_stop[0]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,2), 	DT_int, 	(char *)&CALC.i_stop[1]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,3), 	DT_int, 	(char *)&CALC.i_stop[2]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,4), 	DT_int, 	(char *)&CALC.i_stop[3]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,5), 	DT_int, 	(char *)&CALC.i_stop[4]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,6), 	DT_int, 	(char *)&CALC.i_stop[5]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,7), 	DT_int, 	(char *)&CALC.i_stop[6]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,8), 	DT_int, 	(char *)&CALC.i_stop[7]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,9), 	DT_int, 	(char *)&CALC.i_stop[8]},
    {"Obstruction (0) or aperture (1)",		TRUE,
	ARR_ELEM(i_stop,10), 	DT_int, 	(char *)&CALC.i_stop[9]},

    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,1), 	DT_int, 	(char *)&CALC.i_slit[0]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,2), 	DT_int, 	(char *)&CALC.i_slit[1]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,3), 	DT_int, 	(char *)&CALC.i_slit[2]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,4), 	DT_int, 	(char *)&CALC.i_slit[3]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,5), 	DT_int, 	(char *)&CALC.i_slit[4]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,6), 	DT_int, 	(char *)&CALC.i_slit[5]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,7), 	DT_int, 	(char *)&CALC.i_slit[6]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,8), 	DT_int, 	(char *)&CALC.i_slit[7]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,9), 	DT_int, 	(char *)&CALC.i_slit[8]},
    {"Aperture stop yes/no (1/0)",		TRUE,
	ARR_ELEM(i_slit,10), 	DT_int, 	(char *)&CALC.i_slit[9]},

    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,1), 	DT_int, 	(char *)&CALC.k_slit[0]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,2), 	DT_int, 	(char *)&CALC.k_slit[1]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,3), 	DT_int, 	(char *)&CALC.k_slit[2]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,4), 	DT_int, 	(char *)&CALC.k_slit[3]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,5), 	DT_int, 	(char *)&CALC.k_slit[4]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,6), 	DT_int, 	(char *)&CALC.k_slit[5]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,7), 	DT_int, 	(char *)&CALC.k_slit[6]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,8), 	DT_int, 	(char *)&CALC.k_slit[7]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,9), 	DT_int, 	(char *)&CALC.k_slit[8]},
    {"Stop/slit shape",				TRUE,
	ARR_ELEM(k_slit,10), 	DT_int, 	(char *)&CALC.k_slit[9]},

    {"Internal parameter",			FALSE,
	"istar1", 		DT_int, 	(char *)&CALC.istar1},
    {"Ang (deg) of cyl axis from X",		TRUE,
	"cil_ang", 		DT_dbl, 	(char *)&MIRROR.cil_ang},
    {"Ang of semi-major axis,mirr pole",	TRUE,
	"ell_the", 		DT_dbl, 	(char *)&MIRROR.ell_the},
    {"No. of extra image plates",		TRUE,
	"n_plates", 		DT_int, 	(char *)&CALC.n_plates},
    {"Internal parameters",			FALSE,
	"ig_seed", 		DT_int, 	(char *)&CALC.ig_seed},
    {"Random seed for mosaic xtal", 		TRUE,
	"mosaic_seed", 		DT_int, 	(char *)&CALC.mosaic_seed},
    {"Mirror orientation ang (deg)",		TRUE,
	"alpha", 		DT_dbl, 	(char *)&SYSTEM1.alpha},
    {"Dist of obj focus to mirr pole",		TRUE,
	"ssour", 		DT_dbl, 	(char *)&SYSTEM1.ssour},
    {"Incidence angle (deg)",			TRUE,
	"theta", 		DT_dbl, 	(char *)&SYSTEM1.theta},
    {"Dist from  mirr pole to im. focus",	TRUE,
	"simag", 		DT_dbl, 	(char *)&SYSTEM1.simag},
    {"Source dist from mirr pole",		TRUE,
	"rdsour", 		DT_dbl, 	(char *)&SYSTEM1.rdsour},
    {"Incidence ang (deg)",			TRUE,
	"rtheta", 		DT_dbl, 	(char *)&SYSTEM1.rtheta},
    {"offset in X in MRF",			TRUE,
	"off_soux", 		DT_dbl, 	(char *)&SYSTEM1.off_soux},
    {"offset in Y in MRF",			TRUE,
	"off_souy", 		DT_dbl, 	(char *)&SYSTEM1.off_souy},
    {"offset in Z in MRF",			TRUE,
	"off_souz", 		DT_dbl, 	(char *)&SYSTEM1.off_souz},
    {"Source rotation around Z(CCW +)",		TRUE,
	"alpha_s", 		DT_dbl, 	(char *)&SYSTEM1.alpha_s},
    {"Mirror half-length +Y",			TRUE,
	"rlen1", 		DT_dbl, 	(char *)&MIRROR.rlen1},
    {"Mirror half-length -Y",			TRUE,
	"rlen2", 		DT_dbl, 	(char *)&MIRROR.rlen2},
    {"Spherical mirror radius",			TRUE,
	"rmirr", 		DT_dbl, 	(char *)&MIRROR.rmirr},
    {"Semi-major axis of mirror",		TRUE,
	"axmaj", 		DT_dbl, 	(char *)&MIRROR.axmaj},
    {"Semi-minor axis of mirror",		TRUE,
	"axmin", 		DT_dbl, 	(char *)&MIRROR.axmin},
    {"Cone half opening (deg)",			TRUE,
	"cone_a", 		DT_dbl, 	(char *)&MIRROR.cone_a},
    {"Tangential (major) axis",			TRUE,
	"r_maj", 		DT_dbl, 	(char *)&MIRROR.r_maj},
    {"Sagittal (minor) axis",			TRUE,
	"r_min", 		DT_dbl, 	(char *)&MIRROR.r_min},
    {"Mirror half-width +X",			TRUE,
	"rwidx1", 		DT_dbl, 	(char *)&MIRROR.rwidx1},
    {"Mirror half-width -X",			TRUE,
	"rwidx2", 		DT_dbl, 	(char *)&MIRROR.rwidx2},
    {"Parab parm P of Y^2 = 2 P X",		TRUE,
	"param", 		DT_dbl, 	(char *)&MIRROR.param},
    {"Monochromator height",			TRUE,
	"hunt_h", 		DT_dbl, 	(char *)&GRATING.hunt_h},
    {"Monochromator length",			TRUE,
	"hunt_l", 		DT_dbl, 	(char *)&GRATING.hunt_l},
    {"Blaze length (deg)",			TRUE,
	"blaze", 		DT_dbl, 	(char *)&GRATING.blaze},
    {"Ruling density in 1/cm at origin",	TRUE,
	"ruling", 		DT_dbl, 	(char *)&GRATING.ruling},
    {"Diffraction order, inside < 0",		TRUE,
	"order", 		DT_dbl, 	(char *)&GRATING.order},
    {"Photon energy (eV) to autotune",		TRUE,
	"phot_cent", 		DT_dbl, 	(char *)&GRATING.phot_cent},
    {"Rotation about X (deg, +CW)",		TRUE,
	"x_rot", 		DT_dbl, 	(char *)&ROT_MIR.x_rot},
    {"Internal  parameter",			FALSE,
	"d_spacing", 		DT_dbl, 	(char *)&GRATING.d_spacing},
    {"Ang btwn xtal planes, surface",		TRUE,
	"a_bragg", 		DT_dbl, 	(char *)&GRATING.a_bragg},
    {"Mosaic spread FWHM (deg)",		TRUE,
	"spread_mos", 		DT_dbl, 	(char *)&XTAL.spread_mos},
    {"xtal thickness (cm)",			TRUE,
	"thickness", 		DT_dbl, 	(char *)&XTAL.thickness},
    {"Johansson radius",			TRUE,
	"r_johansson", 		DT_dbl, 	(char *)&XTAL.r_johansson},
    {"Rotation about Y (deg, +CW)",		TRUE,
	"y_rot", 		DT_dbl, 	(char *)&ROT_MIR.y_rot},
    {"Rotation about Z (deg, +CW)",		TRUE,
	"z_rot", 		DT_dbl, 	(char *)&ROT_MIR.z_rot},
    {"Mirror offset in X (MRF)",		TRUE,
	"offx", 		DT_dbl, 	(char *)&ROT_MIR.offx},
    {"Mirror offset in Y (MRF)",		TRUE,
	"offy", 		DT_dbl, 	(char *)&ROT_MIR.offy},
    {"Mirror offset in Z (MRF)",		TRUE,
	"offz", 		DT_dbl, 	(char *)&ROT_MIR.offz},
    {"Slit length (sagitall X)",		TRUE,
	"sllen", 		DT_dbl, 	(char *)&SLIT.sllen},
    {"Slit width (dispersion Z)",		TRUE,
	"slwid", 		DT_dbl, 	(char *)&SLIT.slwid},
    {"Slit tilt (+CCW degress)",		TRUE,
	"sltilt", 		DT_dbl, 	(char *)&SLIT.sltilt},
    {"Codling slit length (sagittal)",		TRUE,
	"cod_len", 		DT_dbl, 	(char *)&SLIT.cod_len},
    {"Codling slit width (tangential)",		TRUE,
	"cod_wid", 		DT_dbl, 	(char *)&SLIT.cod_wid},

    {"Source offset in X (SRF)",		TRUE,
	"x_sour", 		DT_dbl, 	(char *)&SOURCE.x_sour},
    {"Source offset in Y (SRF)",		TRUE,
	"y_sour", 		DT_dbl, 	(char *)&SOURCE.y_sour},
    {"Source offset in Z (SRF)",		TRUE,
	"z_sour", 		DT_dbl, 	(char *)&SOURCE.z_sour},
    {"Source rotation about X (SRF)",		TRUE,
	"x_sour_rot", 		DT_dbl, 	(char *)&SOURCE.x_sour_rot},
    {"Source rotation about Y (SRF)",		TRUE,
	"y_sour_rot", 		DT_dbl, 	(char *)&SOURCE.y_sour_rot},
    {"Source rotation about Z (SRF)",		TRUE,
	"z_sour_rot", 		DT_dbl, 	(char *)&SOURCE.z_sour_rot},
    {"Angstroms to autotune to",		TRUE,
	"r_lambda", 		DT_dbl, 	(char *)&GRATING.r_lambda},
    {"Elevation (deg) of im. plate",		TRUE,
	"theta_i", 		DT_dbl, 	(char *)&IMAGE.theta_i},
    {"Azimuth (deg) of im. plate",		TRUE,
	"alpha_i", 		DT_dbl, 	(char *)&IMAGE.alpha_i},
    {"Incidence angle (deg)",			TRUE,
	"t_incidence", 		DT_dbl, 	(char *)&AXIS.t_incidence},
    {"Source plane distance",			TRUE,
	"t_source", 		DT_dbl, 	(char *)&AXIS.t_source},
    {"Image plane distance",			TRUE,
	"t_image", 		DT_dbl, 	(char *)&AXIS.t_image},
    {"Reflection angle (deg)",			TRUE,
	"t_reflection",		DT_dbl, 	(char *)&AXIS.t_reflection},
    {"Filename of SOURCE array",		TRUE,
	"file_source", 		DT_str, 	(char *)&NAMES.file_source[0]},
    {"File with distortion info",		TRUE,
	"file_rip", 		DT_str, 	(char *)&NAMES.file_rip[0]},
    {"File with optical const - mirr",		TRUE,
	"file_refl", 		DT_str, 	(char *)&NAMES.file_refl[0]},

#if HP_F77_BUGGY_NAMELIST
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,1), 	DT_str, 	(char *)&NAMES.filabs[0][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,2), 	DT_str, 	(char *)&NAMES.filabs[1][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,3), 	DT_str, 	(char *)&NAMES.filabs[2][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,4), 	DT_str, 	(char *)&NAMES.filabs[3][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,5), 	DT_str, 	(char *)&NAMES.filabs[4][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,6), 	DT_str, 	(char *)&NAMES.filabs[5][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,7), 	DT_str, 	(char *)&NAMES.filabs[6][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,8), 	DT_str, 	(char *)&NAMES.filabs[7][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,9), 	DT_str, 	(char *)&NAMES.filabs[8][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,10),	DT_str, 	(char *)&NAMES.filabs[9][0]},
#else
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,1), 	DT_str, 	(char *)&NAMES.file_abs[0][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,2), 	DT_str, 	(char *)&NAMES.file_abs[1][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,3), 	DT_str, 	(char *)&NAMES.file_abs[2][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,4), 	DT_str, 	(char *)&NAMES.file_abs[3][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,5), 	DT_str, 	(char *)&NAMES.file_abs[4][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,6), 	DT_str, 	(char *)&NAMES.file_abs[5][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,7), 	DT_str, 	(char *)&NAMES.file_abs[6][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,8), 	DT_str, 	(char *)&NAMES.file_abs[7][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,9), 	DT_str, 	(char *)&NAMES.file_abs[8][0]},
    {"File with optical const - screen",	TRUE,
	ARR_ELEM(file_abs,10),	DT_str, 	(char *)&NAMES.file_abs[9][0]},
#endif

    {"File with polynomial description",	TRUE,
	"file_mir", 		DT_str, 	(char *)&NAMES.file_mir[0]},
    {"File with roughness profile",		TRUE,
	"file_rough",		DT_str,		(char *)&NAMES.file_rough[0]},

    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,1), 	DT_dbl, 	(char *)&SCREENS.thick[0]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,2), 	DT_dbl, 	(char *)&SCREENS.thick[1]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,3), 	DT_dbl, 	(char *)&SCREENS.thick[2]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,4), 	DT_dbl, 	(char *)&SCREENS.thick[3]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,5), 	DT_dbl, 	(char *)&SCREENS.thick[4]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,6), 	DT_dbl, 	(char *)&SCREENS.thick[5]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,7), 	DT_dbl, 	(char *)&SCREENS.thick[6]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,8), 	DT_dbl, 	(char *)&SCREENS.thick[7]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,9), 	DT_dbl, 	(char *)&SCREENS.thick[8]},
    {"Screen - thickness of file (cm)",		TRUE,
	ARR_ELEM(thick,10), 	DT_dbl, 	(char *)&SCREENS.thick[9]},

    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,1), 	DT_dbl, 	(char *)&SCREENS.rx_slit[0]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,2), 	DT_dbl, 	(char *)&SCREENS.rx_slit[1]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,3), 	DT_dbl, 	(char *)&SCREENS.rx_slit[2]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,4), 	DT_dbl, 	(char *)&SCREENS.rx_slit[3]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,5), 	DT_dbl, 	(char *)&SCREENS.rx_slit[4]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,6), 	DT_dbl, 	(char *)&SCREENS.rx_slit[5]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,7), 	DT_dbl, 	(char *)&SCREENS.rx_slit[6]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,8), 	DT_dbl, 	(char *)&SCREENS.rx_slit[7]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,9), 	DT_dbl, 	(char *)&SCREENS.rx_slit[8]},
    {"Screen - slit/stop dimension in X",	TRUE,
	ARR_ELEM(rx_slit,10), 	DT_dbl, 	(char *)&SCREENS.rx_slit[9]},

    {"Dist from mirr center to plate",		TRUE,
	ARR_ELEM(d_plate,1), 	DT_dbl, 	(char *)&IMAGE.d_plate[0]},
    {"Dist from mirr center to plate",		TRUE,
	ARR_ELEM(d_plate,2), 	DT_dbl, 	(char *)&IMAGE.d_plate[1]},
    {"Dist from mirr center to plate",		TRUE,
	ARR_ELEM(d_plate,3), 	DT_dbl, 	(char *)&IMAGE.d_plate[2]},
    {"Dist from mirr center to plate",		TRUE,
	ARR_ELEM(d_plate,4), 	DT_dbl, 	(char *)&IMAGE.d_plate[3]},
    {"Dist from mirr center to plate",		TRUE,
	ARR_ELEM(d_plate,5), 	DT_dbl, 	(char *)&IMAGE.d_plate[4]},

    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,1), 	DT_dbl, 	(char *)&SCREENS.rz_slit[0]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,2), 	DT_dbl, 	(char *)&SCREENS.rz_slit[1]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,3), 	DT_dbl, 	(char *)&SCREENS.rz_slit[2]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,4), 	DT_dbl, 	(char *)&SCREENS.rz_slit[3]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,5), 	DT_dbl, 	(char *)&SCREENS.rz_slit[4]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,6), 	DT_dbl, 	(char *)&SCREENS.rz_slit[5]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,7), 	DT_dbl, 	(char *)&SCREENS.rz_slit[6]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,8), 	DT_dbl, 	(char *)&SCREENS.rz_slit[7]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,9), 	DT_dbl, 	(char *)&SCREENS.rz_slit[8]},
    {"Screen - slit/stop dimension in Z",	TRUE,
	ARR_ELEM(rz_slit,10), 	DT_dbl, 	(char *)&SCREENS.rz_slit[9]},

    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,1), 	DT_dbl, 	(char *)&SCREENS.sl_dis[0]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,2), 	DT_dbl, 	(char *)&SCREENS.sl_dis[1]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,3), 	DT_dbl, 	(char *)&SCREENS.sl_dis[2]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,4), 	DT_dbl, 	(char *)&SCREENS.sl_dis[3]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,5), 	DT_dbl, 	(char *)&SCREENS.sl_dis[4]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,6), 	DT_dbl, 	(char *)&SCREENS.sl_dis[5]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,7), 	DT_dbl, 	(char *)&SCREENS.sl_dis[6]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,8), 	DT_dbl, 	(char *)&SCREENS.sl_dis[7]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,9), 	DT_dbl, 	(char *)&SCREENS.sl_dis[8]},
    {"Screen - abs. dist from mirror",		TRUE,
	ARR_ELEM(sl_dis,10), 	DT_dbl, 	(char *)&SCREENS.sl_dis[9]},

    {"Fresnel zone plate; yes(1),no(0)",	TRUE,
	"fzp", 			DT_int, 	(char *)&FLAGS.fzp},
    {"Holo: entrance slit dist (cm)",		TRUE,
	"holo_r1", 		DT_dbl, 	(char *)&HOLO.holo_r1},
    {"Holo: exit slit dist (cm)",		TRUE,
	"holo_r2", 		DT_dbl, 	(char *)&HOLO.holo_r2},
    {"Holo: entrance slit incid ang",		TRUE,
	"holo_del", 		DT_dbl, 	(char *)&HOLO.holo_del},
    {"Holo: exit slit incid ang",		TRUE,
	"holo_gam", 		DT_dbl, 	(char *)&HOLO.holo_gam},
    {"Recording wavelength angst",		TRUE,
	"holo_w", 		DT_dbl, 	(char *)&HOLO.holo_w},
    {"Holo: entrance slit rot ang",		TRUE,
	"holo_rt1", 		DT_dbl, 	(char *)&HOLO.holo_rt1},
    {"Holo: exit slit rot ang",			TRUE,
	"holo_rt2", 		DT_dbl, 	(char *)&HOLO.holo_rt2},
    {"Ruling focus on mirror plane",		TRUE,
	"azim_fan", 		DT_dbl, 	(char *)&GRATING.azim_fan},
    {"Distance from grating ctr",		TRUE,
	"dist_fan", 		DT_dbl, 	(char *)&GRATING.dist_fan},
    {"Coma correction factor; 0 if none",	TRUE,
	"coma_fac", 		DT_dbl, 	(char *)&GRATING.coma_fac},
    {"Alpha: epsilon=(1-alpha)+i gamma",	TRUE,
	"alfa", 		DT_dbl, 	(char *)&LIGHT.alfa},
    {"Gamma of the above eqn",			TRUE,
	"gamma", 		DT_dbl, 	(char *)&LIGHT.gamma},
    {"Index of refraction in obj space",	TRUE,
	"r_ind_obj", 		DT_dbl, 	(char *)&LIGHT.r_ind_obj},
    {"Index of refraction in im. space",	TRUE,
	"r_ind_ima", 		DT_dbl, 	(char *)&LIGHT.r_ind_ima},
    {"a1 coefficient of polynomial",		TRUE,
	"rul_a1", 		DT_dbl, 	(char *)&GRATING.rul_a1},
    {"a2 coefficient of polynomial",		TRUE,
	"rul_a2", 		DT_dbl, 	(char *)&GRATING.rul_a2},
    {"a3 coefficient of polynomial",		TRUE,
	"rul_a3", 		DT_dbl, 	(char *)&GRATING.rul_a3},
    {"a4 coefficient of polynomial",		TRUE,
	"rul_a4", 		DT_dbl, 	(char *)&GRATING.rul_a4},
    {"Intercept selected (facet)",		TRUE,
	"f_polsel",		DT_int,		(char *)&FACET.f_polsel},
    {"Faceted mirror y/n",			TRUE,
	"f_facet",		DT_int,		(char *)&FACET.f_facet},
    {"Internal parameter",			FALSE,
	"f_fac_orient",		DT_int,		(char *)&FACET.f_fac_orient},
    {"Internal",				FALSE,
	"f_fac_latt",		DT_int,		(char *)&FACET.f_fac_latt},
    {"Facet width (x)",				TRUE,
	"rfac_lenx",		DT_dbl,		(char *)&FACET.rfac_lenx},
    {"Facet length",				TRUE,
	"rfac_leny",		DT_dbl,		(char *)&FACET.rfac_leny},
    {"Internal",				FALSE,
	"rfac_phax",		DT_dbl,		(char *)&FACET.rfac_phax},
    {"Internal",				FALSE,
	"rfac_phay",		DT_dbl,		(char *)&FACET.rfac_phay},
    {"Internal",				FALSE,
	"rfac_delx1",		DT_dbl,		(char *)&FACET.rfac_delx1},
    {"Internal",				FALSE,
	"rfac_delx2",		DT_dbl,		(char *)&FACET.rfac_delx2},
    {"Internal",				FALSE,
	"rfac_dely1",		DT_dbl,		(char *)&FACET.rfac_dely1},
    {"Internal",				FALSE,
	"rfac_dely2",		DT_dbl,		(char *)&FACET.rfac_dely2},
    {"File w/ facet info",			TRUE,
	"file_fac",		DT_str,		(char *)&NAMES.file_fac[0]},
    {"Segmented mirror y/n?",			TRUE,
	"f_segment",		DT_int,		(char *)&FLAGS.f_segment},
    {"Number of segments (X)",			TRUE,
	"iseg_xnum",		DT_int,		(char *)&SEGMENT.iseg_xnum},
    {"Number of segments (Y)",			TRUE,
	"iseg_ynum",		DT_int,		(char *)&SEGMENT.iseg_ynum},
    {"File w/orientation",			TRUE,
	"file_segment",		DT_str,		(char *)&NAMES.file_segment[0]},
    {"File w/polynomial",			TRUE,
	"file_segp",		DT_str,		(char *)&NAMES.file_segp[0]},
    {"Length of segments (x)",			TRUE,
	"seg_lenx",		DT_dbl,		(char *)&SEGMENT.seg_lenx},
    {"Length of segments (y)",			TRUE,
	"seg_leny",		DT_dbl,		(char *)&SEGMENT.seg_leny},
    {"kumakhov lens? y/n",			TRUE,
	"f_koma",		DT_int,		(char *)&KOMA.f_koma},
    {"File with parameters:",			TRUE,
	"file_koma",		DT_str,		(char *)&NAMES.file_koma[0]},
    {"Internal",				FALSE,
	"f_exit_shape",		DT_int,		(char *)&KOMA.f_exit_shape},
    {"Internal",				FALSE,
	"f_inc_mnor_ang",	DT_int,		(char *)&KOMA.f_inc_mnor_ang},
    {"Internal",				FALSE,
	"zko_length",		DT_dbl,		(char *)&KOMA.zko_length},
    {"Internal",				FALSE,
	"rkoma_cx",		DT_dbl,		(char *)&KOMA.rkoma_cx},
    {"Internal",				FALSE,
	"rkoma_cy",		DT_dbl,		(char *)&KOMA.rkoma_cy},
    {"Specify as r^2 instead of r",		TRUE,
	"f_koma_ca",		DT_int,		(char *)&KOMA.f_koma_ca},
    {"File with parameters (r^2)",		TRUE,
	"file_koma_ca",		DT_str,		(char *)&NAMES.file_koma_ca[0]},
    {"Save bounce/intercept info:",		TRUE,
	"f_koma_bounce",	DT_int,		(char *)&KOMA.f_koma_bounce},
    {"Amplitude of distortion along X",		TRUE,
	"x_rip_amp", 		DT_dbl, 	(char *)&RIPPLE.x_rip_amp},
    {"Wavelength along X axis",			TRUE,
	"x_rip_wav", 		DT_dbl, 	(char *)&RIPPLE.x_rip_wav},
    {"Phase for X axis;0 - max at origin",	TRUE,
	"x_phase", 		DT_dbl, 	(char *)&RIPPLE.x_phase},
    {"Amplitude of distortion along Y",		TRUE,
	"y_rip_amp", 		DT_dbl, 	(char *)&RIPPLE.y_rip_amp},
    {"Wavelength along X axis",			TRUE,
	"y_rip_wav", 		DT_dbl, 	(char *)&RIPPLE.y_rip_wav},
    {"Phase for Y axis;0 - max at origin",	TRUE,
	"y_phase", 		DT_dbl, 	(char *)&RIPPLE.y_phase},
    {"Internal parameter",			FALSE,
	"n_rip", 		DT_int, 	(char *)&RIPP_2.n_rip},
    {"RMS roughness X",				TRUE,
	"rough_x",		DT_dbl,		(char *)&RIPPLE.rough_x},
    {"RMS roughness Y",				TRUE,
	"rough_y",		DT_dbl,		(char *)&RIPPLE.rough_y},
    {"Internal parameter",			FALSE,
	"oe_number", 		DT_int, 	(char *)&OE_NUMBER},
    {"Internal parameter",			FALSE,
	"idummy", 		DT_int, 	(char *)&IDUMMY},
    {"Internal parameter",			FALSE,
	"dummy", 		DT_dbl, 	(char *)&DUMMY},
};


static NmlListRec nml_lists[] = {
    {NML_source,	Number (nml_source_list),	nml_source_list},
    {NML_oe,		Number (nml_oe_list),		nml_oe_list},
};


static int num_lists = Number (nml_lists);



char *str_up_case(str)
char *str;
{
    char *str_ptr = str;
    for (; *str_ptr; ++str_ptr) {
	if (islower (*str_ptr)) 
	    *str_ptr = toupper (*str_ptr);
	if (*str_ptr == '-') 
	    *str_ptr = '_';
    }

    return str;
}


char *str_lo_case(str)
char *str;
{
    char *str_ptr = str;
    for (; *str_ptr; ++str_ptr) {
	if (isupper (*str_ptr)) 
	    *str_ptr = tolower (*str_ptr);
	if (*str_ptr == '-') 
	    *str_ptr = '_';
    }
    return str;
}


NmlData get_nml_record (name) 
char *name;
{
    int i = 0, j = 0;
    /*
    extern NmlListRec nml_lists[];
    */
    
    for (; j < Number (nml_lists); j++) {
	NmlDataRec *nml_data = nml_lists[j].nml_data;
	unsigned int size = nml_lists[j].size;
	for (i = 0; i < size; i++) {
	    if (!strcmp (nml_data[i].name, name)) {
		return &nml_data[i];
	    }
	}
    }

    return NULL;
}


print_values () {
    int i = 0, j = 0;
    /*
    extern NmlListRec nml_lists[];
    */
    
    for (; j < Number (nml_lists); j++) {
	NmlDataRec *nml_data = nml_lists[j].nml_data;
	unsigned int size = nml_lists[j].size;
	for (; i < size; i++) {
	    print_val (&nml_data[i]);
	}
    }
}

print_val (data) 
NmlData data;
{

    fprintf (stdout, "Variable name %s\n\tcurrent value = ", data -> name);
    switch (data -> data_type) {
	case DT_int:
	    printf ("%d", *(int *)data -> value);
	    break;

	case DT_flt:
	    printf ("%f", *(float *)data -> value);
	    break;

	case DT_dbl:
	    printf ("%lf", *(double *)data -> value);
	    break;

	case DT_str:
	    printf ("%s", data -> value);
	    break;
	
	default:
	    printf ("Illegal data type %d\n", data -> data_type);
	    break;
    }
    puts ("\n");
}

char *sprint_val (data) 
NmlData data;
{
    
    static char buf[BUFSIZ];

    switch (data -> data_type) {
	case DT_int:
	    sprintf (buf, "%d", *(int *)data -> value);
	    break;

	case DT_flt:
	    sprintf (buf, "%f", *(float *)data -> value);
	    break;

	case DT_dbl:
	    sprintf (buf, "%lf", *(double *)data -> value);
	    break;

	case DT_str:
	    strncpy (buf, data -> value, FNAME_LEN);
	    buf[FNAME_LEN] = '\0';
	    break;
	
	default:
	    break;
    }

    return buf;
}

/***********************************************************************
 *
 * Check to see if the string "string" is an integer or not. An integer
 * is defined to be a string of digits optionally preceded by a '+\-'.
 * ie., integer = [+-][DIGIT][DIGIT]*.
 *
 * returns:
 *    0: ok
 *   -1: error
 *
 **********************************************************************/

int get_integer(string, intval)
char *string;
int *intval;
{
    int retval = 0;
    int positive = TRUE;
    char *tmpstring = string;

    /* find the sign of the damn thing */
    switch (*tmpstring) {
	case '-':
	    positive = FALSE;
	    /* FALL THRU */
	case '+':
	    tmpstring++;
	    break;
	default:
	    break;
    }
	
    if (*tmpstring == '\0') 
	return -1;

    while (*tmpstring != '\0') {
	if (!isdigit(*tmpstring++)) 
	    return -1;
    }

    /* now scan the damn thing (REPLACE with my own scanf!!) */
    sscanf (string, "%d", intval);
    return 0;
}


/***********************************************************************
 *
 * Is the string "string" a floating point number? A floating point @
 * is defined to be: [+-][DIGIT]*[.(digits)|(exponent)] 
 *
 * returns:
 *    0: ok
 *   -1: error
 *
 **********************************************************************/

int get_float(string, fltval)
char *string;
float *fltval;
{
    int got_period = 0;
    int dig_count = 0;
    char *tmpstring = string;
    int dummy = 0;

    if (*tmpstring == '-' || *tmpstring == '+') 
	tmpstring++;

    while (*tmpstring != '\0') {
	if (isdigit (*tmpstring)) {
	    dig_count++;
	} 
	else if (*tmpstring == '.' && !got_period) {
	    got_period = 1;
	} 
	else if (*tmpstring == 'e' || *tmpstring == 'E') {
	    if  (!((dig_count > 0) && (get_integer(++tmpstring,&dummy) != -1)))
		return -1;
	    else
		break;		/* tmpstring is now == '\0' */
	} 
	else {
	    return -1;
	}
	tmpstring++;
    }

    if (dig_count > 0) 
	sscanf (string, "%f", fltval);

    return (dig_count > 0) ? 0 : -1;
}


/***********************************************************************
 *
 * Is the string "string" a doubleing point number? A doubleing point @
 * is defined to be: [+-][DIGIT]*[.(digits)|(exponent)] 
 *
 * returns:
 *    0: ok
 *   -1: error
 *
 **********************************************************************/

int get_double(string, dblval)
char *string;
double *dblval;
{
    int got_period = 0;
    int dig_count = 0;
    char *tmpstring = string;
    int dummy = 0;

    if (*tmpstring == '-' || *tmpstring == '+') 
	tmpstring++;

    while (*tmpstring != '\0') {
	if (isdigit (*tmpstring)) {
	    dig_count++;
	} 
	else if (*tmpstring == '.' && !got_period) {
	    got_period = 1;
	} 
	else if (*tmpstring == 'e' || *tmpstring == 'E') {
	    if  (!((dig_count > 0) && (get_integer(++tmpstring,&dummy) != -1)))
		return -1;
	    else
		break;		/* tmpstring is now == '\0' */
	} 
	else {
	    return -1;
	}
	tmpstring++;
    }

    if (dig_count > 0) 
	sscanf (string, "%lf", dblval);

    return (dig_count > 0) ? 0 : -1;
}


int change_val (data, newval) 
NmlData data;
char *newval;
{
    
    float *fp = NULL;
    double *dp = NULL;
    int *ip = NULL;

    float f = 0;
    double d = 0;
    int i = 0;

    int len = 0;

    int retval = 0;

    switch (data -> data_type) {
	case DT_int:
	    if (get_integer (newval, &i)) {
		retval = -1;
	    }
	    else {
		ip = (int *) data -> value;
		*ip = i;
	    }
	    break;

	case DT_flt:
	    if (get_float (newval, &f)) {
		retval = -1;
	    }
	    else {
		fp = (float *) data -> value;
		*fp = f;
	    }
	    break;

	case DT_dbl:
	    if (get_double (newval, &d)) {
		retval = -1;
	    }
	    else {
		dp = (double *) data -> value;
		*dp = d;
	    }
	    break;

	case DT_str:
	    if ((len = strlen (newval)) > FNAME_LEN) {
		retval = -1;
	    }
	    else {
		/* FORTRAN strings have to NULL character, so kill it */
		strcpy (data -> value, newval);
		for (i = strlen(newval); i < FNAME_LEN; data->value[i++] = ' ')
		    ;
	    }
	    break;

	default:
	    break;
    }

    return retval;
}


/***********************************************************************
 *
 * file_exists:
 *
 * returns TRUE if the file exists and FALSE otherwise.
 *
 **********************************************************************/

int file_exists (fname)
char *fname;
{
    return (access (fname, F_OK) == 0);
}


/***********************************************************************
 *
 * file_readable:
 *
 * returns TRUE if the file is readable and FALSE otherwise.
 *
 **********************************************************************/

int file_readable (fname)
char *fname;
{
    return (access (fname, R_OK) == 0);
}


#define NML_READ_SO	"R_SOUR"
#define NML_WRITE_SO	"W_SOUR"
#define NML_READ_OE	"R_OE"
#define NML_WRITE_OE	"W_OE"

static char *nml_rd_req[] = {NML_READ_SO, NML_READ_OE};
static char *nml_wr_req[] = {NML_WRITE_SO, NML_WRITE_OE};

static char *nml_type_name[] = {"Source", "Optical Element"};


typedef struct BatchPListRec BatchPListRec, *BatchPList;
struct BatchPListRec {
    char	*name;
    char	*value;
    BatchPList	next;
};

#if !NO_FORT_UNDERSCORE
# define F77_NAME(f) f##_
#else
# define F77_NAME(f) f
#endif

/*
 * G77 (GNU FORTRAN, upto and including v.0.5.18) adds a SECOND underscore
 * to names that already contain an underscore. Annoying as well, and
 * hence the G77_HACK_NAME(f) hack.
 */

#define G77_HACK_NAME(f) f##__

#if G77
# define RW_NML		G77_HACK_NAME(rw_nml)
#else
# define RW_NML		F77_NAME(rw_nml)
#endif

#ifndef TRUE
#define TRUE	1
#endif
#ifndef FALSE
#define FALSE	0
#endif


#define READ_FILE	0x1
#define READ_TYPE	0x2
#define READ_CONF	0x4

#define BATCH_MODE	0x8

#define ch_error	error


static char *nml_file = NULL;
static char *nml_backup = NULL;
static int nml_type = (int) NML_none;
static int confirm = FALSE;

static int bmode = FALSE;

static char *prog_name = NULL;

static char tmpbuf[BUFSIZ];

/*
 * this is a gross hack to define __main that FORTRAN needs. Every C
 * main() MUST have this, at least when compiling with GCC. We could
 * of course put this in a file in the library, so every program will
 * have it.
 */
#if defined(__GNUC__)
void __main() {}
#endif

/*
 * shared version of libf2c.so supplied with many linux/ELF distribs
 * have trouble finding MAIN__. Don't know why!
 */
#if LINUX_F2C_MAIN_HACK
void MAIN__() { }
#endif

main (argc, argv)
int argc; 
char **argv;
{

    BatchPList batchparams = NULL;
    unsigned int argmask = 0; 
    char *ptr = strrchr(argv[0], '/');
    if (ptr) 
	prog_name = ptr + 1;
    else 
	prog_name = argv[0];

    (void) parse_args (argc, argv, &argmask, &batchparams);

    init_signals ();

    if (init_files (argmask & READ_FILE, argmask & READ_TYPE)) {
	ch_error ("Cannot read the namelist file");
	exit (1);
    }

    if (argmask & BATCH_MODE) {
	bmode = TRUE;
	exit (do_batch (batchparams));
    }

    if (init_screen ()) {
	ch_error ("Cannot initialize curses. Aborting ...");
	exit (1);
    }
    (void) init_list (nml_lists[nml_type].size);
    (void) add_lists (nml_lists[nml_type].nml_data, nml_lists[nml_type].size);
    init_list_viewport ();
    display_file_header (nml_file, nml_type_name[nml_type]);
    display_list ();
    display_msg ();

    set_cursel (0);
    highlight_item (0);

    while (do_command (get_command_char ()) != CMD_DONE)
	;

    (void) end_screen ();
    exit (0);
}


int parse_args (argc, argv, maskp, batchpp)
int argc;
char **argv;
unsigned int *maskp;
BatchPList *batchpp;
{
    extern int optind;
    extern char *optarg;

    extern char *prog_name;

    int c;
    unsigned int mask = *maskp;

    nml_type = NML_none;
    nml_file = NULL;

    while ((c = getopt (argc, argv, "hbt:f:")) != EOF) {
	switch (c) {
	    case 't':
		if (optarg[0] == 's' || optarg[0] == 'S') {
		    nml_type = NML_source;
		}
		else if (optarg[0] == 'o' || optarg[0] == 'O') {
		    nml_type = NML_oe;
		}

		mask |= READ_TYPE;
		break;
	    
	    case 'f':
		nml_file = strcpy (malloc (strlen (optarg) + 1), optarg);
		mask |= READ_FILE;
		break;
	    
	    case 'b':
		mask |= BATCH_MODE;
		break;
	    
	    case 'h':
		usage ();
		exit (0);
		break;
	    
	    default:
		usage ();
		exit (1);
		break;
	}
    }

    if (mask & BATCH_MODE && argc > optind) {
	extern char tmpbuf[];
	char *eq = NULL;
	BatchPList bhead = NULL;
	BatchPList btail = NULL;
	int i = optind;
	for (; i < argc; i++) {
	    strcpy (tmpbuf, argv[i]);
	    if (!(eq = strrchr (tmpbuf, '='))) {
		ch_error ("Error in name=value syntax. No \'=\' sign\n");
		usage ();
		exit (1);
	    }
	    if (!bhead) {
		bhead = btail = (BatchPList) malloc (sizeof (BatchPListRec));
		bhead -> next = btail -> next = NULL;
	    }
	    else {
		btail -> next = (BatchPList) malloc (sizeof (BatchPListRec));
		btail = btail -> next;
		btail -> next = NULL;
	    }

	    btail -> value = strcpy (malloc (strlen (eq+1) + 1), eq+1);
	    *eq = '\0';
	    btail -> name = strcpy (malloc (strlen (tmpbuf) + 1), tmpbuf);
	    str_lo_case (btail -> name);
	}

	if (!bhead) {
	    fprintf (stderr, "Warning: no name=value pair in batch mode\n");
	}
	else {
	    *batchpp = bhead;
	}
    }

    *maskp = mask;
    return (nml_file && nml_type != NML_none) ? 0 : -1;
}


usage ()
{
    extern char *prog_name;
    
    fprintf (stderr, 
    "Usage:%s [-h] [-b] [-f NamelistFile] [-t NamelistType] [name=value ...]\n\n\
    -h:			print this info\n\
    -b:			run in batch mode (ie., no screen interface)\n\
    -f NamelistFile:	SHADOW namelist (eg., start.00, start.01, etc)\n\
    -t NamelistType:	\"source\"/\"oe\" (also accepts \"s\"/\"o\")\n\n\
    name=value:		where variable \"name\" is assigned \"value\" and the\n\
			namelist file is written out with the new value.\n\
			valid only when BATCH mode [-b] is specified. No\n\
			spaces are allowed around \'=\'\n\n",
    prog_name);

    fprintf (stderr, 
    "Examples:\n\
    %s -f start.00 -t source\n\
    %s -f start.00 -t s\n\
    %s -f start.01 -t oe\n\
    %s -f start.01 -t oe\n\
    %s -b -f start.00 -t s npoint=4000 fdistr=1\n\n",
    prog_name, prog_name, prog_name, prog_name, prog_name);

    return;
}

    
		    

int init_files (file_read, type_read)
int file_read;
int type_read;
{
    
    int success = 0;
    int i = 0, j = 0;

    if (!file_read) {
	int done = FALSE;
	int count = 0;
	do {
	    int flen = 0;
	    fputs ("Enter namelist file name: ", stdout);
	    fgets (tmpbuf, BUFSIZ-1, stdin);
	    tmpbuf[flen = strlen (tmpbuf) - 1] = '\0';
	    nml_file = strcpy (malloc (flen + 1), tmpbuf);
	    if (!file_exists (nml_file) || !file_readable (nml_file)) {
		ch_error ("file %s does not exist or not readable");
		if (++count == 10) {
		    ch_error ("%%%% Too many tries ... giving up");
		    exit (1);
		}
	    }
	    else {
		done = TRUE;
	    }
	} while (!done);
    }


    /* find the type. if file name was not given, ask for the type anyway */
    if (!type_read || !file_read) {
	fputs ("Enter namelist type (source = 0, oe = 1): ", stdout); 
	(void) fgets (tmpbuf, BUFSIZ-1, stdin);
	(void) sscanf (tmpbuf, "%d", &nml_type);
    }
    if (nml_type != 0 && nml_type != 1) {
	fprintf (stderr, "%%%% Error: bad namelist %d\n", nml_type);
	fprintf (stderr, "%%%% \tsource namelist = 0, oe namelist = 1\n");
	exit (1);
    }
    /* set the backup file name */
    strcpy (
	nml_backup = xmalloc (strlen(nml_file) + strlen(".bak") + 1), 
	nml_file);
    strcat (nml_backup, ".bak");

    RW_NML (nml_file, nml_rd_req[nml_type], &success, 
	(unsigned long) strlen (nml_file),
	(unsigned long) strlen (nml_rd_req[nml_type]));
	
    return success;
}

void handle_sigstp () {
    return;
}

void handle_sigcont () {
    
    display_file_header (nml_file, nml_type_name[nml_type]);
    display_list ();
    display_msg ();

    highlight_item (get_cursel ());

    touch_all_windows ();
    return;
}

init_signals () {
    
#if defined(SIGTSTP) && defined(SIGCONT)
    (void) signal (SIGTSTP, handle_sigstp);
    (void) signal (SIGCONT, handle_sigcont);
#endif
    
    return;
}


add_lists (nml_data, nml_size)
NmlDataRec nml_data[];
int nml_size;
{
    int i = 0;

    for (i = 0; i < nml_size; ++i) {
	add_item_to_list (i, nml_data[i].synopsis, nml_data[i].name, 
	    (nml_data[i].allow_change) ? 
		sprint_val (&nml_data[i]) : "[Not user-modifiable]");
    }
}

int update_val (index, value)
int index;
char *value;
{
    return change_val (&nml_lists[nml_type].nml_data[index], value);
}


write_nml_file () {

    extern char tmpbuf[];
    extern int bmode;
    int success = 0;

    sprintf (tmpbuf, " %%%% saving namelist file %s (backup %s)",
	nml_file, nml_backup);
    if (!bmode)
	put_msg (tmpbuf);

    (void) rename (nml_file, nml_backup);
    (void) RW_NML (nml_file, nml_wr_req[nml_type], &success, 
	(unsigned long) strlen (nml_file),
	(unsigned long) strlen (nml_wr_req[nml_type]));
    if (success == 0)
	sprintf (tmpbuf, " %%%% namelist file %s saved", nml_file);
    else
	sprintf (tmpbuf, " %%%% Error saving namelist file %s", nml_file);
    if (!bmode)
	put_msg (tmpbuf);
}



int get_search_item (item)
char *item;
{
    extern NmlListRec nml_lists[];
    extern int nml_type;
    NmlDataRec *nml_data = nml_lists[nml_type].nml_data;
    unsigned int size = nml_lists[nml_type].size;

    static unsigned int last_index = 0;
    unsigned int index = last_index;

    static char buf[BUFSIZ];

    strcpy (buf, item);
    str_lo_case (buf);

    for (index = last_index; index < size; index++) {
	if (strstr (nml_data[index].name, item))
	    break;
    }

    return (index < size) ? index : -1;
}


int allow_change (index)
int index;
{
    return nml_lists[nml_type].nml_data[index].allow_change;
}


int valid_item (index)
int index;
{
    return index >= 0 && index < nml_lists[nml_type].size;
}


int bound_item_index (index)
int index;
{
    return (index < 0 | index >= nml_lists[nml_type].size) ? 
	((index < 0) ? 0 : nml_lists[nml_type].size - 1) : index;
}


int do_batch (batchp)
BatchPList batchp;
{
    int err = 0;
    for (; batchp; batchp = batchp -> next) {
	NmlData nml_data = get_nml_record (batchp -> name);

	if (!nml_data) {
	    ch_error ("%%%% variable \"%s\" not found in namelist",
	       batchp -> name);
	    ++err;
	}
	else if (change_val (nml_data, batchp -> value)) {
	    ch_error ("%%%% Illegal value \"%s\" given for \"%s\"",
	       batchp -> value, batchp -> name);
	    ++err;
	}
    }

    return (err) ? err : write_nml_file ();
}

