c +++
c
c  a2bin: program to convert an ascii BEGIN to binary one.
c 
c  Author: Mumit Khan <khan@xraylith.wisc.edu>
c 
c  Source: src/utils/special/a2bin.F
c 
c  ------------------------------------------------
c  Mumit Khan
c  Center for X-ray Lithography
c  University of Wisconsin-Madison
c  3731 Schneider Dr., Stoughton, WI, 53589
c  ------------------------------------------------
c 
c  Log:	a2bin.F
c  Revision 1.2  91/04/01  10:32:29  khan
c  fixed the 'END=xx' condition in reading the BEGIN files.
c 
c  Revision 1.1  91/01/24  16:22:08  khan
c  Initial revision
c 
c 
c ---

c +++
c
c ---
	program		a2bin
c
#if defined(unix) || HAVE_F77_CPP
c
c This causes problems with F77 drivers, since can't use -I directive.
c so I'll use the standard cpp directive instead.
c
c	INCLUDE         './../../include/common.blk'
c
c
#	include		<common.blk>
#elif defined(vms)
	include		'shadow$inc:common.blk'
#endif
c
	character*80	infile, outfile
	character*80	rstring
	real*8		ray (12, n_dim)
	real*8		phase (3, n_dim)
	real*8		ap (3, n_dim)
	integer		npoints, i, j
c
	infile = rstring ('Enter input ascii file: ')
	outfile = rstring ('Enter output binary file: ')
c
	open (22,file=infile,status='old')
c
c read the rays until all done.
c
 	npoints = 0
 19	continue
c	
	npoints = npoints + 1
	read (22, *, err=199, end=299) (ray (j, npoints), j = 1,  3)
	read (22, *, err=199) (ray (j, npoints), j = 4,  6)
	read (22, *, err=199) (ray (j, npoints), j = 7,  9)
	read (22, *, err=199) (ray (j, npoints), j = 10,  12)
	read (22, *, err=199) (phase (j, npoints), j = 1,  3)
	read (22, *, err=199, end=299) (ap (j, npoints), j = 1,  3)
c
c no error or end-of-file so far, so read more.
c
	goto 19
c
 199	continue
	write (*,*) 'ERROR: illegal ascii BEGIN file'
	close (22)
	goto 399
c
 299	continue
	npoints = npoints - 1
	close (22)
	write (*,*) 'Number of rays: ', npoints
c
c write output
c
#ifdef vms
	call write_off (outfile, ray, phase, ap, 18, npoints, 
     $	iflag, ierr)
#else
	iform = 0
	call write_off (outfile, ray, phase, ap, 18, npoints, 
     $	iflag, iform, ierr)
#endif
	
 399	continue
	end
