C +++
C
C Source: src/utils/pre/presurface.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log:	presurface.F
C Revision 1.6  92/01/16  15:36:41  cwelnak
C 6000 changes
C 
C Revision 1.5  91/07/06  19:20:42  khan
C Grenoble Changes ...
C 
C Revision 1.4  91/04/05  15:57:23  cwelnak
C changed quotes on #includes
C 
C Revision 1.3  91/03/25  16:25:02  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.2  91/01/25  16:50:37  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/10  13:12:57  khan
C Added Pre-processor directives for Unix/VMS compilations
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		PRESURFACE
c
c	PURPOSE		To compute a bi-cubic spline fitting a user
C			supplied surface
C
C	INPUT		A file containing the surface specification, in
C			the format:
C				Nx, Ny
C				Y(1),...,Y(Ny)
C				X(1),Z(1,1),...,Z(1,Ny)
C				.....
C				X(Nx),Z(Nx,1),...,Z(Nx,Ny)
C
C	Output		A file containing the spline array prepared by
C			IMSL function IBCCCU
C---
     	PROGRAM		PRESURFACE
     	IMPLICIT	REAL*8	(A-H,O-Z)
     	CHARACTER*80	INFILE,OUTFILE,RSTRING

C    	DIMENSION	CSPL (2,101,2,101), WK (20602)

C The dimensions of WK should be 2*NX*NY + 2*MAX(NX,NY).  If so, the
C size of WK for NX=101, NY=101 should be 20604 *not* 20602 as above.
C Below I have used the correct formula and have dimensioned WK for 201
C points, as I have CSPL, X, Y, and Z.

	DIMENSION	CSPL (2,201,2,201), WK (81204)
C     	DIMENSION	X(101),Y(101),Z(101,101)
     	DIMENSION	X(201),Y(201),Z(201,201)
1     	INFILE	=   RSTRING ('File containing the surface mesh ? ')
        OPEN	(20, FILE=INFILE, STATUS='OLD', IOSTAT = IERR)

    	IF (IERR.NE.0) THEN
    	  WRITE(6,*)'Cannot access ',INFILE
    	  IWHAT = IYES ('Retry ? ')
    	 IF (IWHAT.EQ.1) GOTO 1
    	  STOP
    	END IF
     	READ (20,*) NX, NY
C     	IF (NX.GT.101.OR.NY.GT.101) THEN
C Below, we now allow a maximum of 101 points instead of 201.
C
     	IF (NX.GT.201.OR.NY.GT.201) THEN
C     	  WRITE(6,*)'Arrays too large. Maximum allowed is 101 points.'
     	  WRITE(6,*)'Arrays too large. Maximum allowed is 201 points.'
     	  STOP 'Please retry with smaller arrays.'
     	END IF
     	IF (NX.LT.4.OR.NY.LT.4) THEN
     	  WRITE(6,*)'Not enough points to define arrays. Must be at',
     $		' least 4 points in each direction.'
     	  STOP 'Please retry with larger arrays.'
     	END IF
     	WRITE(6,*)'Setting up ',NX,' by ',NY,' array.'
C
C Reads in Y array
C
     	READ (20,*) (Y(I),I=1,NY)
C
C Now read X and Z arrays
C
     	DO 10 I=1,NX
     	  READ (20,*) X(I),(Z(I,J),J=1,NY)
10    	CONTINUE
     	WRITE(6,*)'Array read correctly. Compute spline.'
C
C Call IMSL routine to compute spline. Now use 201 points instead of 101.
C
C     	CALL	IBCCCU ( Z, X, NX, Y, NY, CSPL, 101, WK, IER)
     	CALL	IBCCCU ( Z, X, NX, Y, NY, CSPL, 201, WK, IER)
     	
	IF (IER.EQ.132) THEN
C     	  WRITE(6,*)'The X and/or Y array are not ordered properly. 
C     $    Please check data in ',INFILE
     	  WRITE(6,*)'The X and/or Y array are/is not ordered properly.' 
          WRITE(6,*)'Please check data in ',INFILE
	  STOP
     	END IF
     	WRITE(6,*)'Spline succesfully completed.'
     	OUTFILE	=   RSTRING ('Please enter file-name for storage: ')
#ifdef vms
     	OPEN (20, FILE=OUTFILE, STATUS='NEW', FORM='UNFORMATTED')
#else
     	OPEN (20, FILE=OUTFILE, STATUS='UNKNOWN', FORM='UNFORMATTED')
	REWIND (20)
#endif 
     	 WRITE (20)	NX, NY
     	 WRITE (20)	X,Y
     	 WRITE (20)	CSPL
     	CLOSE (20)
     	WRITE(6,*)'Task completed. Spline stored in ',OUTFILE
     	STOP
      END
