C +++
C
C Source: src/utils/pre/pre_mlayer.F
C
C ----------------------------------------------
C                SHADOW
C      Center for X-ray Lithography
C     University of Wisconsin-Madison
C  3731 Schneider Dr., Stoughton, WI, 53589
C ----------------------------------------------
C 
C Log: pre_mlayer.F
C Revision 1.9  1992/06/10  21:43:00  cwelnak
C line length troubles
C
C Revision 1.8  1992/03/31  19:41:24  cwelnak
C added graded multilayer updates.
C
C Revision 1.7  92/01/16  14:54:17  cwelnak
C 6000 changes
C 
C Revision 1.6  91/07/06  19:20:42  khan
C Grenoble Changes ...
C 
C Revision 1.5  91/04/05  15:57:21  cwelnak
C changed quotes on #includes
C 
C Revision 1.4  91/03/25  16:24:56  khan
C SUN port -- INCLUDE -> #include
C 
C Revision 1.3  91/03/15  16:03:52  khan
C Getting  ready for sun port...
C 
C Revision 1.2  91/01/25  16:50:28  khan
C Ported to Ultrix
C 
C Revision 1.1  90/10/10  13:12:56  khan
C Added Pre-processor directives for Unix/VMS compilations
C 
C 
C ---

#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C	PROGRAM		PREMLAYER
C
C	Purpose		To prepare a multilayers file for input to SHADOW.
C
C---
     	CHARACTER*80	FILEOUT,RSTRING,FGRADE
	REAL		THICK(1001),GAMMA(1001)
        REAL*8  ESTART, EFINAL 
        REAL *8 RNUMBER
     	COMMON	/OPCON	/  ISTART,IFINAL
     	COMMON	/DAT	/  ENER(420),DELTA(420),BETA(420)
	FILEOUT	= RSTRING ('Name of output file : ')
10     	ESTART = RNUMBER ('Photon energy (eV) from : ')
	IF (ESTART.LT. DBLE(30)) THEN
	  WRITE(6,*)'Minimum energy is 30 eV.  Try again.'
	  GO TO 10
	END IF
11     	EFINAL = RNUMBER ('                     to : ')
	IF (EFINAL.GT.100000) THEN
	  WRITE(6,*)'Maximum energy is 100,000 eV.  Try again.'
	  GO TO 11
	END IF
	ELFACTOR = LOG10(1.0E4/30.0)/300.0
	ISTART = LOG10(ESTART/30.0E0)/ELFACTOR + 1
	IFINAL = LOG10(EFINAL/30.0E0)/ELFACTOR + 2
	NP = IFINAL - ISTART + 1
	OPEN	(20,FILE=FILEOUT,STATUS='UNKNOWN')
	REWIND (20)
	WRITE	(20,*)	NP
C
C Get the refractive index of the substrate.
C
	WRITE(6,*)'***************************************************'
	WRITE(6,*)'Specify the substrate material :'
	CALL	OPTPROPCOMP
	WRITE	(20,*)	(ENER(I), I = 1, NP)
	DO 19 I = 1, NP
 19	    WRITE	(20,*)	DELTA(I), BETA(I)
C
C Get the refractive index of the even layer.
C
	WRITE(6,*)'***************************************************'
	WRITE(6,*)'Right above the substrate is the even layer material'
	WRITE(6,*)'Specify the even layer material :'
	CALL	OPTPROPCOMP
	DO 29 I = 1, NP
 29	    WRITE	(20,*)	DELTA(I), BETA(I)
C
C Get the refractive index of the odd layer.
C
	WRITE(6,*)'***************************************************'
	WRITE(6,*)'Odd layer material is on top of the even layer.'
	WRITE(6,*)'Specify the odd layer material :'
	CALL	OPTPROPCOMP
	DO 39 I = 1, NP
 39    	    WRITE	(20,*)	DELTA(I), BETA(I)
	WRITE(6,*)'***************************************************'
	NPAIR	= IRINT ('No. of layer pairs : ')
	WRITE	(20,*)	NPAIR
   	WRITE(6,*) ' '
   	WRITE(6,*) 
     $'Starting from the substrate surface, specify the thickness t :'
   	WRITE(6,*) '      t = t(odd) + t(even)        in Angstroms,'
   	WRITE(6,*) 'and the gamma ratio :'
   	WRITE(6,*) '      t(even) / (t(odd) + t(even))'
   	WRITE(6,*) 'for EACH layer pairs.'
   	WRITE(6,*) ' '
   	WRITE(6,*) 
     $'Type two -1 whenever you want the remaining layers ',
     $'to assume the thickness and gamma ratio of the previous one.'
   	WRITE(6,*) ' '
   	DO 219 I = 1, NPAIR
   	  WRITE(6,*) 't and gamma ratio of layer ',I,' :'
   	  READ(5,*) THICK(I),GAMMA(I)
   	  IF (THICK(I).EQ.-1.AND.GAMMA(I).EQ.-1) THEN
   	    DO 319 J = I, NPAIR
   	      THICK(J) = THICK(I-1)
   	      GAMMA(J) = GAMMA(I-1)
319   	    CONTINUE
   	    GO TO 15
   	  END IF
219   	CONTINUE
15	DO 119 I = 1, NPAIR
   	  WRITE	(20,*)	THICK(I),GAMMA(I)
119   	CONTINUE
   
   	WRITE(6,*) '***************************************************'
   	IGRADE	= IYES('Is t and/or gamma graded over the surface ? ')
   	WRITE(6,*) ' '
   	WRITE	(20,*)	IGRADE
   	IF (IGRADE.EQ.1) THEN
   	WRITE(6,*) 
     $'Then GRADE_MLAYER should be run to generate the spline ',
     $'coefficients for the t and gamma factors over the surface.',
     $'  Here just type in the file name that WILL be used to store', 
     $' the spline coefficients :'
   	FGRADE	= RSTRING(' ')
   	WRITE	(20,*)	FGRADE
   	END IF
   	CLOSE 	(20)
        END
C+++
C	SUBROUTINE	OPTPROPCOMP
C
C---
     	SUBROUTINE	OPTPROPCOMP	
        REAL *8 	RNUMBER
        REAL*8          DENSITY
     	DIMENSION	ENERGY(420),IREL(5),AT(5)
     	INTEGER *4 	NUMBER
	CHARACTER*1	ELEMENT(5,2),ELE(2)
     	COMMON	/OPCON	/  ISTART,IFINAL
     	COMMON	/DAT	/  ENER(420),DELTA(420),BETA(420)
     	DIMENSION	OUTFIL11(420),OUTFIL12(420)
     	DIMENSION	OUTFIL21(420),OUTFIL22(420)
     	DIMENSION	OUTFIL31(420),OUTFIL32(420)
     	DIMENSION	OUTFIL41(420),OUTFIL42(420)
     	DIMENSION	OUTFIL51(420),OUTFIL52(420)
     	DATA	PI     	/  3.1415 92653 58979 32384 62643 D0 /
     	DATA	PIHALF 	/  1.5707 96326 79489 66192 31322 D0 /
     	DATA	TWOPI 	/  6.2831 85307 17958 64679 25287 D0 /
     	DATA	TODEG 	/ 57.2957 79513 08232 08767 98155 D0 /
     	DATA	TORAD	/  0.0174 53292 51994 32957 69237 D0 /
	DATA	TOCM	/  1.239 852	D-4		     /
	DATA	TOANGS 	/  1.239 852    D+4		     /
     	RADIUS	=   2.817939 E-13
     	AVOG	=   6.022098 E+23
    	DENSITY = RNUMBER('Density [ g/cm3 ] ? ')
     	DO 12 I = 1,5
     	  IREL(I) = 0
12     	CONTINUE
     	NATOMS = IRINT('How many atomic species (up to 5) ? ')
     	WRITE(6,*)'H2O would be: HH,2 and OO,1. Then ? '
     	DO 13 I = 1,NATOMS
     	WRITE(6,*)'Enter 2-letters (capitalized) atomic symbol and ',
     $'formula index for : ',I
	READ	(5,2)	(ELEMENT(I,K),K=1,2)
2	FORMAT	(2A1)
     	READ(5,*)IREL(I)
13     	CONTINUE
** Get the data. F1 and F2 are then 'averaged' together
     	RMOL	= 0.0
	IDK	=22
     	GO TO (55,44,33,22,11)	NATOMS
11	ELE(1)	= ELEMENT(5,1)
	ELE(2)	= ELEMENT(5,2)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL51,OUTFIL52)
     	RMOL	=          ATWT*IREL(5)
22	ELE(1)	= ELEMENT(4,1)
	ELE(2)	= ELEMENT(4,2)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL41,OUTFIL42)
     	RMOL	= RMOL+          ATWT*IREL(4)
33	ELE(1)	= ELEMENT(3,1)
	ELE(2)	= ELEMENT(3,2)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL31,OUTFIL32)
     	RMOL	= RMOL+         ATWT*IREL(3)
44	ELE(1)	= ELEMENT(2,1)
	ELE(2)	= ELEMENT(2,2)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL21,OUTFIL22)
     	RMOL	= RMOL+         ATWT*IREL(2)
55	ELE(1)	= ELEMENT(1,1)
	ELE(2)	= ELEMENT(1,2)
	CALL READLIB(ELE,NUMBER,ATWT,RMU,EMF,ENERGY,OUTFIL11,OUTFIL12)
     	RMOL	= RMOL+         ATWT*IREL(1)
     	WRITE (6,1110)
     	DO 14 I=1,NATOMS
     	WRITE (6,1111) ELEMENT(I,1),ELEMENT(I,2),IREL(I)
14     	CONTINUE
1110	FORMAT (1X,'Formula:  ',$)
1111	FORMAT ('+',A1,A1,'(',I2,') ',$)
     	WRITE (6,*)
** Computes atomic concentrations and molecular weigth
     	RMOLEC	=   DENSITY/RMOL*AVOG	! This is the number of molecules
     	WRITE (6,*)
     $'Molecular weight is : ',RMOL,' Number of molecules/cm3: ',RMOLEC
     	AT1	=   RMOLEC*irel(1)
     	AT(1)	=   AT1
     	AT2	=   RMOLEC*irel(2)
     	AT(2)	=   AT2
     	AT3	=   RMOLEC*irel(3)
     	AT(3)	=   AT3
     	AT4	=   RMOLEC*irel(4)
     	AT(4)	=   AT4
     	AT5	=   RMOLEC*irel(5)
     	AT(5)	=   AT5
     	WRITE (6,*) 'Atoms/Cm3 of each species:'
     	WRITE (6,1112) (ELEMENT(I,1),ELEMENT(I,2),I=1,NATOMS)
     	WRITE (6,1113) (AT(I),I=1,NATOMS)
1112	FORMAT (5X,A1,A1,T20,A1,A1,T35,A1,A1,T50,A1,A1,T65,A1,A1)
1113	FORMAT (1X,G12.5,T15,G12.5,T30,G12.5,T45,G12.5,T60,G12.5)
     	WRITE (6,*) ' Density ',DENSITY,' g/cm3'
** Computes now the effective F1 and F2
	J = 0
     	DO 16 I = ISTART,IFINAL
     	F1	=   0.0
     	F2	=   0.0
     	GO TO (155,144,133,122,111)	NATOMS
111	F1	=        OUTFIL51(I)*AT5
     	F2	=        OUTFIL52(I)*AT5
122	F1	=   F1 + OUTFIL41(I)*AT4
     	F2	=   F2 + OUTFIL42(I)*AT4
133	F1	=   F1 + OUTFIL31(I)*AT3
     	F2	=   F2 + OUTFIL32(I)*AT3
144	F1	=   F1 + OUTFIL21(I)*AT2
     	F2	=   F2 + OUTFIL22(I)*AT2
155	F1	=   F1 + OUTFIL11(I)*AT1
     	F2	=   F2 + OUTFIL12(I)*AT1
*** Computes now ALPHA and gamma
	J = J + 1
     	WAVE	=   TOCM/ENERGY(I)
     	ALPHA	=   RADIUS/PI*(WAVE**2)*F1
     	GAMMA	=   RADIUS/PI*(WAVE**2)*F2
	ENER(J)	=   ENERGY(I)
	DELTA(J) =  ALPHA/2
	BETA(J) =   GAMMA/2
16     	CONTINUE
	RETURN
     	END
