#if defined(unix) || HAVE_F77_CPP
#	include		<header.txt>
#elif defined(vms)
     	INCLUDE		'SHADOW$INC:HEADER.TXT/LIST'
#endif

C+++
C
C
C	(ported to unix 27 february 1992)
C       VMS Version July 27, 1990
C
C       program patch
C
C       This program takes as input a file which contains a bitmap.
C       there can be arbitrarily many disjoint bodies in the bitmap.
C       the algorithm identifies contiguous bodies, and determines if
C       they are simply connected.  If a body is not simply connected,
C       any holes are filled so that if the input contained n contiguous
C       bodies, the output will contain n simply connected contiguous bodies.
C     
C       
     	PROGRAM Patch
	implicit none
     	LOGICAL liformat, loformat
     	CHARACTER*80 infilename, outfilename 
	integer Xarray(10000)
	integer Yarray(10000)
	integer Zarray(10000)
	integer Xbins, X1Bins
	integer YBins, Y1Bins
	integer ZBins, Z1Bins

C
	call getpars (infilename, outfilename, liformat, loformat )
d        write(*,*) 'outof getpars'
	call readarray(xarray, xbins, x1bins, yarray,
     $                ybins, y1bins, zarray,
     $                zbins, z1bins, infilename, liformat)
d        write(*,*) 'out of readarray'
     	CALL Fill ( Xarray, XBins, X1Bins)
d        write(*,*) '1'
	call smooth( Xarray, XBins, X1Bins)
d        write(*,*) '3'
	call pad( xarray, Xbins, X1bins)
d        write(*,*) '4'
	call repair( Xarray, XBins, X1Bins)
d        write(*,*) '5'
     	CALL Fill ( Yarray, YBins, Y1Bins)
d        write(*,*) '6'
	call smooth( Yarray, YBins, Y1Bins)
d        write(*,*) '7'
	call pad( Yarray, Ybins, Y1bins)
d        write(*,*) '8'
	call repair( Yarray, YBins, Y1Bins)
d        write(*,*) '9'
     	CALL Fill ( Zarray, ZBins, Z1Bins)
d        write(*,*) '10'
	call smooth( Zarray, ZBins, Z1Bins)
d        write(*,*) '11'
	call pad( Zarray, Zbins, Z1bins)
d        write(*,*) '12'
	call repair( Zarray, ZBins, Z1Bins)
d        write(*,*) '13'
	call Writearray(xarray, Xbins, X1Bins, yarray,
     $                 YBins, Y1Bins, zarray,
     $                 ZBins, Z1Bins, outfilename, loformat)
d        write(*,*) 'out of writearray'
     	CALL EXIT (0)
     	END

C+++
C
C
C       subroutine repair 
C
C       this subroutine restores the array to its original format, i.e.
C       all 1's and 0's.
C
C---
	subroutine repair(iarray,xmax,Ymax)
	implicit none
	integer xmax, Ymax
	integer iarray(xmax, Ymax)
	integer xvar, Yvar

	do 100 yvar = 1, Ymax
	    do 200 Xvar = 1, Xmax
		if (iarray(xvar, Yvar) .ne. 0 ) then
		    iarray(xvar,Yvar) = 1
		endif
200         continue
100     continue
        return
	end


C+++
C   
C
C       subroutine fill
C
C       this does all of the patching.
C   
C       note convention: iarray = 0 : empty cell
C                        iarray = 1 : full cell
C                        iarray = 2 : full cell with border on one side
C                        iarray = 3 : full cell with border on both
C                                     left and right
C
C
C---
	subroutine fill(Iarray, xmax, ymax)
	implicit none
	integer xmax, ymax
	integer Iarray(xmax,ymax)
	integer xvar, yvar
	logical lin

d        write(*,*) 'in fill. xmax:',xmax,' ymax:',ymax
        lin = .false.
	do 100 yvar = 1,ymax
	    do 200 xvar = 1, xmax
300		continue
d               write(*,*) 'looping'
                if (iarray(xvar,yvar) .eq. 0) then
		    if (lin .eqv. .true.) then
			iarray(xvar,yvar) = 1
		    endif
		else if (iarray(xvar,yvar) .eq. 1) then
		    if (lin .eqv. .false.) then
d                        write(*,*) 'entering flagsurf'
			call flagsurf(iarray,xmax,ymax, xvar, yvar)
d                        write(*,*) 'out of flagsurf'
			goto 300
		    endif
		else if (iarray(xvar,yvar) .eq. 2) then
		    if (lin .eqv. .false.) then
			lin = .true.
		    else
			lin = .false.
		    endif
		endif
200         continue
            lin = .false.
d            write(*,*) 'yvar = ',yvar
100     continue
        return
	end
			

			
C+++
C
C
C
C     subroutine for flaging all cel which reside on the surface
C     (exterior) of the object.  usual convention applies ( 0 means
C     empty cell, 1 means full cell, 2 means full, surface-flagged
C     cell, 3 means full surface-flagged cell that has exterior on
C     both left and right.)
C          Note that the algorithm considers array indecies which
C     lie outside the boundaries of the array to automatically
C     returna value of 0.  The implications of this are that objects
C     which may be clipped at a wall are said to end there.
C
C
C---
     	SUBROUTINE flagSurf(iarray,Xmax,Ymax,xvar, yvar)
	implicit none
     	INTEGER Xmax, Ymax, Xvar, Yvar
     	integer iarray(xmax,ymax)
     	INTEGER PV(4), NV(4), FV(4), C(2,2,2)
	logical vertical

C
C    PV format:
C              pv(1) = x1
C              pv(2) = y1
C              pv(3) = x2
C              pv(4) = y2
C
C              (x1,y1) is said to be on the left of the vector,
C              (x2,y2) is said to be on the rightof the vector
C              ( with the vector pointing up ).  Full cell is always
C              on the right.
C
d        write(*,*) 'in findsurf'
     	PV(1) = xvar -1
     	PV(2) = yvar 
     	PV(3) = xvar
     	PV(4) = yvar
	FV(1) = Xvar -1
	FV(2) = yvar
	FV(3) = xvar
	FV(4) = yvar
100	continue
        if (vertical(pv) .eqv. .true.) then
	    iarray(PV(3), PV(4)) = iarray(PV(3), PV(4)) + 1
	endif
     	CALL PerField( PV, C )
     	CALL FindNV(C, iarray, NV, Xmax, Ymax)
	if (NV(1) .ne. FV(1)) then
	    goto 400
	else if (NV(2) .ne. FV(2)) then
	    goto 400
	else if (NV(3) .ne. FV(3)) then
	    goto 400
	else if (NV(4) .ne. FV(4)) then
	    goto 400
	else
	    goto 500
	endif
400    	PV(1) = NV(1)
     	PV(2) = NV(2)
     	PV(3) = NV(3)
     	PV(4) = NV(4)
d        write(*,*) pv(1),pv(2),pv(3),pv(4)
	goto 100
500     continue
     	RETURN
     	END


C+++
C
C
C---

	logical function vertical(pv)
	integer pv(4)

	if (( pv(2) - pv(4)) .eq. 0) then
	    vertical = .true.
	else
	    vertical = .false.
	endif
	return
	end

     		
C+++
C
c       These are low-level routines used by findsurf.
C
C---
     	SUBROUTINE PerField( V, C )
	implicit none
     	INTEGER V(4), C(2,2,2)
     	C(1,1,2) = V(1)
     	C(2,1,2) = V(2)
     	C(1,2,2) = V(3)
     	C(2,2,2) = V(4)
     	C(1,1,1) = V(1) + (V(2) - V(4))
     	C(2,1,1) = V(2) - (V(1) - V(3))
     	C(1,2,1) = V(3) + (V(2) - V(4))
     	C(2,2,1) = V(4) - (V(1) - V(3))
     	RETURN 
     	END

C+++
C
C      Low-level routine used by findsurf
C
C---
     	SUBROUTINE FindNV(C, iarray, NV, Xmax, Ymax)
	implicit none
     	INTEGER Xmax, Ymax
     	integer iarray(xmax,ymax)
     	INTEGER C(2,2,2), NV(4)
     	LOGICAL CLOG(2,2), OOB
     	OOB = ((C(1,1,1) .lt. 1) .or. (C(1,1,1) .gt. Xmax) .or.
     $	(C(2,1,1) .lt. 1) .or. (c(2,1,1) .gt. ymax))
     	If (OOB) THEN
     		CLog(1,1) = .false.
     	ELSE
    		CLOG(1,1) = ( iarray(C(1,1,1),C(2,1,1)) .gt.
     $		0) 
     	ENDIF
     	OOB = ((C(1,2,1) .lt. 1) .or. (C(1,2,1) .gt. Xmax) .or.
     $	(C(2,2,1) .lt. 1).or. (c(2,2,1) .gt. ymax))
     	IF (OOB) THEN
     		CLOG(2,1) = .false.
     	ELSE
     		CLOG(2,1) = ( iarray(C(1,2,1),C(2,2,1)) .gt.
     $		0) 
     	ENDIF
	IF (CLOG(1,1)) THEN
		NV(1) = C(1,1,2)  
     		NV(2) = C(2,1,2)
		NV(3) = C(1,1,1)
		NV(4) = C(2,1,1)
	ELSE IF (CLOG(2,1)) THEN
     		NV(1) = C(1,1,1)
     		NV(2) = C(2,1,1)
     		NV(3) = C(1,2,1)
     		NV(4) = C(2,2,1)
	ELSE
     		NV(1) = C(1,2,1)
     		NV(2) = C(2,2,1)
     		NV(3) = C(1,2,2)
     		NV(4) = C(2,2,2)
	ENDIF
     	RETURN
     	END



C+++
C
C
C     subroutine smooth.
C
C     a subroutine to fill small pits in the surface of a phase space
C     object which are more likely than not to be the result of statistical
C     errors.  The algorithm is simple.  If a square has three of its neighbors
C     filled, then it gets filled.  The process is repeated until no more
C     cells are filled.
C
C---
        subroutine smooth (iarray,xmax, ymax)
	implicit none
	integer xmax, ymax
	integer iarray(xmax, Ymax)
	logical AnyFilled
	integer xvar, yvar
	integer FilledNeighbors
	logical lmask(5,5)
	integer fullness
	integer x,y

        do 50 xvar = 1,5
	    do 60 yvar = 1,5
		lmask(xvar,Yvar) = .true.
60          continue
50      continue
        lmask(1,1) = .false.
	lmask(1,5) = .false.
	lmask(5,1) = .false.
	lmask(5,5) = .false.
100     continue
	AnyFilled = .false.
	do 200 yvar = 1,ymax
	    do 300 xvar = 1,xmax
		if (iarray(xvar,yvar) .eq. 0) then
                    FilledNeighbors = 0
		    if (xvar .gt. 1) then
		        if (iarray(xvar - 1, yvar) .gt. 0) 
     $	    		FilledNeighbors = FilledNeighbors + 1
    		    endif    
		    if (xvar .lt. xmax) then
		        if (iarray(xvar + 1,yvar) .gt. 0)
     $			FilledNeighbors = FilledNeighbors + 1
                    endif
		    if (yvar .gt. 1) then
		        if (iarray(xvar, yvar -1) .gt. 0) 
     $			    FilledNeighbors = FilledNeighbors + 1
		    endif    
		    if (yvar .lt. ymax) then
		        if (iarray(xvar,yvar + 1) .gt. 0)
     $		    	    FilledNeighbors = FilledNeighbors + 1
                    endif
		    if (FilledNeighbors .eq. 3) then
			iarray(xvar,yvar) = 1
		    else if (FilledNeighbors .ne. 0) then
			fullness = 0
			do 600 y = yvar - 2, yvar + 2
			    do 500 x = xvar - 2, xvar + 2
				if ((x .le. xmax) .and. (y .le. ymax)
     $                          .and. (x .ge. 1) .and. (y .ge. 1)) then
				    if ((iarray(x,y) .gt. 0)
     $                                 .and. (lmask(x-xvar+3,y-yvar+3)
     $                                 .eqv. .true.)) fullness =
     $				    fullness + 1
				endif
500    			    continue
600                     continue
                        if (fullness .gt. 10) then
			    iarray(xvar,yvar) = 1
			    AnyFilled = .true.
			endif
		    endif
		endif
300	    continue
200     continue
        if (AnyFilled .eqv. .true.) goto 100
	return
	end




C+++
C
C
C     subroutine pad
C
C     this subroutine will take a phase space array and pad it out by
C     one cellsize on all sides.
C
C---
        subroutine pad(iarray,Xmax, Ymax)
        integer xmax,Ymax
        integer iarray(xmax,Ymax)
        integer xvar,yvar
	integer x,y

        do 100 yvar= 1,ymax
      	    do 200 xvar = 1,xmax
	        do 300 y = yvar-1,yvar + 1
		    do 400 x= xvar - 1, xvar + 1
		        if ((x .lt. xmax) .and. (y .lt. ymax) .and.
     $                      (y .ge. 1) .and. (x .ge. 1) .and. 
     $                      (iarray(x,y) .ge. 1) .and. (iarray(x,y)
     $                       .le. 3) .and. 
     $                        (iarray(xvar,yvar) .eq. 0)) then
			    iarray(xvar,Yvar) = 4
			    goto 500
                        endif
400		    continue
300             continue
500             continue
200         continue
100     continue
        return
	end




C+++
C
C     subroutine readarray
C
C---
	subroutine readarray(xarray, Xbins, X1Bins,
     $                  yarray, Ybins, Y1Bins, zarray,
     $                 Zbins, Z1Bins, infile, liformat)
	implicit none
	integer Xbins, X1Bins
	integer YBins, Y1Bins
	integer ZBins, Z1Bins
	integer Xarray(10000)
	integer Yarray(10000)
	integer Zarray(10000)
	real*8 XBinSize, X1BinSize
	real*8 YBinSize, Y1BinSize
	real*8 ZBinSize, Z1BinSize
        real*8 XStartPosition, X1StartPosition
        real*8 YStartPosition, Y1StartPosition
        real*8 ZStartPosition, Z1StartPosition
	logical liformat
	character*(*) infile
	integer unitnum
	common / stuff / 
     $     XStartPosition, X1StartPosition,
     $     YStartPosition, Y1StartPosition, ZStartPosition,
     $     Z1StartPosition,
     $     XbinSize, X1BinSize, YBinSize, Y1BinSize, ZBinsize,
     $     Z1BinSize
                

	call fopen(infile,unitnum,liformat)
	if (liformat .eqv. .true.) then
	    read(unitnum,*) Xbins, XStartPosition, XbinSize
	    read(unitnum,*) X1Bins, X1StartPosition, X1BinSize 
	    read(unitnum,*) Ybins, YStartPosition, YbinSize
	    read(unitnum,*) Y1Bins, Y1StartPosition, Y1BinSize
	    read(unitnum,*) ZBins, ZStartPosition, ZBinSize
	    read(unitnum,*) Z1Bins, Z1StartPosition, Z1BinSize
	else
	    read(unitnum) Xbins, XStartPosition, XbinSize
	    read(unitnum) X1Bins, X1StartPosition, X1BinSize 
	    read(unitnum) Ybins, YStartPosition, YbinSize
	    read(unitnum) Y1Bins, Y1StartPosition, Y1BinSize
	    read(unitnum) ZBins, ZStartPosition, ZBinSize
	    read(unitnum) Z1Bins, Z1StartPosition, Z1BinSize
	endif
	call lowread(Xarray,Yarray, Zarray, Xbins,X1bins,Ybins,Y1bins,
     $    zbins, Z1bins,unitnum,liformat)
        close(unit = unitnum)
        return
	end

C+++
C
C
C
C     low level readarray subroutine
C
C
C---
	subroutine lowread(Xarray,Yarray, Zarray, Xmax, X1max,
     $    Ymax, Y1max,
     $    zmax, Z1max,unitnum,liformat)
        implicit none
	integer i,j
	integer unitnum
	integer Xmax, X1max
	integer Ymax, Y1max
        integer Zmax, Z1max
	logical liformat
	integer xarray(xmax, x1max)
	integer yarray(ymax, y1max)
	integer zarray(zmax, z1max)
	if (liformat .eqv. .false.) then
	    do 100 i = 1, Xmax
	        read(unitnum) (Xarray(i,j), j = 1, X1max)
100	    continue
	    do 200 i = 1, ymax
	        read(unitnum) (Yarray(i,j), j = 1, Y1max)
200	    continue
	    do 300 i = 1, zmax
	        read(unitnum) (zarray(i,j), j = 1, z1max)
300  	    continue
	else
	    do 400 i = 1, Xmax
	        read(unitnum,*) (Xarray(i,j), j = 1, X1max)
400	    continue
	    do 500 i = 1, ymax
	        read(unitnum,*) (Yarray(i,j), j = 1, Y1max)
500	    continue
	    do 600 i = 1, zmax
	        read(unitnum,*) (zarray(i,j), j = 1, z1max)
600  	    continue
	endif
        return
	end

C+++
C
C     subroutine WriteArray
C
C---
	subroutine WriteArray(Xarray, xbins, x1bins,
     $        Yarray, ybins, y1bins, Zarray, zbins, z1bins,
     $        outfile, loformat)
	implicit none
	integer i, j
	integer Xbins, X1Bins
	integer YBins, Y1Bins
	integer ZBins, Z1Bins
	integer Xarray(Xbins, X1Bins)
	integer Yarray(Ybins, Y1Bins)
	integer Zarray(Zbins, Z1Bins)
	real*8 XBinSize, X1BinSize
	real*8 YBinSize, Y1BinSize
	real*8 ZBinSize, Z1BinSize
        real*8 XStartPosition, X1StartPosition
        real*8 YStartPosition, Y1StartPosition
        real*8 ZStartPosition, Z1StartPosition
	logical loformat
	character*(*) outfile
	integer unitnum
	common / stuff / 
     $     XStartPosition, X1StartPosition,
     $     YStartPosition, Y1StartPosition, ZStartPosition, 
     $     Z1StartPosition,
     $     XbinSize, X1BinSize, YBinSize, Y1BinSize, ZBinsize, Z1BinSize

	call fopen(outfile,unitnum,loformat)
	if (loformat .eqv. .false.) then
	    write(unitnum) Xbins, XStartPosition, XbinSize
	    write(unitnum) X1Bins, X1StartPosition, X1BinSize 
	    write(unitnum) Ybins, YStartPosition, YbinSize
	    write(unitnum) Y1Bins, Y1StartPosition, Y1BinSize
	    write(unitnum) ZBins, ZStartPosition, ZBinSize
	    write(unitnum) Z1Bins, Z1StartPosition, Z1BinSize
	else
	    write(unitnum,*) Xbins, XStartPosition, XbinSize
	    write(unitnum,*) X1Bins, X1StartPosition, X1BinSize 
	    write(unitnum,*) Ybins, YStartPosition, YbinSize
	    write(unitnum,*) Y1Bins, Y1StartPosition, Y1BinSize
	    write(unitnum,*) ZBins, ZStartPosition, ZBinSize
	    write(unitnum,*) Z1Bins, Z1StartPosition, Z1BinSize
	endif
	if (loformat .eqv. .false.) then
	    do 100 i = 1, XBins
	        write(unitnum) (Xarray(i,j), j = 1, X1Bins)
100	    continue
	    do 200 i = 1, yBins
	        write(unitnum) (Yarray(i,j), j = 1, Y1Bins)
200	    continue
	    do 300 i = 1, zBins
	        write(unitnum) (zarray(i,j), j = 1, z1Bins)
300	    continue
	else
	    do 400 i = 1, XBins
	        write(unitnum,*) (Xarray(i,j), j = 1, X1Bins)
400	    continue
	    do 500 i = 1, yBins
	        write(unitnum,*) (Yarray(i,j), j = 1, Y1Bins)
500	    continue
	    do 600 i = 1, zBins
	        write(unitnum,*) (zarray(i,j), j = 1, z1Bins)
600	    continue
	endif
        close(unit = unitnum)
        return
	end

	 




c +++
c	Subroutine 	getpars	
c                       Reads and interprets the argument line params.
c ---
c
	subroutine	getpars	(infile, outfile, liformat, loformat)
	implicit none
	character*(*)	outfile, infile
c
c	external 	iargc, getarg
	character *80 	arg, gfilename
c
c123456789012345678901234567890123456789012345678901234567890123456789
c
	logical		linfile, loutfile
	logical         lgfilename
	logical         lliformat, liformat
	logical         lloformat, loformat
	data  		linfile /.false./, loutfile /.false./
	integer iformat
	integer iargc
	integer icnt
	integer inum
        integer irint
        character*80 rstring
        

c
c Get the argument line parameters and decode them
c
	lgfilename = .false.
	lloformat = .false.
	lliformat = .false.
c	inum = iargc ()
c	if (inum .eq. 0 ) goto 111
c	icnt = 1
c
c 10	continue
c		call getarg (icnt, arg)
c		if (arg (1:3) .eq. '-O ') then
c			icnt = icnt + 1
c			call getarg (icnt, outfile)
c			loutfile = .true.
c		else if (arg(1:3) .eq. '-I ') then
c			icnt = icnt + 1 
c			call getarg(icnt,infile)
c			linfile = .true.
c		else if (arg(1:3) .eq. '-G ' ) then
c			lgfilename = .true.
c			icnt = icnt + 1
c			call getarg(icnt, gfilename)
c		else if (arg(1:3) .eq. '-FI') then
c		     lliformat = .true.
c		     liformat = .true.
c		else if (arg(1:3) .eq. '-UI') then
c		     lliformat = .true.
c		     liformat = .false.
c		else if (arg(1:3) .eq. '-FO') then
c		     lloformat = .true.
c		     loformat = .true.
c		else if (arg(1:3) .eq. '-UO') then
c		     lloformat = .true.
c		     loformat = .false.
c		else
c			call usage ()
c			stop
c		endif
c		icnt = icnt + 1
c	if (icnt .le. inum) goto 10
c111     continue
	if ( linfile .eqv. .false.) then
            infile = rstring('Patch: Input file name: ')
        endif
	if ( loutfile .eqv. .false.) then
            outfile = rstring('Patch: Output file name: ')
	endif
	if (lliformat .eqv. .false.) then
	     iformat = irint('patch: formatted '
     $       //'intput?(1=y, 0=n): ')
	     if (iformat .eq. 1) then
		  liformat = .true.
	     else
		  liformat = .false.
	     endif
	endif
	if (lloformat .eqv. .false.) then
	     iformat =  irint('patch: formatted '
     $       //'output?(1=y, 0=n): ')
	     if (iformat .eq. 1) then
		  loformat = .true.
	     else
		  loformat = .false.
	     endif
	endif
	return
	end
c
	subroutine usage ()
c
	write (*,*)
        write(*,*) 'patch: usage'
        write(*,*) 'patch -i infile -o outfile -fi -fo -ui -uo'
	write (*,*)
	return
	end


C+++
C
C      subroutine fclose routine to close file, possibly put a trailer 
C      on it.
C
C---
	subroutine fclose(unitnum)
	implicit none
	integer unitnum


	close (unit = unitnum)
        return
	end


C +++
C
C       fopen is a safe way of opening files in the case where a collision
C       might occur
C
C ---
        SUBROUTINE      fopen  (FileName, filenum, lformat)
	implicit none
        CHARACTER*(*)   FileName
	integer filenum
	logical isthere
	logical lformat
C
        filenum = 10
 20	CONTINUE
		INQUIRE (UNIT = filenum, OPENED = IsThere)
		IF (.NOT. IsThere) GOTO 30
		filenum = filenum + 1
		GOTO 20
 30	CONTINUE
	if (lformat .eqv. .true.) then
	     OPEN (UNIT=filenum, FILE = FileName, STATUS = 'unknown')
	else
	     open(unit = filenum, file = filename, status='unknown',
     $           form = 'unformatted')
	endif
100     RETURN
        END

